// =============================================================
// File:     WHCmultichoice.js
// Contents: Basic scripts used for multi-choice activities
// Revised:  13 Jan 2000
// Copyright (c) 1997-2000 William Horton Consulting, Inc.
// =============================================================

function hMultiChoice() {
	this.ID = null          // Unique identifier for this question
	this.parent = null
	this.intro = ""               // Introductory text, usually the question itself
	this.possiblescore = 0        // Highest possible score
	this.messageRight = ""
	this.messageWrong = ""
	this.answers = new Array()     // Answer objects (zero-based)
	this.showAnswers = multiChoiceShowAnswers
	this.reset = multiChoiceReset
	this.generateDisplay = multiChoiceGenerateDisplay
	this.addAnswer = multiChoiceAddAnswer
	this.setAnswers = multiChoiceSetAnswers
	this.setFlags = multiChoiceSetFlags
	this.saveAnswers = multiChoicesaveAnswers
	this.generateFeedback = multiChoiceGenerateFeedback
	this.generateScore = multiChoiceGenerateScore
}

function multiChoiceGenerateDisplay(){
	var theHTML = ""
	theHTML += "<p>" + this.intro + "</p>"
	theHTML += "<form name='Frm" + this.ID + "'>\r"
	theHTML += "<table border='0' width='100%'>\r"
	for (var i=0; i< this.answers.length; i++) {
		theHTML += multiChoiceMakeRow(i, this.answers[i], this.ID)
	}
	theHTML += "</table></form><br>\r"
	if ((this.parent.type == "test") && (this.parent.showFeedback)) {
		theHTML += this.parent.feedback.formatEmbeddedMessage(this.generateFeedback())
	}
	return theHTML
}

function multiChoiceGenerateFeedback() {
	// alert(this.ID + ": multiChoiceGenerateFeedback()")
	var myFeedback = ""
	var theScore = this.generateScore()
	if (theScore == this.possibleScore) {
		myFeedback += this.messageRight + "\r"
	} else {
		myFeedback += this.messageWrong + "\r"
	}
	for (i=0; i < this.answers.length; i++) {
		if (this.answers[i].isRight || this.answers[i].chosen ) { // chosen or should have been
			myFeedback += this.answers[i].feedback + "\r"
		}
	}
	myFeedback += "Score: " + this.generateScore() + " of " + this.possibleScore + " points.\r"

	// alert("ready to return from multiChoiceGenerateFeedback")
	return myFeedback
}

function multiChoiceShowAnswers(){
	// alert(this.ID + ": multiChoiceShowAnswer()")
	this.setAnswers("Right")
	var myFeedback = this.generateFeedback()
	this.setFlags("Score")
	return myFeedback
}

function multiChoiceSetAnswers(typeAction) {
	// alert("In multiChoiceSetAnswers() with typeAction = " + typeAction)
	if (typeAction == "Initial") {
		for (i=0; i<this.answers.length; i++) {
			document.forms["Frm" + this.ID].elements[i].checked = this.answers[i].initiallyChosen
			this.answers[i].chosen = this.answers[i].initiallyChosen
			// alertthis.ID + ": Ans: " + i + ": .initiallyChosen=" + this.answers[i].initiallyChosen)
		}
	} else if (typeAction == "Current") {
		for (i=0; i<this.answers.length; i++) {
			document.forms["Frm" + this.ID].elements[i].checked = this.answers[i].chosen
		}
	} else if (typeAction == "Right") {
		// alert("In multiChoiceSetAnswers Right")
			for (i=0; i<this.answers.length; i++) {
				// alert("For " + this.ID + ": Ans " + i + " this.answers[i].isRight=" + this.answers[i].isRight)
				document.forms["Frm" + this.ID].elements[i].checked = this.answers[i].isRight
				this.answers[i].chosen = this.answers[i].isRight
			}
	} else {
		 alert("multiChoiceSetAnswers(): typeAction of : " + typeAction + " not recognized.")
	}
}

function multiChoiceSetFlags(typeAction) {
	// alert ("In multiChoiceSetFlags with typeAction = " + typeAction)
	if (typeAction == "Clear") {
		for (i=0; i<this.answers.length; i++) {
			document.images["Img" + this.ID + i].src="art/testscorenone.gif"
		}
	} else if (typeAction == "Score") {
		for (i=0; i<this.answers.length; i++) {
			if (this.answers[i].isRight) { // right answer
				if (this.answers[i].chosen) {  // right answer chosen
					document.images["Img" + this.ID + i].src="art/testscoreright.gif" + "\r"
				} else {  // right answer unchosen
					document.images["Img" + this.ID + i].src="art/testscoreright_red.gif" + "\r"	
				}
			} else { // wrong answer
					if (this.answers[i].chosen) {  // wrong answer chosen
					document.images["Img" + this.ID + i].src="art/testscorewrong.gif" + "\r"
				} else {  // wrong answer unchosen
					document.images["Img" + this.ID + i].src="art/testscorenone.gif" + "\r"	
				}
			}
		}
	} else {
		 alert("multiChoiceSetFlags(): typeAction of : " + typeAction + " not recognized.")
	}
}

function multiChoiceReset(){
	// alert("In multiChoiceReset() in Question " + this.ID)
	this.setFlags("Clear")
	this.setAnswers("Initial")
}


function multiChoiceAddAnswer(theAnswer) {
	// Replace with generic?
	if (theAnswer != null) {
		this.answers[this.answers.length] = theAnswer
	}
}

// Constructs the specific rows of the test initially.
function multiChoiceMakeRow(rowNum, theAnswer, theID) {

	theImg = "../art/testscorenone.gif"

	theRow = "<tr>\r"
	
	theRow += "   <td align='left' valign='top' width='10'><img name=\"Img" + theID + rowNum + "\" "
	theRow += "src=\"" + theImg + "\"></td>\r"
	
	theRow += "   <td valign='top' width='10'><input type='checkbox' name='Checkbox" + theID + "' "
	theRow += "value='" + this.ID + rowNum + "' "
	theRow += "onClick='theTest.questions[" + theID + "].saveAnswers()'"
	
	theRow += "></td>\r"
	
	theRow +="   <td width='545'><FONT FACE='Verdana,Arial' SIZE='2'>" + theAnswer.text + "</td>\r"
	
	theRow += "</tr>\r"
	return theRow
}

function multiChoicesaveAnswers() {
	for (i = 0; i < this.answers.length; i++) {
		this.answers[i].chosen = document.forms["Frm" + this.ID].elements[i].checked
	}
}

function multiChoiceGenerateScore() {
	// This function uses the fraction of right answers rather than points for each answer.
	var theScore = 0
	var theAnswer
	for (i=0; i < this.answers.length; i++) {
		theAnswer = this.answers[i]
		if (theAnswer.isRight && theAnswer.chosen) {
			theScore += this.answers[i].points
		} 
		else if (!theAnswer.isRight && theAnswer.chosen){
			theScore -= this.answers[i].points
		}
	}
	return theScore
}

