// =============================================================
// File:     WHCtests.js
// Contents: Basic objects and functions used by tests
// Copyright (c) 1999 William Horton Consulting, Inc.
// Requires: Scripts: Bouncer.js
// =============================================================

// Test level objects and functions ============================

function hTest(testTitle, testType, testIntro, testMessage) {
	// Basic properties
	this.title = testTitle
	this.intro = testIntro
	this.type = testType.toLowerCase()
	this.messageHint = ""
	this.currentScore = 0
	this.possibleScore = 0
	// Content of the test
	this.questions = new Array() // Array of activity objects
	this.buttons = new hButtons()
	this.feedback = new hFeedback(testMessage)
	this.isIE4Plus = ((BouncerGetBrowser() == "Internet Explorer") &&(BouncerGetVersion() >= 4))
	// Public methods
	this.evaluate = testEvaluate
	this.showAnswers = testShowAnswers
	this.reset = testReset
	this.generateDisplay = testGenerateDisplay
	this.addQuestion = testAddQuestion
	this.make = testMake
	this.scoreThisPage = testScoreThisPage
	this.displayScorePage = testDisplayScorePage
	// Experimental
	this.getNumTextMatches = testGetNumTextMatches
	this.showFeedback = false // Whether to display feedback in test mode
}

function testEvaluate() {
	this.showFeedback = true
	if (this.type == "practice") {
		var theFeedback = ""
		for (var i=0; i< this.questions.length; i++) {
			this.questions[i].setFlags("Score")
			if (this.questions.length > 1) {
				theFeedback += "Exercise " + (i+1) + ":\r"
			}
			theFeedback += this.questions[i].generateFeedback()
			theFeedback += "\r"
		}
		this.feedback.postMessage(theFeedback)
	} else { // is Test 
		var possibleScore = 0
		var currentScore = 0
		for (var i=0; i < this.questions.length; i++) {
			possibleScore += this.questions[i].possibleScore
			currentScore += this.questions[i].generateScore()
		}
		this.currentScore = currentScore
		this.possibleScore = possibleScore
		if (this.isIE4Plus) {
			this.scoreThisPage()
		} else { 
			for (var i=0; i<this.questions.length; i++) {
				this.questions[i].setFlags("Score")
			}
			this.displayScorePage()
		}
		
	}
}

function testShowAnswers() {
	var theFeedback = ""
	for (var i=0; i< this.questions.length; i++) {
		theFeedback += this.questions[i].showAnswers()
	}
}

function hButtons() {
	this.generateDisplay = generateButtonsDisplay;
}

// This one works just fine
function generateButtonsDisplay() {
	var theHTML = ""
	theHTML += "<DIV ALIGN='CENTER'><TABLE width='100%' border='0' cellspacing='5' cellpadding='2'>"
	theHTML += "<TR height='15' valign='top'>\r"
	
	if (theTest.type == "practice") {

	theHTML += "<TD align='center' width='5%'></td>\r"
	theHTML += "<TD align='left' width='10%'><A HREF='JavaScript:theTest.evaluate()'><IMG SRC='art/testEval1.gif' border='0'></a></td>\r"
	theHTML += "<td align='left' width='10%'><A HREF='JavaScript:theTest.showAnswers()'><IMG SRC='art/testShow1.gif' border='0'></a></td>\r"
	if (theTest.messageHint.length > 0) {
		theHTML += "<td align='left' width='10%'><A HREF='JavaScript:theTest.feedback.postMessage(theTest.messageHint)'><IMG SRC='art/testHint1.gif' border='0'></a></td>\r"	
	}
	theHTML += "<td align='left' width='10%'><A HREF='JavaScript:theTest.reset()'><IMG SRC='art/testReset1.gif' border='0'></a></td>"
	theHTML += "<TD align='center' width='5%'></td>\r"
	} else { // theTest.type == "Test"

	theHTML += "<TD align='right'><A HREF='JavaScript:theTest.evaluate()'><IMG SRC='art/testEval1.gif' border='0'></a></td>\r"
	theHTML += "<td align='left'><A HREF='JavaScript:theTest.reset()'><IMG SRC='art/testReset1.gif' border='0'></a></td>"
	
	}
	
	theHTML += "</tr></table></DIV><br>"	
	return theHTML
}

function testScoreThisPage() {
	for (var i=0; i<this.questions.length; i++) {
		// Flag correct and incorrect answers
		this.questions[i].setFlags("Score")
		// Post feedback on each choice
		document.all["FeedbackQ" + i].style.display = "block"
		document.all["FeedbackQ" + i].innerHTML = this.feedback.formatEmbeddedMessage(this.questions[i].generateFeedback())
		document.all["Score"].style.display = "block"
		document.all["Score"].innerHTML = "<h2>Score: " + this.currentScore + " of " + this.possibleScore + "</h2>"
	}
}

function testDisplayScorePage() {
	var theHTML = ""
	theHTML += "<BODY>"
	theHTML += "<DIV ALIGN='CENTER'><TABLE WIDTH='100%' CELLPADDING='0' CELLSPACING='0' BORDER='0' BGCOLOR='#FFFFFF'>"
	theHTML += "<TR><TD>\r"
	theHTML += "\r<STYLE TYPE='TEXT/CSS'></STYLE><LINK REL='stylesheet' HREF='styles/WBTExamples.css'>"
	theHTML += "<H1>Score Card</H1>"
	theHTML += "<H2>" + this.title + "</H2>\r"

	theHTML += "<p><b>Score: " + this.currentScore + " of " + this.possibleScore + "</b><br><br></p>"
	theHTML += "</TD></TR>"
	
	// Plug in each question's feedback ------------
	for (var i=0; i< this.questions.length; i++) {
		theHTML += "<TR><TD>\r"
		if (this.questions.length > 1) {
			theHTML += "<SPAN CLASS='tableheadblue'>Question " + (i+1) + ":</SPAN>"
		}
		// Modify this to signal the type of feedback requested:
		theHTML += this.feedback.formatEmbeddedMessage(this.questions[i].generateFeedback())
		theHTML += "</TD></TR>\r"
	}
		
	// Close up shop
	theHTML += "</TABLE></DIV>\r"
	
	theHTML += "</BODY>\r"
	
	// Create the window
	var scoreWin = window.open("","","HEIGHT=500,WIDTH=600,SCROLLBARS")
	scoreWin.document.open()
	scoreWin.document.write(theHTML)
	scoreWin.document.close()
	
}

function testReset() {
	var theFeedback = ""
	this.showFeedback = false
	for (var i=0; i< this.questions.length; i++) {
		this.questions[i].reset()
	}
	if (this.type == "practice") {
		this.feedback.postMessage(this.feedback.initialMessage)
	}
	if (this.type == "test" && this.isIE4Plus) {
		for (var i=0; i<this.questions.length; i++) {
			document.all["FeedbackQ" + i].style.display = "none"
			document.all["FeedbackQ" + i].innerHTML = ""
		}
	}
}

function testGenerateDisplay(typeDisplay) {
	var theHTML = ""
	// Start table ----------------------
	theHTML += "<BR>"
	theHTML += "<DIV ALIGN='CENTER'><TABLE WIDTH='100%' CELLPADDING='0' CELLSPACING='0' BORDER='0' BGCOLOR='#FFFFFF'>"
	theHTML += "<TR><TD>\r"
	
	// Add title and intro --------------
	theHTML += "<H2>" + this.title + "</H2>\r"
	theHTML += "<p>" + this.intro + "</p><br>\r"
	if (this.isIE4Plus && (this.type == "test")) {
		theHTML += "\r<DIV ID='Score' STYLE='display:none'></DIV>"
	}
	theHTML += "</TD></TR>"
	
	// Plug in each question ------------
	for (var i=0; i< this.questions.length; i++) {
		theHTML += "<TR><TD>\r"
		if (this.questions.length > 1) {
		    theHTML += "<IMG SRC='art/base1.gif' HEIGHT='1' WIDTH='100%'><BR>\r"
			theHTML += "<SPAN CLASS='tableheadblue'>Exercise " + (i+1) + ":</SPAN>"
		}
		theHTML += this.questions[i].generateDisplay()
		if (this.isIE4Plus && (this.type == "test")) {
			theHTML += "\r<DIV ID='FeedbackQ" + i + "' STYLE='display:none'></DIV>"
		} 
		theHTML += "</TD></TR>\r"
	}
	
	// Add the buttons

	theHTML += "<TR><TD>\r"
	theHTML += this.buttons.generateDisplay()
	theHTML += "</TD></TR>\r"

	// Add the feedback
	if (this.type == "practice") {
		theHTML += "<TR><TD>"
		theHTML += this.feedback.generateDisplay()
		theHTML += "</TD></TR><BR>"
	}
	
	// Close up shop and send it back
	theHTML += "</TABLE></DIV>\r"
	
	return theHTML
}

function testMake(typeDisplay) {
	document.open()
	document.write(this.generateDisplay(typeDisplay))
	for (var i = 0; i < this.questions.length; i++) {
		this.questions[i].reset()
		this.questions[i].setAnswers("Current")
	}
	document.close()
}

function testAddQuestion(theQuestion) {
	if (theQuestion != null) {
		// alert("activity.length = " + this.questions.length)
		var theIndex = this.questions.length
		this.questions[theIndex] = theQuestion
		this.questions[theIndex].ID = theIndex
		this.questions[theIndex].parent = this
	}
}

// Buttons objects and methods ==================================

function hButtons() {
	this.generateDisplay = generateButtonsDisplay;
}

// Feedback objects and methods ==================================

function hFeedback(initialMessage) {
	this.initialMessage = initialMessage
	this.message = initialMessage
	this.generateDisplay = feedbackGenerateDisplay
	this.postMessage = feedbackPostMessage
	this.formatEmbeddedMessage = feedbackFormatEmbeddedMessage
}

function feedbackGenerateDisplay() {
	var theHTML = ""
	theHTML += "<TABLE CELLSPACING='0' WIDTH='100%' CELLPADDING='0' BORDER='0' BGCOLOR='#FFFFFF'><TR valign='top'><TD>\r"
	theHTML += "<form name='feedbackForm'>\r"
	theHTML += "<textarea name='messageArea' cols='110' rows='5' wrap='VIRTUAL'>" + this.initialMessage + "</textarea>\r"
	theHTML += "</form>\r"
	theHTML += "</td></TR></TABLE>\r"
	return theHTML	
}

function feedbackPostMessage(theMessage){
	document.feedbackForm.messageArea.value = theMessage
}

function feedbackFormatEmbeddedMessage(theMessage) {
	var newMessage = ""
	if (theMessage.length > 0) {
		newMessage = "<p>" + theMessage + "</p><BR>"
	}
	return newMessage
}

// Generic objects and functions =====================================================

function hAnswer(answerText, answerFeedback, answerIsRight, answerPoints, initiallyChosen) {
//	alert("Hi")
	this.text = answerText
	this.feedback = answerFeedback
	this.isRight = false
	if (answerIsRight) { this.isRight = true }
	this.points = 0
	if (!(answerPoints == null)) {
		this.points = parseInt(answerPoints)
	}
	this.chosen = false
	this.initiallyChosen = false
	if (initiallyChosen) {
		this.chosen = true
		this.initiallyChosen = true
	}
}

function resetFlags(questionID, numOfImages) {
	for (i=0; i < numOfImages; i++) {
		document.images["Img" + questionID + i].src="art/testscorenone.gif"
	}
}

// Experimental objects and functions =====================================================

function testGetNumTextMatches(textString, arrayOfPatterns) {
	var numCorrect = 0
	for (var i = 0; i < arrayOfPatterns.length; i++ ) {
		if (textString.match(eval(arrayOfPatterns[i]))) {
			numCorrect++
		}
	}
	return numCorrect
}

function spaceOutLines(theString, theLineSpacing) {
// Puts space between lines of a string
	var theSpacer = "<IMG SRC='art/spacer.gif' width='1' height='" + theLineSpacing + "'>"
	//var theTarget = / /g
	//var theNewString = theString.replace(theTarget, " " + theSpacer)
	var theTarget = /<BR>/g
	var theNewString = theString.replace(theTarget, "<BR>" + theSpacer)
	theTarget = /&nbsp;/g
	theNewString = theNewString.replace(theTarget, "&nbsp;" + theSpacer)
	return theNewString
}

// Rollover scripts ============================================
function MM_displayStatusMsg(msgStr) { //v2.0
  status=msgStr;
  document.MM_returnValue = true;
  //alert("In mm-displaystatus")
}

