// =============================================================
// File:     WHCtruefalse.js
// Contents: Basic scripts used for true-false activities
// Revised:  2-July-1999
// Copyright (c) 1997-1999 William Horton Consulting, Inc.
// =============================================================

function hTrueFalse() {
	this.ID = null          // Unique identifier for this question
	this.parent = null      // Test of which this is a part
	this.intro = ""               // Introductory text, usually the question itself
	this.possibleScore = 0        // Highest possible score
	this.messageRight = ""
	this.messageWrong = ""
	// Answer is built in
	this.questionText = ""
	this.trueLabel = "True"
	this.falseLabel = "False"
	this.initialAnswer = null
	this.rightAnswer = null
	this.currentAnswer = null
	// this.answers = new Array()     // Answer objects (zero-based)
	this.showAnswers = trueFalseShowAnswers
	this.reset = trueFalseReset
	this.generateDisplay = trueFalseGenerateDisplay
	// this.addAnswer = trueFalseAddAnswer
	this.setAnswers = trueFalseSetAnswers
	this.setFlags = trueFalseSetFlags
	this.saveAnswers = trueFalseSaveAnswers
	this.generateFeedback = trueFalseGenerateFeedback
	this.generateScore = trueFalseGenerateScore
}

function trueFalseGenerateDisplay(){
	var theHTML = ""
	if (this.intro.length > 0) {
		theHTML += "<P>" + this.intro + "</P>"
	}
	theHTML += "<form name='Frm" + this.ID + "'>\r"
	theHTML += "<DIV ALIGN='CENTER'>"
	theHTML += "<table border='0' width='100%' cellpadding='0' cellspacing='0'>\r"
	theHTML += "<tr><td width='30' align='left' valign='top'>"
	theHTML += "<img name='Img" + this.ID + "' "
	theHTML += "src='art/testscorenone.gif'></td>\r"
	theHTML += "<td valign='top'>"
	theHTML += "<input type='radio' name='Radio" + this.ID + "' "
	theHTML += "value='Radio" + this.ID + "True' "
	theHTML += "onClick='theTest.questions[" + this.ID + "].saveAnswers()'>"
	theHTML += "&nbsp;<SPAN CLASS='formtext'>" + this.trueLabel + "&nbsp;&nbsp;&nbsp;</SPAN>"
	theHTML += "<input type='radio' name='Radio" + this.ID + "' "
	theHTML += "value='Radio" + this.ID + "False' "
	theHTML += "onClick='theTest.questions[" + this.ID + "].saveAnswers()'>"
	theHTML += "&nbsp;<SPAN CLASS='formtext'>" + this.falseLabel + "</SPAN></td>"
	theHTML += "<td width='350'><FONT FACE='Verdana,Arial' SIZE='2'>"
	theHTML += this.questionText + "</td>\r"
	theHTML += "</tr></table><br></DIV></form>"
	if ((this.parent.type == "test") && (this.parent.showFeedback)) {
		theHTML += this.parent.feedback.formatEmbeddedMessage(this.generateFeedback()) + "<BR>"
	}
	return theHTML
}

function trueFalseGenerateFeedback() {
	var myFeedback = ""
	myFeedback += ""
	if (this.rightAnswer != this.currentAnswer) {
		myFeedback += this.messageWrong + "\r"
	} else {
		myFeedback += this.messageRight + "\r"
	} 
	myFeedback += "Score: " + this.generateScore() + " of " + this.possibleScore + " points.\r"
	return myFeedback
}

function trueFalseShowAnswers(){
	this.setAnswers("Right")
	var myFeedback = this.generateFeedback()
	this.setFlags("Score")
	return myFeedback
}

function trueFalseSetAnswers(typeAction) {
	var theAnswer
	if (typeAction == "Initial") {theAnswer = this.initialAnswer}
	else if (typeAction == "Current")  {theAnswer = this.currentAnswer}
	else if (typeAction == "Right")  {theAnswer = this.rightAnswer}
	else {
		 alert("trueFalseSetAnswers(): typeAction of : " + typeAction + " not recognized.")
	}
	this.currentAnswer = theAnswer
	if (theAnswer == null) {
		document.forms["Frm" + this.ID].elements[0].checked = false		
		document.forms["Frm" + this.ID].elements[1].checked = false
	} else {
		if (theAnswer) {
			document.forms["Frm" + this.ID].elements[0].checked = true
		} else {
			document.forms["Frm" + this.ID].elements[1].checked = true
		}
	}
}

function trueFalseSetFlags(typeAction) {
	// alert ("In trueFalseSetFlags with typeAction = " + typeAction)
	if (typeAction == "Clear") {
		document.images["Img" + this.ID].src="art/testscorenone.gif"
	} else if (typeAction == "Score") {
		if (this.currentAnswer == this.rightAnswer) {
			document.images["Img" + this.ID].src="art/testscoreright.gif"
		} else {
			document.images["Img" + this.ID].src="art/testscorewrong.gif"
		}
	} else {
		 alert("trueFalseSetFlags(): typeAction of : " + typeAction + " not recognized.")
	}
}

function trueFalseReset(){
	// alert("In trueFalseReset() in Question " + this.ID)
	this.setFlags("Clear")
	this.setAnswers("Initial")
}


function trueFalseSaveAnswers() {	
	this.currentAnswer = document.forms["Frm" + this.ID].elements[0].checked
}
	
function trueFalseGenerateScore() {
	var theScore = 0
	if (this.currentAnswer == this.rightAnswer) {
		theScore += this.possibleScore
	}
	return theScore
}
		

