/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PConstants;
import processing.core.PGraphics;

public class PLine
implements PConstants {
    static final int R_COLOR = 1;
    static final int R_ALPHA = 2;
    static final int R_SPATIAL = 8;
    static final int R_THICK = 4;
    static final int R_SMOOTH = 16;
    private int[] m_pixels;
    private float[] m_zbuffer;
    private int m_index;
    private int SCREEN_WIDTH;
    private int SCREEN_HEIGHT;
    private int SCREEN_WIDTH1;
    private int SCREEN_HEIGHT1;
    public boolean INTERPOLATE_RGB;
    public boolean INTERPOLATE_ALPHA;
    public boolean INTERPOLATE_Z = false;
    public boolean INTERPOLATE_THICK;
    private boolean SMOOTH;
    private int m_stroke;
    public int m_drawFlags;
    private float[] x_array = new float[2];
    private float[] y_array = new float[2];
    private float[] z_array = new float[2];
    private float[] r_array = new float[2];
    private float[] g_array = new float[2];
    private float[] b_array = new float[2];
    private float[] a_array = new float[2];
    private int o0;
    private int o1;
    private float m_r0;
    private float m_g0;
    private float m_b0;
    private float m_a0;
    private float m_z0;
    private float dz;
    private float dr;
    private float dg;
    private float db;
    private float da;
    private PGraphics parent;

    public void reset() {
        this.SCREEN_WIDTH = this.parent.width;
        this.SCREEN_HEIGHT = this.parent.height;
        this.SCREEN_WIDTH1 = this.SCREEN_WIDTH - 1;
        this.SCREEN_HEIGHT1 = this.SCREEN_HEIGHT - 1;
        this.m_pixels = this.parent.pixels;
        this.m_zbuffer = this.parent.zbuffer;
        this.INTERPOLATE_RGB = false;
        this.INTERPOLATE_ALPHA = false;
        this.m_drawFlags = 0;
        this.m_index = 0;
    }

    public void setVertices(float f, float f2, float f3, float f4, float f5, float f6) {
        if (f3 != f6 || f3 != 0.0f || f6 != 0.0f || this.INTERPOLATE_Z) {
            this.INTERPOLATE_Z = true;
            this.m_drawFlags |= 8;
        } else {
            this.INTERPOLATE_Z = false;
            this.m_drawFlags &= 0xFFFFFFF7;
        }
        this.z_array[0] = f3;
        this.z_array[1] = f6;
        this.x_array[0] = f;
        this.x_array[1] = f4;
        this.y_array[0] = f2;
        this.y_array[1] = f5;
    }

    public void setIntensities(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.a_array[0] = (f4 * 253.0f + 1.0f) * 65536.0f;
        this.a_array[1] = (f8 * 253.0f + 1.0f) * 65536.0f;
        if (f4 != 1.0f || f8 != 1.0f) {
            this.INTERPOLATE_ALPHA = true;
            this.m_drawFlags |= 2;
        } else {
            this.INTERPOLATE_ALPHA = false;
            this.m_drawFlags &= 0xFFFFFFFD;
        }
        this.r_array[0] = (f * 253.0f + 1.0f) * 65536.0f;
        this.r_array[1] = (f5 * 253.0f + 1.0f) * 65536.0f;
        this.g_array[0] = (f2 * 253.0f + 1.0f) * 65536.0f;
        this.g_array[1] = (f6 * 253.0f + 1.0f) * 65536.0f;
        this.b_array[0] = (f3 * 253.0f + 1.0f) * 65536.0f;
        this.b_array[1] = (f7 * 253.0f + 1.0f) * 65536.0f;
        if (f != f5) {
            this.INTERPOLATE_RGB = true;
            this.m_drawFlags |= 1;
        } else if (f2 != f6) {
            this.INTERPOLATE_RGB = true;
            this.m_drawFlags |= 1;
        } else if (f3 != f7) {
            this.INTERPOLATE_RGB = true;
            this.m_drawFlags |= 1;
        } else {
            this.m_stroke = 0xFF000000 | (int)(255.0f * f) << 16 | (int)(255.0f * f2) << 8 | (int)(255.0f * f3);
            this.INTERPOLATE_RGB = false;
            this.m_drawFlags &= 0xFFFFFFFE;
        }
    }

    public void setIndex(int n) {
        this.m_index = n;
        if (this.m_index == -1) {
            this.m_index = 0;
        }
    }

    public void draw() {
        int n;
        int n2;
        int n3;
        boolean bl = true;
        if (this.parent.smooth) {
            this.SMOOTH = true;
            this.m_drawFlags |= 0x10;
        } else {
            this.SMOOTH = false;
            this.m_drawFlags &= 0xFFFFFFEF;
        }
        if (this.parent.hints[6]) {
            float f = -this.SCREEN_WIDTH;
            float f2 = -this.SCREEN_HEIGHT;
            float f3 = this.SCREEN_WIDTH * 2;
            float f4 = this.SCREEN_HEIGHT * 2;
            if (this.x_array[1] < f || this.x_array[1] > f3 || this.x_array[0] < f || this.x_array[0] > f3 || this.y_array[1] < f2 || this.y_array[1] > f4 || this.y_array[0] < f2 || this.y_array[0] > f4) {
                return;
            }
        }
        if (!(bl = this.lineClipping())) {
            return;
        }
        boolean bl2 = false;
        if (this.x_array[1] < this.x_array[0]) {
            float f = this.x_array[1];
            this.x_array[1] = this.x_array[0];
            this.x_array[0] = f;
            f = this.y_array[1];
            this.y_array[1] = this.y_array[0];
            this.y_array[0] = f;
            f = this.z_array[1];
            this.z_array[1] = this.z_array[0];
            this.z_array[0] = f;
            f = this.r_array[1];
            this.r_array[1] = this.r_array[0];
            this.r_array[0] = f;
            f = this.g_array[1];
            this.g_array[1] = this.g_array[0];
            this.g_array[0] = f;
            f = this.b_array[1];
            this.b_array[1] = this.b_array[0];
            this.b_array[0] = f;
            f = this.a_array[1];
            this.a_array[1] = this.a_array[0];
            this.a_array[0] = f;
        }
        int n4 = (int)this.x_array[1] - (int)this.x_array[0];
        int n5 = (int)this.y_array[1] - (int)this.y_array[0];
        if (Math.abs(n5) > Math.abs(n4)) {
            int n6 = n5;
            n5 = n4;
            n4 = n6;
            bl2 = true;
        }
        if (n4 < 0) {
            this.o0 = 1;
            this.o1 = 0;
            n3 = (int)this.x_array[1];
            n2 = (int)this.y_array[1];
            n = -n4;
        } else {
            this.o0 = 0;
            this.o1 = 1;
            n3 = (int)this.x_array[0];
            n2 = (int)this.y_array[0];
            n = n4;
        }
        int n7 = n == 0 ? 0 : (n5 << 16) / n4;
        this.m_r0 = this.r_array[this.o0];
        this.m_g0 = this.g_array[this.o0];
        this.m_b0 = this.b_array[this.o0];
        if (this.INTERPOLATE_RGB) {
            this.dr = (this.r_array[this.o1] - this.r_array[this.o0]) / (float)n;
            this.dg = (this.g_array[this.o1] - this.g_array[this.o0]) / (float)n;
            this.db = (this.b_array[this.o1] - this.b_array[this.o0]) / (float)n;
        } else {
            this.dr = 0.0f;
            this.dg = 0.0f;
            this.db = 0.0f;
        }
        this.m_a0 = this.a_array[this.o0];
        this.da = this.INTERPOLATE_ALPHA ? (this.a_array[this.o1] - this.a_array[this.o0]) / (float)n : 0.0f;
        this.m_z0 = this.z_array[this.o0];
        this.dz = this.INTERPOLATE_Z ? (this.z_array[this.o1] - this.z_array[this.o0]) / (float)n : 0.0f;
        if (n == 0) {
            if (this.INTERPOLATE_ALPHA) {
                this.drawPoint_alpha(n3, n2);
            } else {
                this.drawPoint(n3, n2);
            }
            return;
        }
        if (this.SMOOTH) {
            this.drawLine_smooth(n3, n2, n7, n, bl2);
        } else if (this.m_drawFlags == 0) {
            this.drawLine_plain(n3, n2, n7, n, bl2);
        } else if (this.m_drawFlags == 2) {
            this.drawLine_plain_alpha(n3, n2, n7, n, bl2);
        } else if (this.m_drawFlags == 1) {
            this.drawLine_color(n3, n2, n7, n, bl2);
        } else if (this.m_drawFlags == 3) {
            this.drawLine_color_alpha(n3, n2, n7, n, bl2);
        } else if (this.m_drawFlags == 8) {
            this.drawLine_plain_spatial(n3, n2, n7, n, bl2);
        } else if (this.m_drawFlags == 10) {
            this.drawLine_plain_alpha_spatial(n3, n2, n7, n, bl2);
        } else if (this.m_drawFlags == 9) {
            this.drawLine_color_spatial(n3, n2, n7, n, bl2);
        } else if (this.m_drawFlags == 11) {
            this.drawLine_color_alpha_spatial(n3, n2, n7, n, bl2);
        }
    }

    public boolean lineClipping() {
        int n = this.lineClipCode(this.x_array[0], this.y_array[0]);
        int n2 = this.lineClipCode(this.x_array[1], this.y_array[1]);
        int n3 = n | n2;
        if ((n & n2) != 0) {
            return false;
        }
        if (n3 != 0) {
            float f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            float f4 = 0.0f;
            int n4 = 0;
            while (n4 < 4) {
                if ((n3 >> n4) % 2 == 1) {
                    f4 = this.lineSlope(this.x_array[0], this.y_array[0], this.x_array[1], this.y_array[1], n4 + 1);
                    if ((n >> n4) % 2 == 1) {
                        f2 = f4 > f2 ? f4 : f2;
                    } else {
                        f3 = f4 < f3 ? f4 : f3;
                    }
                }
                ++n4;
            }
            if (f2 > f3) {
                return false;
            }
            float f5 = this.x_array[0];
            float f6 = this.y_array[0];
            this.x_array[0] = f5 + f2 * (this.x_array[1] - f5);
            this.y_array[0] = f6 + f2 * (this.y_array[1] - f6);
            this.x_array[1] = f5 + f3 * (this.x_array[1] - f5);
            this.y_array[1] = f6 + f3 * (this.y_array[1] - f6);
            if (this.INTERPOLATE_RGB) {
                f = this.r_array[0];
                this.r_array[0] = f + f2 * (this.r_array[1] - f);
                this.r_array[1] = f + f3 * (this.r_array[1] - f);
                f = this.g_array[0];
                this.g_array[0] = f + f2 * (this.g_array[1] - f);
                this.g_array[1] = f + f3 * (this.g_array[1] - f);
                f = this.b_array[0];
                this.b_array[0] = f + f2 * (this.b_array[1] - f);
                this.b_array[1] = f + f3 * (this.b_array[1] - f);
            }
            if (this.INTERPOLATE_ALPHA) {
                f = this.a_array[0];
                this.a_array[0] = f + f2 * (this.a_array[1] - f);
                this.a_array[1] = f + f3 * (this.a_array[1] - f);
            }
        }
        return true;
    }

    private final int lineClipCode(float f, float f2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.SCREEN_WIDTH1;
        int n2 = this.SCREEN_HEIGHT1;
        int n3 = (f2 < (float)bl2 ? 8 : 0) | (f2 > (float)n2 ? 4 : 0) | (f < (float)bl ? 2 : 0);
        int n4 = 0;
        if (f > (float)n) {
            n4 = 1;
        }
        return n3 | n4;
    }

    private final float lineSlope(float f, float f2, float f3, float f4, int n) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.SCREEN_WIDTH1;
        int n3 = this.SCREEN_HEIGHT1;
        switch (n) {
            case 4: {
                return ((float)bl2 - f2) / (f4 - f2);
            }
            case 3: {
                return ((float)n3 - f2) / (f4 - f2);
            }
            case 2: {
                return ((float)bl - f) / (f3 - f);
            }
            case 1: {
                return ((float)n2 - f) / (f3 - f);
            }
        }
        return -1.0f;
    }

    private final void drawPoint(int n, int n2) {
        float f = this.m_z0;
        int n3 = n2 * this.SCREEN_WIDTH + n;
        if (f <= this.m_zbuffer[n3]) {
            this.m_pixels[n3] = this.m_stroke;
            this.m_zbuffer[n3] = f;
        }
    }

    private final void drawPoint_alpha(int n, int n2) {
        int n3 = (int)this.a_array[0];
        int n4 = this.m_stroke & 0xFF0000;
        int n5 = this.m_stroke & 0xFF00;
        int n6 = this.m_stroke & 0xFF;
        float f = this.m_z0;
        int n7 = n2 * this.SCREEN_WIDTH + n;
        if (f <= this.m_zbuffer[n7]) {
            int n8 = n3 >> 16;
            int n9 = this.m_pixels[n7];
            int n10 = n9 & 0xFF00;
            int n11 = n9 & 0xFF;
            n9 &= 0xFF0000;
            n9 += (n4 - n9) * n8 >> 8;
            n10 += (n5 - n10) * n8 >> 8;
            n11 += (n6 - n11) * n8 >> 8;
            this.m_pixels[n7] = 0xFF000000 | n9 & 0xFF0000 | n10 & 0xFF00 | n11 & 0xFF;
        }
    }

    private final void drawLine_plain(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        if (bl) {
            n4 += n2;
            int n6 = 32768 + (n << 16);
            while (n2 <= n4) {
                n5 = n2 * this.SCREEN_WIDTH + (n6 >> 16);
                this.m_pixels[n5] = this.m_stroke;
                this.m_zbuffer[n5] = this.m_z0;
                n6 += n3;
                ++n2;
            }
        } else {
            n4 += n;
            int n7 = 32768 + (n2 << 16);
            while (n <= n4) {
                n5 = (n7 >> 16) * this.SCREEN_WIDTH + n;
                this.m_pixels[n5] = this.m_stroke;
                n7 += n3;
                ++n;
            }
        }
    }

    private final void drawLine_plain_alpha(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        int n6 = this.m_stroke & 0xFF0000;
        int n7 = this.m_stroke & 0xFF00;
        int n8 = this.m_stroke & 0xFF;
        int n9 = (int)this.m_a0;
        if (bl) {
            n4 += n2;
            int n10 = 32768 + (n << 16);
            while (n2 <= n4) {
                n5 = n2 * this.SCREEN_WIDTH + (n10 >> 16);
                int n11 = n9 >> 16;
                int n12 = this.m_pixels[n5];
                int n13 = n12 & 0xFF00;
                int n14 = n12 & 0xFF;
                n12 &= 0xFF0000;
                n12 += (n6 - n12) * n11 >> 8;
                n13 += (n7 - n13) * n11 >> 8;
                n14 += (n8 - n14) * n11 >> 8;
                this.m_pixels[n5] = 0xFF000000 | n12 & 0xFF0000 | n13 & 0xFF00 | n14 & 0xFF;
                this.m_zbuffer[n5] = this.m_z0;
                n9 = (int)((float)n9 + this.da);
                n10 += n3;
                ++n2;
            }
        } else {
            n4 += n;
            int n15 = 32768 + (n2 << 16);
            while (n <= n4) {
                n5 = (n15 >> 16) * this.SCREEN_WIDTH + n;
                int n16 = n9 >> 16;
                int n17 = this.m_pixels[n5];
                int n18 = n17 & 0xFF00;
                int n19 = n17 & 0xFF;
                n17 &= 0xFF0000;
                n17 += (n6 - n17) * n16 >> 8;
                n18 += (n7 - n18) * n16 >> 8;
                n19 += (n8 - n19) * n16 >> 8;
                this.m_pixels[n5] = 0xFF000000 | n17 & 0xFF0000 | n18 & 0xFF00 | n19 & 0xFF;
                this.m_zbuffer[n5] = this.m_z0;
                n9 = (int)((float)n9 + this.da);
                n15 += n3;
                ++n;
            }
        }
    }

    private final void drawLine_color(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        int n6 = (int)this.m_r0;
        int n7 = (int)this.m_g0;
        int n8 = (int)this.m_b0;
        if (bl) {
            n4 += n2;
            int n9 = 32768 + (n << 16);
            while (n2 <= n4) {
                n5 = n2 * this.SCREEN_WIDTH + (n9 >> 16);
                this.m_pixels[n5] = 0xFF000000 | (n6 & 0xFF0000 | n7 >> 8 & 0xFF00 | n8 >> 16);
                this.m_zbuffer[n5] = this.m_z0;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n9 += n3;
                ++n2;
            }
        } else {
            n4 += n;
            int n10 = 32768 + (n2 << 16);
            while (n <= n4) {
                n5 = (n10 >> 16) * this.SCREEN_WIDTH + n;
                this.m_pixels[n5] = 0xFF000000 | (n6 & 0xFF0000 | n7 >> 8 & 0xFF00 | n8 >> 16);
                this.m_zbuffer[n5] = this.m_z0;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n10 += n3;
                ++n;
            }
        }
    }

    private final void drawLine_color_alpha(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        int n6 = (int)this.m_r0;
        int n7 = (int)this.m_g0;
        int n8 = (int)this.m_b0;
        int n9 = (int)this.m_a0;
        if (bl) {
            n4 += n2;
            int n10 = 32768 + (n << 16);
            while (n2 <= n4) {
                n5 = n2 * this.SCREEN_WIDTH + (n10 >> 16);
                int n11 = n6 & 0xFF0000;
                int n12 = n7 >> 8 & 0xFF00;
                int n13 = n8 >> 16;
                int n14 = this.m_pixels[n5];
                int n15 = n14 & 0xFF00;
                int n16 = n14 & 0xFF;
                n14 &= 0xFF0000;
                int n17 = n9 >> 16;
                n14 += (n11 - n14) * n17 >> 8;
                n15 += (n12 - n15) * n17 >> 8;
                n16 += (n13 - n16) * n17 >> 8;
                this.m_pixels[n5] = 0xFF000000 | n14 & 0xFF0000 | n15 & 0xFF00 | n16 & 0xFF;
                this.m_zbuffer[n5] = this.m_z0;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n9 = (int)((float)n9 + this.da);
                n10 += n3;
                ++n2;
            }
        } else {
            n4 += n;
            int n18 = 32768 + (n2 << 16);
            while (n <= n4) {
                n5 = (n18 >> 16) * this.SCREEN_WIDTH + n;
                int n19 = n6 & 0xFF0000;
                int n20 = n7 >> 8 & 0xFF00;
                int n21 = n8 >> 16;
                int n22 = this.m_pixels[n5];
                int n23 = n22 & 0xFF00;
                int n24 = n22 & 0xFF;
                n22 &= 0xFF0000;
                int n25 = n9 >> 16;
                n22 += (n19 - n22) * n25 >> 8;
                n23 += (n20 - n23) * n25 >> 8;
                n24 += (n21 - n24) * n25 >> 8;
                this.m_pixels[n5] = 0xFF000000 | n22 & 0xFF0000 | n23 & 0xFF00 | n24 & 0xFF;
                this.m_zbuffer[n5] = this.m_z0;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n9 = (int)((float)n9 + this.da);
                n18 += n3;
                ++n;
            }
        }
    }

    private final void drawLine_plain_spatial(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        float f = this.m_z0;
        if (bl) {
            n4 += n2;
            int n6 = 32768 + (n << 16);
            while (n2 <= n4) {
                n5 = n2 * this.SCREEN_WIDTH + (n6 >> 16);
                if (f <= this.m_zbuffer[n5]) {
                    this.m_pixels[n5] = this.m_stroke;
                    this.m_zbuffer[n5] = f;
                }
                f += this.dz;
                n6 += n3;
                ++n2;
            }
        } else {
            n4 += n;
            int n7 = 32768 + (n2 << 16);
            while (n <= n4) {
                n5 = (n7 >> 16) * this.SCREEN_WIDTH + n;
                if (f <= this.m_zbuffer[n5]) {
                    this.m_pixels[n5] = this.m_stroke;
                    this.m_zbuffer[n5] = f;
                }
                f += this.dz;
                n7 += n3;
                ++n;
            }
        }
    }

    private final void drawLine_plain_alpha_spatial(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        float f = this.m_z0;
        int n6 = this.m_stroke & 0xFF0000;
        int n7 = this.m_stroke & 0xFF00;
        int n8 = this.m_stroke & 0xFF;
        int n9 = (int)this.m_a0;
        if (bl) {
            n4 += n2;
            int n10 = 32768 + (n << 16);
            while (n2 <= n4) {
                n5 = n2 * this.SCREEN_WIDTH + (n10 >> 16);
                if (f <= this.m_zbuffer[n5]) {
                    int n11 = n9 >> 16;
                    int n12 = this.m_pixels[n5];
                    int n13 = n12 & 0xFF00;
                    int n14 = n12 & 0xFF;
                    n12 &= 0xFF0000;
                    n12 += (n6 - n12) * n11 >> 8;
                    n13 += (n7 - n13) * n11 >> 8;
                    n14 += (n8 - n14) * n11 >> 8;
                    this.m_pixels[n5] = 0xFF000000 | n12 & 0xFF0000 | n13 & 0xFF00 | n14 & 0xFF;
                }
                f += this.dz;
                n9 = (int)((float)n9 + this.da);
                n10 += n3;
                ++n2;
            }
        } else {
            n4 += n;
            int n15 = 32768 + (n2 << 16);
            while (n <= n4) {
                n5 = (n15 >> 16) * this.SCREEN_WIDTH + n;
                if (f <= this.m_zbuffer[n5]) {
                    int n16 = n9 >> 16;
                    int n17 = this.m_pixels[n5];
                    int n18 = n17 & 0xFF00;
                    int n19 = n17 & 0xFF;
                    n17 &= 0xFF0000;
                    n17 += (n6 - n17) * n16 >> 8;
                    n18 += (n7 - n18) * n16 >> 8;
                    n19 += (n8 - n19) * n16 >> 8;
                    this.m_pixels[n5] = 0xFF000000 | n17 & 0xFF0000 | n18 & 0xFF00 | n19 & 0xFF;
                }
                f += this.dz;
                n9 = (int)((float)n9 + this.da);
                n15 += n3;
                ++n;
            }
        }
    }

    private final void drawLine_color_spatial(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        float f = this.m_z0;
        int n6 = (int)this.m_r0;
        int n7 = (int)this.m_g0;
        int n8 = (int)this.m_b0;
        if (bl) {
            n4 += n2;
            int n9 = 32768 + (n << 16);
            while (n2 <= n4) {
                n5 = n2 * this.SCREEN_WIDTH + (n9 >> 16);
                if (f <= this.m_zbuffer[n5]) {
                    this.m_pixels[n5] = 0xFF000000 | (n6 & 0xFF0000 | n7 >> 8 & 0xFF00 | n8 >> 16);
                    this.m_zbuffer[n5] = f;
                }
                f += this.dz;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n9 += n3;
                ++n2;
            }
        } else {
            n4 += n;
            int n10 = 32768 + (n2 << 16);
            while (n <= n4) {
                n5 = (n10 >> 16) * this.SCREEN_WIDTH + n;
                if (f <= this.m_zbuffer[n5]) {
                    this.m_pixels[n5] = 0xFF000000 | (n6 & 0xFF0000 | n7 >> 8 & 0xFF00 | n8 >> 16);
                    this.m_zbuffer[n5] = f;
                }
                f += this.dz;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n10 += n3;
                ++n;
            }
            return;
        }
    }

    private final void drawLine_color_alpha_spatial(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        float f = this.m_z0;
        int n6 = (int)this.m_r0;
        int n7 = (int)this.m_g0;
        int n8 = (int)this.m_b0;
        int n9 = (int)this.m_a0;
        if (bl) {
            n4 += n2;
            int n10 = 32768 + (n << 16);
            while (n2 <= n4) {
                n5 = n2 * this.SCREEN_WIDTH + (n10 >> 16);
                if (f <= this.m_zbuffer[n5]) {
                    int n11 = n6 & 0xFF0000;
                    int n12 = n7 >> 8 & 0xFF00;
                    int n13 = n8 >> 16;
                    int n14 = this.m_pixels[n5];
                    int n15 = n14 & 0xFF00;
                    int n16 = n14 & 0xFF;
                    n14 &= 0xFF0000;
                    int n17 = n9 >> 16;
                    n14 += (n11 - n14) * n17 >> 8;
                    n15 += (n12 - n15) * n17 >> 8;
                    n16 += (n13 - n16) * n17 >> 8;
                    this.m_pixels[n5] = 0xFF000000 | n14 & 0xFF0000 | n15 & 0xFF00 | n16 & 0xFF;
                    this.m_zbuffer[n5] = f;
                }
                f += this.dz;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n9 = (int)((float)n9 + this.da);
                n10 += n3;
                ++n2;
            }
        } else {
            n4 += n;
            int n18 = 32768 + (n2 << 16);
            while (n <= n4) {
                n5 = (n18 >> 16) * this.SCREEN_WIDTH + n;
                if (f <= this.m_zbuffer[n5]) {
                    int n19 = n6 & 0xFF0000;
                    int n20 = n7 >> 8 & 0xFF00;
                    int n21 = n8 >> 16;
                    int n22 = this.m_pixels[n5];
                    int n23 = n22 & 0xFF00;
                    int n24 = n22 & 0xFF;
                    n22 &= 0xFF0000;
                    int n25 = n9 >> 16;
                    n22 += (n19 - n22) * n25 >> 8;
                    n23 += (n20 - n23) * n25 >> 8;
                    n24 += (n21 - n24) * n25 >> 8;
                    this.m_pixels[n5] = 0xFF000000 | n22 & 0xFF0000 | n23 & 0xFF00 | n24 & 0xFF;
                    this.m_zbuffer[n5] = f;
                }
                f += this.dz;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n9 = (int)((float)n9 + this.da);
                n18 += n3;
                ++n;
            }
        }
    }

    void drawLine_smooth(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        float f = this.m_z0;
        int n6 = (int)this.m_r0;
        int n7 = (int)this.m_g0;
        int n8 = (int)this.m_b0;
        int n9 = (int)this.m_a0;
        if (bl) {
            int n10 = n << 16;
            int n11 = n2 << 16;
            int n12 = n4 + n2;
            while (n11 >> 16 < n12) {
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                n5 = (n11 >> 16) * this.SCREEN_WIDTH + (n10 >> 16);
                int n18 = n6 & 0xFF0000;
                int n19 = n7 >> 8 & 0xFF00;
                int n20 = n8 >> 16;
                if (f <= this.m_zbuffer[n5]) {
                    n17 = (~n10 >> 8 & 0xFF) * (n9 >> 16) >> 8;
                    n16 = this.m_pixels[n5];
                    n15 = n16 & 0xFF00;
                    n14 = n16 & 0xFF;
                    n16 &= 0xFF0000;
                    n16 += (n18 - n16) * n17 >> 8;
                    n15 += (n19 - n15) * n17 >> 8;
                    n14 += (n20 - n14) * n17 >> 8;
                    this.m_pixels[n5] = 0xFF000000 | n16 & 0xFF0000 | n15 & 0xFF00 | n14 & 0xFF;
                    this.m_zbuffer[n5] = f;
                }
                if ((n13 = (n10 >> 16) + 1) >= this.SCREEN_WIDTH) {
                    n10 += n3;
                    n11 += 65536;
                    continue;
                }
                n5 = (n11 >> 16) * this.SCREEN_WIDTH + n13;
                if (f <= this.m_zbuffer[n5]) {
                    n17 = (n10 >> 8 & 0xFF) * (n9 >> 16) >> 8;
                    n16 = this.m_pixels[n5];
                    n15 = n16 & 0xFF00;
                    n14 = n16 & 0xFF;
                    n16 &= 0xFF0000;
                    n16 += (n18 - n16) * n17 >> 8;
                    n15 += (n19 - n15) * n17 >> 8;
                    n14 += (n20 - n14) * n17 >> 8;
                    this.m_pixels[n5] = 0xFF000000 | n16 & 0xFF0000 | n15 & 0xFF00 | n14 & 0xFF;
                    this.m_zbuffer[n5] = f;
                }
                n10 += n3;
                n11 += 65536;
                f += this.dz;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n9 = (int)((float)n9 + this.da);
            }
        } else {
            int n21 = n << 16;
            int n22 = n2 << 16;
            int n23 = n4 + n;
            while (n21 >> 16 < n23) {
                int n24;
                int n25;
                int n26;
                int n27;
                int n28;
                n5 = (n22 >> 16) * this.SCREEN_WIDTH + (n21 >> 16);
                int n29 = n6 & 0xFF0000;
                int n30 = n7 >> 8 & 0xFF00;
                int n31 = n8 >> 16;
                if (f <= this.m_zbuffer[n5]) {
                    n28 = (~n22 >> 8 & 0xFF) * (n9 >> 16) >> 8;
                    n27 = this.m_pixels[n5];
                    n26 = n27 & 0xFF00;
                    n25 = n27 & 0xFF;
                    n27 &= 0xFF0000;
                    n27 += (n29 - n27) * n28 >> 8;
                    n26 += (n30 - n26) * n28 >> 8;
                    n25 += (n31 - n25) * n28 >> 8;
                    this.m_pixels[n5] = 0xFF000000 | n27 & 0xFF0000 | n26 & 0xFF00 | n25 & 0xFF;
                    this.m_zbuffer[n5] = f;
                }
                if ((n24 = (n22 >> 16) + 1) >= this.SCREEN_HEIGHT) {
                    n21 += 65536;
                    n22 += n3;
                    continue;
                }
                n5 = n24 * this.SCREEN_WIDTH + (n21 >> 16);
                if (f <= this.m_zbuffer[n5]) {
                    n28 = (n22 >> 8 & 0xFF) * (n9 >> 16) >> 8;
                    n27 = this.m_pixels[n5];
                    n26 = n27 & 0xFF00;
                    n25 = n27 & 0xFF;
                    n27 &= 0xFF0000;
                    n27 += (n29 - n27) * n28 >> 8;
                    n26 += (n30 - n26) * n28 >> 8;
                    n25 += (n31 - n25) * n28 >> 8;
                    this.m_pixels[n5] = 0xFF000000 | n27 & 0xFF0000 | n26 & 0xFF00 | n25 & 0xFF;
                    this.m_zbuffer[n5] = f;
                }
                n21 += 65536;
                n22 += n3;
                f += this.dz;
                n6 = (int)((float)n6 + this.dr);
                n7 = (int)((float)n7 + this.dg);
                n8 = (int)((float)n8 + this.db);
                n9 = (int)((float)n9 + this.da);
            }
        }
    }

    public PLine(PGraphics pGraphics) {
        this.parent = pGraphics;
    }
}

