/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics3D;
import processing.core.PImage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ephemeris
extends PApplet {
    static final double DE2RA = 0.01745329238474369;
    static final double PI = 3.1415927410125732;
    static final double PIO2 = 1.5707963705062866;
    static final double TWOPI = 6.2831854820251465;
    static final double X3PIO2 = 4.71238899230957;
    Camera cam;
    PFont font;
    int numStars;
    Tuple[] stars;
    String[] lines;
    ElementSet es;
    SGP4 propagator;
    Vector history;
    double lstStep;
    int showEquator;
    int Y;
    int M;
    int D;
    float mod;
    Vector sats;
    Earth earth;
    int displayHelp;
    double trailLength;
    float controlBlur;
    float dControlBlur;
    String[] months;
    int pickMode;
    int camMode;
    PImage img;
    PImage nimg;
    double timeSpan;
    double timeStep;
    Propagator current;
    int showLabels;
    int geoTrack;
    int realTime;
    int showInfo;
    int running;
    float ts;
    double lst;
    double JD;
    int year;
    double day;
    int hour;
    int minute;
    int second;
    float longitude;
    float time_zone;
    double runStep;
    double startDate;
    Calendar calendar;
    String onLoad;
    final double E6A = 1.0E-6f;
    final double TOTHRD = 0.6666666865348816;
    final double XJ2 = 0.001082616f;
    final double XJ4 = -1.65597E-6f;
    final double XJ3 = -2.53881E-6f;
    final double XKE = 0.07436691969633102;
    final double XKMPER = 6378.134765625;
    final float erad = 6378.135f;
    final double XMNPDA = 1440.0;
    final double AE = 1.0;
    final double QO = 120.0;
    final double SO = 78.0;
    final double CK2;
    final double CK4;
    final double QOMS2T;
    final double S = 1.0122292806386566;

    public void setup() {
        Object object;
        int n;
        int n2;
        String string = "0";
        if (this.online) {
            n2 = PApplet.parseInt(this.param("width"));
            if (n2 <= 0) {
                n2 = 550;
            }
            if ((n = PApplet.parseInt(this.param("height"))) <= 0) {
                n = 550;
            }
            try {
                object = this.getDocumentBase();
                StringTokenizer stringTokenizer = new StringTokenizer(((URL)object).toString(), "?=");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.onLoad = stringTokenizer.nextToken();
                if (string3.equals("TITLE")) {
                    this.onLoad = stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                ephemeris.println("No Input values");
            }
        } else {
            object = this.loadStrings("config.txt");
            if (object != null) {
                n2 = new Integer(object[0]);
                n = new Integer(object[1]);
            } else {
                n2 = 600;
                n = 600;
            }
        }
        this.size(n2, n, "processing.core.PGraphics3D");
        this.startDate = this.JD = this.getCurrentJulianDate();
        this.img = this.loadImage("earth.jpg");
        this.cam = new Camera(0.0f, 20000.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.font = this.loadFont("writing.vlw");
        this.textFont(this.font);
        this.textMode(128);
        int n3 = 0;
        while (n3 < this.numStars) {
            this.stars[n3] = new Tuple(this.random(-5000000.0f, 5000000.0f), this.random(-5000000.0f, 5000000.0f), this.random(-5000000.0f, 5000000.0f));
            ++n3;
        }
        if (this.onLoad != null) {
            if (this.onLoad.equals("Iridium")) {
                this.loadFile("iridium.txt");
                this.showLabels = 0;
                this.trailLength = 0.0075f;
            } else if (this.onLoad.equals("GPS")) {
                this.loadFile("gps.txt");
                this.cam.cy = 60000.0f;
                this.cam.calcShotLength();
            } else if (this.onLoad.equals("Molniya")) {
                this.loadFile("molniya.txt");
                this.cam.cy = 80000.0f;
                this.cam.calcShotLength();
                this.runStep = 2.0E-4f;
            } else if (this.onLoad.equals("TDRS")) {
                this.loadFile("tdrss.txt");
                this.cam.cy = 90000.0f;
                this.cam.calcShotLength();
            }
        } else {
            this.loadFile("recent.txt");
        }
        this.lstStep = 6.2831854820251465 * (this.timeStep / 1436.0682373046875);
    }

    public void draw() {
        this.background(0);
        if (this.camMode == 1) {
            if (this.current != null) {
                this.cam.tx = -this.current.currX;
                this.cam.ty = -this.current.currY;
                this.cam.tz = -this.current.currZ;
                this.cam.calcShotLength();
            } else {
                this.camMode = 0;
            }
        }
        this.cam.feed();
        if (this.running == 1) {
            this.JD += this.runStep;
        }
        if (this.geoTrack == 1 && this.running == 1 && this.realTime == 0) {
            this.cam.rotZ(-((float)(6.2831854820251465 * this.runStep)));
        }
        if (this.realTime == 1) {
            this.JD = this.getCurrentJulianDate();
        }
        this.lst = this.getSiderealTime(this.JD);
        this.stroke(150);
        this.beginShape(16);
        int n = 0;
        while (n < this.numStars) {
            this.vertex(this.stars[n].x, this.stars[n].y, this.stars[n].z);
            ++n;
        }
        this.endShape();
        this.noStroke();
        this.fill(100.0f, 100.0f, 200.0f);
        this.earth.draw();
        this.stroke(255);
        this.noFill();
        this.pushMatrix();
        int n2 = 0;
        while (n2 < this.sats.size()) {
            Propagator propagator = (Propagator)this.sats.elementAt(n2);
            propagator.render();
            ++n2;
        }
        this.popMatrix();
        this.camera();
        this.stroke(128);
        this.fill(200.0f, 200.0f, 255.0f, 50.0f);
        if (this.current != null) {
            this.stroke(255.0f, 255.0f, 0.0f);
            this.noFill();
            this.ellipse((int)this.current.msx, (int)this.current.msy, 30.0f, 30.0f);
        }
        this.dControlBlur = this.mouseY > this.height - 50 ? 150.0f : 50.0f;
        this.controlBlur += (this.dControlBlur - this.controlBlur) / 10.0f;
        double d = this.timeSpan / 24.0;
        int n3 = this.width - 100;
        double d2 = this.JD - this.startDate;
        double d3 = d2 / d;
        this.stroke(100);
        if (d3 > 1.0) {
            d3 = 1.0;
            this.running = 0;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
            this.running = 0;
        }
        this.fill(100.0f, 100.0f, 120.0f, this.controlBlur);
        this.rect(50.0f, this.height - 30, n3, 20.0f);
        this.fill(200.0f, 200.0f, 200.0f, this.controlBlur);
        int n4 = (int)(d3 * (double)(n3 - 20));
        this.rect(50 + n4, this.height - 30, 20.0f, 20.0f);
        if (this.showInfo == 1) {
            this.fill(0.0f, 0.0f, 200.0f, 50.0f);
            this.rect(5, 5, 230.0f, 55.0f);
            this.fill(255);
            if (this.realTime == 1) {
                this.text("Realtime Julian Date: " + this.JD, 10.0f, 15.0f);
            } else {
                this.text("Displayed Julian Date: " + this.JD, 10.0f, 15.0f);
            }
            this.text("" + this.D + ' ' + this.months[this.M - 1] + ' ' + this.Y + " GMT " + this.hour + ':' + this.minute + ':' + this.second, 10.0f, 25.0f);
            this.text(this.timeSpan + " hours of ephemeris", 10.0f, 35.0f);
            if (this.geoTrack == 1) {
                this.text("Camera rotates with Earth", 10.0f, 45.0f);
            } else {
                this.text("Camera is inertial", 10.0f, 45.0f);
            }
            this.text("Time Step: " + (float)(this.runStep * 86400.0) + " seconds per tick", 10.0f, 55.0f);
        }
        if (this.pickMode == 1) {
            this.pickMode = 2;
        }
        if (this.displayHelp == 1) {
            this.fill(0.0f, 0.0f, 0.0f, 200.0f);
            this.noStroke();
            this.rect(0.0f, 0.0f, this.width, this.height);
            this.fill(255.0f, 255.0f, 255.0f);
            int n5 = 50;
            int n6 = this.width / 2 - 100;
            int n7 = 15;
            this.text("1 - Load ASAT debris", (float)n6, (float)n5);
            this.text("2 - Load ISS", (float)n6, (float)(n5 += n7));
            this.text("3 - Load Satellite Radio", (float)n6, (float)(n5 += n7));
            this.text("4 - Load GPS", (float)n6, (float)(n5 += n7));
            this.text("5 - Load Recent launches", (float)n6, (float)(n5 += n7));
            this.text("6 - Load Molniya orbits", (float)n6, (float)(n5 += n7));
            this.text("7 - Load Iridium", (float)n6, (float)(n5 += n7));
            this.text("8 - Load TDRS", (float)n6, (float)(n5 += n7));
            this.text("9 - Load Cubesats", (float)n6, (float)(n5 += n7));
            this.text("a - Load TLE from disk (Standalone version only)", (float)n6, (float)(n5 += n7));
            n5 += n7;
            this.text("left mouse drag - Orbit", (float)n6, (float)(n5 += n7));
            this.text("right mouse drag - Zoom", (float)n6, (float)(n5 += n7));
            this.text("z + mouse drag - Zoom", (float)n6, (float)(n5 += n7));
            this.text("c - Center camera on Earth", (float)n6, (float)(n5 += n7));
            this.text("q - Remove all satellites", (float)n6, (float)(n5 += n7));
            this.text("p - Enter pick mode (click to select)", (float)n6, (float)(n5 += n7));
            this.text("u - Deselect all", (float)n6, (float)(n5 += n7));
            n5 += n7;
            this.text("g - Toggle inertial/rotate with earth", (float)n6, (float)(n5 += n7));
            this.text("up/down - Increase/decrease timestep", (float)n6, (float)(n5 += n7));
            this.text("left/right - move forward/backward in time", (float)n6, (float)(n5 += n7));
            this.text("r - Lock sim time to actual time", (float)n6, (float)(n5 += n7));
            this.text("space - Toggle running", (float)n6, (float)(n5 += n7));
            this.text("n - Set clock to current time", (float)n6, (float)(n5 += n7));
            n5 += n7;
            this.text("l - Toggle labels", (float)n6, (float)(n5 += n7));
            this.text("d - Toggle infobox", (float)n6, (float)(n5 += n7));
            this.text("e - Toggle equator", (float)n6, (float)(n5 += n7));
            this.text("w/s - Increment/decrement trail length", (float)n6, (float)(n5 += n7));
            n5 += n7;
        }
    }

    public void mousePressed() {
        if (this.pickMode == 2) {
            this.pick();
            this.pickMode = 0;
        }
    }

    public void mouseDragged() {
        if (this.mouseButton == 37 && this.key != 'z') {
            if (this.mouseY < this.height - 30) {
                this.cam.upZ(-ephemeris.radians(this.mouseY - this.pmouseY) / 2.0f);
                this.cam.rotZ(ephemeris.radians(this.mouseX - this.pmouseX) / 2.0f);
            } else {
                this.realTime = 0;
                double d = this.timeSpan / 24.0;
                int n = this.width - 100;
                double d2 = d / (double)n;
                this.JD += d2 * (double)(this.mouseX - this.pmouseX);
            }
        } else if (this.mouseButton == 39 || this.key == 'z') {
            this.cam.modShot(1.0f + (float)(this.mouseY - this.pmouseY) / 50.0f);
        }
    }

    public void keyReleased() {
        this.key = (char)32;
    }

    public void keyPressed() {
        if (this.key != 'h') {
            this.displayHelp = 0;
        }
        if (this.key == ' ') {
            this.realTime = 0;
            this.running = 1 - this.running;
            ephemeris.println(this.running);
        } else if (this.key == 'n') {
            this.JD = this.getCurrentJulianDate();
        } else if (this.key == '1') {
            this.loadFile("ASAT.txt");
            this.showLabels = 0;
        } else if (this.key == '2') {
            this.loadFile("ISS.txt");
        } else if (this.key == '3') {
            this.loadFile("radio.txt");
        } else if (this.key == '4') {
            this.loadFile("gps.txt");
        } else if (this.key == '5') {
            this.loadFile("recent.txt");
        } else if (this.key == '6') {
            this.loadFile("molniya.txt");
        } else if (this.key == '7') {
            this.loadFile("iridium.txt");
        } else if (this.key == '8') {
            this.loadFile("tdrss.txt");
        } else if (this.key == '9') {
            this.loadFile("cubesat.txt");
        } else if (this.key == '0') {
            this.loadFile("glonass.txt");
        } else if (this.key == 'd') {
            this.showInfo = 1 - this.showInfo;
        } else if (this.key == 'l') {
            this.showLabels = 1 - this.showLabels;
        } else if (this.key == 'r') {
            this.realTime = 1 - this.realTime;
            this.running = 0;
        } else if (this.key == 'p') {
            this.pickMode = 1;
        } else if (this.key == 'g') {
            this.geoTrack = 1 - this.geoTrack;
        } else if (this.key == 'h') {
            this.displayHelp = 1 - this.displayHelp;
        } else if (this.key == 'u') {
            if (this.current != null) {
                this.current.selected = 0;
            }
            this.current = null;
            this.camMode = 0;
            this.cam.tx = 0.0f;
            this.cam.ty = 0.0f;
            this.cam.tz = 0.0f;
            this.cam.calcShotLength();
        } else if (this.keyCode == 39) {
            this.JD += this.runStep;
        } else if (this.keyCode == 37) {
            this.JD -= this.runStep;
        } else if (this.keyCode == 38) {
            this.runStep *= (double)1.1f;
        } else if (this.keyCode == 40) {
            this.runStep /= (double)1.1f;
        } else if (this.key == 'c') {
            if (this.camMode == 1) {
                this.camMode = 0;
                this.cam.tx = 0.0f;
                this.cam.ty = 0.0f;
                this.cam.tz = 0.0f;
                this.cam.calcShotLength();
            } else if (this.current != null) {
                this.camMode = 1;
            }
        } else if (this.key == 'a') {
            this.appendFile();
        } else if (this.key == 'q') {
            this.sats = new Vector();
            this.current = null;
        } else if (this.key == 'w') {
            this.trailLength *= (double)1.1f;
        } else if (this.key == 's') {
            this.trailLength /= (double)1.1f;
        } else if (this.key == 'e') {
            this.showEquator = 1 - this.showEquator;
        }
        try {
            if (this.key == 'S') {
                this.img = this.loadImage("earth_summer.jpg");
            } else if (this.key == 'W') {
                this.img = this.loadImage("earth_winter.jpg");
            } else if (this.key == 'U') {
                this.img = this.loadImage("earth_ultra.jpg");
            }
        }
        catch (Exception exception) {
            ephemeris.println("Could not load image");
        }
    }

    public void pick() {
        float f = 200000.0f;
        int n = 0;
        while (n < this.sats.size()) {
            Propagator propagator = (Propagator)this.sats.elementAt(n);
            float f2 = propagator.pick(this.mouseX, this.mouseY);
            if (f2 < f) {
                f = f2;
                if (this.current != null) {
                    this.current.selected = 0;
                }
                propagator.selected = 1;
                this.current = propagator;
            }
            ++n;
        }
    }

    public void appendFile() {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                try {
                    File file;
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(null);
                    if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        String string = file.getAbsolutePath();
                        ephemeris.this.loadFile(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void loadFile(String string) {
        this.lines = this.loadStrings(string);
        this.parseStrings();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseStrings() {
        try {
            int n = 0;
            while (true) {
                Propagator propagator;
                if (n >= this.lines.length) {
                    return;
                }
                while (true) {
                    if (this.lines[n] != "") {
                        ephemeris.println("Generating:" + this.lines[n]);
                        ElementSet elementSet = new ElementSet(this.lines[n + 1], this.lines[n + 2]);
                        propagator = elementSet.isDeep() ? new SDP4(this.lines[n], new ElementSet(this.lines[n + 1], this.lines[n + 2])) : new SGP4(this.lines[n], new ElementSet(this.lines[n + 1], this.lines[n + 2]));
                    }
                    ++n;
                }
                propagator.generate(this.startDate, this.timeSpan, this.timeStep);
                OrbitalState orbitalState = (OrbitalState)propagator.history.elementAt(10);
                OrbitalState orbitalState2 = (OrbitalState)propagator.history.elementAt(11);
                double d = orbitalState.X - orbitalState2.X;
                double d2 = orbitalState.Y - orbitalState2.Y;
                double d3 = orbitalState.Z - orbitalState2.Z;
                if (Math.sqrt(d * d + d2 * d2 + d3 * d3) > 10000.0) {
                    ephemeris.println("Excluding " + this.lines[n] + ": orbital motion incorrect.");
                } else {
                    this.sats.add(propagator);
                }
                n += 3;
            }
        }
        catch (Exception exception) {
            ephemeris.println(exception);
        }
    }

    public static double ACTAN(double d, double d2) {
        double d3 = 0.0;
        if (d2 != 0.0) {
            if (d2 <= 0.0) {
                d3 = 3.1415927410125732;
            } else {
                if (d == 0.0) {
                    return d3;
                }
                if (d <= 0.0) {
                    d3 = 6.2831854820251465;
                }
            }
        } else {
            if (d == 0.0) {
                return d3;
            }
            if (d <= 0.0) {
                d3 = 4.71238899230957;
                return d3;
            }
            d3 = 1.5707963705062866;
            return d3;
        }
        double d4 = d / d2;
        return d3 += Math.atan(d4);
    }

    public static double FMOD2P(double d) {
        int n;
        double d2 = 0.0;
        d2 = d;
        if ((d2 -= (double)(n = (int)(d2 / 6.2831854820251465)) * 6.2831854820251465) < 0.0) {
            d2 += 6.2831854820251465;
        }
        return d2;
    }

    public static double computeDS50(double d) {
        double d2 = (d + (double)2.0E-7f) * (double)0.001f;
        int n = (int)d2;
        d2 = n;
        double d3 = d - d2 * 1000.0;
        if (n < 10) {
            n += 80;
        }
        int n2 = (n - 69) / 4;
        if (n < 70) {
            n2 = (n - 72) / 4;
        }
        return (double)(7305.0f + 365.0f * (float)(n - 70) + (float)n2) + d3;
    }

    public static double THETAG(double d) {
        double d2 = 1.729444980621338 + 6.300388336181641 * d;
        double d3 = d2 - (double)((int)(d2 / 6.2831854820251465)) * 6.2831854820251465;
        if (d3 < 0.0) {
            d3 += 6.2831854820251465;
        }
        return d3;
    }

    public double toJulian(int n, double d) {
        double d2 = (double)(2451545.0f + (float)n * 365.25f) + d;
        return d2;
    }

    public double getSiderealTime(double d) {
        double d2 = d - 2451545.0;
        this.year = (int)(d2 / 365.25);
        double d3 = d2 - (double)(365.25f * (float)this.year);
        this.year += 2000;
        int n = (int)(d - 0.5);
        n = (int)((float)n - 0.25f);
        int n2 = (n += 2) + 32044;
        int n3 = n2 / 146097;
        int n4 = n2 % 146097;
        int n5 = (n4 / 36524 + 1) * 3 / 4;
        int n6 = n4 - n5 * 36524;
        int n7 = n6 / 1461;
        int n8 = n6 % 1461;
        int n9 = (n8 / 365 + 1) * 3 / 4;
        int n10 = n8 - n9 * 365;
        int n11 = n3 * 400 + n5 * 100 + n7 * 4 + n9;
        int n12 = (n10 * 5 + 308) / 153 - 2;
        int n13 = n10 - (n12 + 4) * 153 / 5 + 122;
        this.Y = n11 - 4800 + (n12 + 2) / 12;
        this.M = (n12 + 2) % 12 + 1;
        this.D = n13 + 1;
        double d4 = d3 - (double)((int)d3);
        if (d4 < 0.5) {
            d4 += 0.5;
            d3 -= 1.0;
        } else {
            d4 -= 0.5;
        }
        if (d4 < 0.25) {
            d4 += 1.0;
            d3 -= 1.0;
        }
        int n14 = (int)((d4 -= 0.25) * 86400.0);
        this.hour = n14 / 3600;
        this.minute = (n14 -= this.hour * 3600) / 60;
        this.second = n14 -= this.minute * 60;
        double d5 = d2 / 36525.0;
        double d6 = 280.46063232421875 + 360.98565673828125 * (d - 2451545.0) + (double)3.87933E-4f * d5 * d5 - d5 * d5 * d5 / 3.871E7;
        d6 = this.range_degrees(d6);
        return 3.1415927410125732 * d6 / 180.0;
    }

    public double range_degrees(double d) {
        if (d >= 0.0 && d < 360.0) {
            return d;
        }
        double d2 = (int)(d / 360.0);
        if (d < 0.0) {
            d2 -= 1.0;
        }
        double d3 = d - (d2 *= 360.0);
        return d3;
    }

    public double getCurrentJulianDate() {
        int n = 588829;
        Date date = new Date();
        this.calendar.setTime(date);
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        int n2 = this.calendar.get(1);
        int n3 = this.calendar.get(2) + 1;
        int n4 = this.calendar.get(5);
        this.hour = this.calendar.get(11);
        if (this.hour < 12) {
            this.hour += 12;
            --n4;
        } else {
            this.hour -= 12;
        }
        int n5 = n2;
        if (n2 < 0) {
            ++n5;
        }
        int n6 = n3;
        if (n3 > 2) {
            ++n6;
        } else {
            --n5;
            n6 += 13;
        }
        double d = Math.floor(365.25f * (float)n5) + Math.floor(30.6001f * (float)n6) + (double)n4 + 1720995.0;
        if (n4 + 31 * (n3 + 12 * n2) >= n) {
            int n7 = (int)(0.01f * (float)n5);
            d += (double)((float)(2 - n7) + 0.25f * (float)n7);
        }
        return d += (double)((float)(this.hour * 3600 + this.calendar.get(12) * 60 + this.calendar.get(13)) / 86400.0f);
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"ephemeris"});
    }

    private final /* synthetic */ void this() {
        this.numStars = 1500;
        this.stars = new Tuple[this.numStars];
        this.history = new Vector();
        this.lstStep = 0.0;
        this.showEquator = 0;
        this.mod = 1.25f;
        this.sats = new Vector();
        this.earth = new Earth();
        this.displayHelp = 0;
        this.trailLength = 0.025f;
        this.controlBlur = 0.0f;
        this.dControlBlur = 0.0f;
        this.months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        this.pickMode = 0;
        this.camMode = 0;
        this.timeSpan = 24.0;
        this.timeStep = 3;
        this.current = null;
        this.showLabels = 1;
        this.geoTrack = 0;
        this.realTime = 0;
        this.showInfo = 1;
        this.running = 1;
        this.ts = 1.0f;
        this.lst = 0.0;
        this.JD = 0.0;
        this.year = 0;
        this.day = 0.0;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.longitude = 0.0f;
        this.time_zone = 0.0f;
        this.runStep = 5.0E-5f;
        this.startDate = 0.0;
        this.calendar = new GregorianCalendar();
        this.onLoad = null;
        this.CK2 = (double)5.41308E-4f * Math.pow(1.0, 2);
        this.CK4 = 6.209887430941308E-7 * Math.pow(1.0, 4);
        this.QOMS2T = Math.pow(0.0065849972669689075, 4);
    }

    public ephemeris() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Camera {
        float cx;
        float cy;
        float cz;
        float tx;
        float ty;
        float tz;
        float shotLength;

        public void calcShotLength() {
            this.shotLength = ephemeris.sqrt((this.cx - this.tx) * (this.cx - this.tx) + (this.cy - this.ty) * (this.cy - this.ty) + (this.cz - this.tz) * (this.cz - this.tz));
        }

        public void set(float f, float f2, float f3) {
            this.cx = f;
            this.cy = f2;
            this.cz = f3;
        }

        public void feed() {
            ephemeris.this.camera(this.cx, this.cy, this.cz, this.tx, this.ty, this.tz, 0.0f, 0.0f, 1.0f);
            ephemeris.this.scale(-1.0f, -1.0f, -1.0f);
        }

        public void rotZ(float f) {
            float f2 = this.cx;
            this.cx = this.cx * ephemeris.this.cos(f) + this.cy * ephemeris.this.sin(f);
            this.cy = -f2 * ephemeris.this.sin(f) + this.cy * ephemeris.this.cos(f);
            float f3 = ephemeris.sqrt((this.cx - this.tx) * (this.cx - this.tx) + (this.cy - this.ty) * (this.cy - this.ty) + (this.cz - this.tz) * (this.cz - this.tz));
            this.cx /= f3;
            this.cy /= f3;
            this.cz /= f3;
            this.cx *= this.shotLength;
            this.cy *= this.shotLength;
            this.cz *= this.shotLength;
        }

        public void upZ(float f) {
            this.cz += this.shotLength * f;
            if (this.cz > this.shotLength) {
                this.cz = this.shotLength;
            }
            if (this.cz < -this.shotLength) {
                this.cz = -this.shotLength;
            }
            float f2 = ephemeris.sqrt((this.cx - this.tx) * (this.cx - this.tx) + (this.cy - this.ty) * (this.cy - this.ty) + (this.cz - this.tz) * (this.cz - this.tz));
            this.cx /= f2;
            this.cy /= f2;
            this.cz /= f2;
            this.cx *= this.shotLength;
            this.cy *= this.shotLength;
            this.cz *= this.shotLength;
        }

        public void modShot(float f) {
            float f2 = this.getLength();
            this.shotLength *= f;
            if (ephemeris.this.camMode == 0) {
                if (this.shotLength < 6478.135f) {
                    this.shotLength = 6478.135f;
                }
            } else if (this.shotLength < 100.0f) {
                this.shotLength = 100.0f;
            }
            if (this.shotLength > 126378.13f) {
                this.shotLength = 126378.13f;
            }
            this.cx /= f2;
            this.cy /= f2;
            this.cz /= f2;
            this.cx *= this.shotLength;
            this.cy *= this.shotLength;
            this.cz *= this.shotLength;
        }

        public float getLength() {
            return ephemeris.sqrt((this.cx - this.tx) * (this.cx - this.tx) + (this.cy - this.ty) * (this.cy - this.ty) + (this.cz - this.tz) * (this.cz - this.tz));
        }

        public float getHeight() {
            return ephemeris.sqrt(this.cx * this.cx + this.cy * this.cy + this.cz * this.cz);
        }

        public Camera(float f, float f2, float f3, float f4, float f5, float f6) {
            this.cx = f;
            this.cy = f2;
            this.cz = f3;
            this.tx = f4;
            this.ty = f5;
            this.tz = f6;
            this.calcShotLength();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Tuple {
        float x;
        float y;
        float z;

        public float dot(Tuple tuple) {
            return this.x * tuple.x + this.y * tuple.y + this.z * tuple.z;
        }

        public void normalize() {
            float f = ephemeris.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            this.x /= f;
            this.y /= f;
            this.z /= f;
        }

        public Tuple(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    abstract class Propagator {
        String title;
        Vector history;
        double startTime;
        double stepSize;
        protected ElementSet es;
        float currX;
        float currY;
        float currZ;
        int selected;
        float msx;
        float msy;
        float temp;
        float az;
        float lastAz;

        public float pick(int n, int n2) {
            return ephemeris.sqrt((this.msx - (float)n) * (this.msx - (float)n) + (this.msy - (float)n2) * (this.msy - (float)n2));
        }

        public void render() {
            ephemeris.this.noFill();
            ephemeris.this.beginShape();
            ephemeris.this.stroke(255.0f, 255.0f, 255.0f, 100.0f);
            OrbitalState orbitalState = null;
            OrbitalState orbitalState2 = new OrbitalState();
            OrbitalState orbitalState3 = new OrbitalState();
            double d = 0.0;
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.history.size() - 1 && !bl) {
                orbitalState = (OrbitalState)this.history.elementAt(n2);
                double d2 = ephemeris.this.JD - orbitalState.julianTime;
                if (d2 > 0.0 && d2 < ephemeris.this.trailLength) {
                    ephemeris.this.stroke(255.0f, 255.0f, 255.0f, 150 - (int)(150.0 * d2 / ephemeris.this.trailLength));
                    ephemeris.this.vertex((float)orbitalState.X, (float)orbitalState.Y, (float)orbitalState.Z);
                }
                if (d2 > 0.0 && d2 < this.stepSize) {
                    orbitalState3 = orbitalState;
                    d = d2 / this.stepSize;
                    orbitalState2 = (OrbitalState)this.history.elementAt(n2 + 1);
                    this.currX = (float)(orbitalState3.X + d * (orbitalState2.X - orbitalState3.X));
                    this.currY = (float)(orbitalState3.Y + d * (orbitalState2.Y - orbitalState3.Y));
                    this.currZ = (float)(orbitalState3.Z + d * (orbitalState2.Z - orbitalState3.Z));
                    ephemeris.this.vertex(this.currX, this.currY, this.currZ);
                    bl = true;
                    n = n2;
                }
                ++n2;
            }
            ephemeris.this.endShape();
            if (this.selected == 1) {
                ephemeris.this.beginShape();
                ephemeris.this.stroke(255.0f, 255.0f, 0.0f);
                double d3 = ephemeris.sqrt(this.currX * this.currX + this.currY * this.currY + this.currZ * this.currZ);
                ephemeris.this.vertex(this.currX, this.currY, this.currZ);
                ephemeris.this.vertex((float)((double)(6378.135f * this.currX) / d3), (float)((double)(6378.135f * this.currY) / d3), (float)((double)(6378.135f * this.currZ) / d3));
                int n3 = n;
                while (n3 > 0) {
                    orbitalState = (OrbitalState)this.history.elementAt(n3);
                    double d4 = (double)(n - n3) + d;
                    d3 = Math.sqrt(orbitalState.X * orbitalState.X + orbitalState.Y * orbitalState.Y + orbitalState.Z * orbitalState.Z);
                    double d5 = orbitalState.X;
                    double d6 = orbitalState.Y;
                    double d7 = orbitalState.Z;
                    double d8 = d5 * Math.cos(d4 * ephemeris.this.lstStep) - d6 * Math.sin(d4 * ephemeris.this.lstStep);
                    d6 = d5 * Math.sin(d4 * ephemeris.this.lstStep) + d6 * Math.cos(d4 * ephemeris.this.lstStep);
                    d3 = Math.sqrt(d8 * d8 + d6 * d6 + d7 * d7);
                    d8 /= d3;
                    d6 /= d3;
                    d7 /= d3;
                    ephemeris.this.vertex((float)(d8 *= 6410.025390625), (float)(d6 *= 6410.025390625), (float)(d7 *= 6410.025390625));
                    --n3;
                }
                ephemeris.this.endShape();
            }
            if (this.currX != 0.0f) {
                ephemeris.this.pushMatrix();
                ephemeris.this.translate(this.currX, this.currY, this.currZ);
                ephemeris.this.fill(200.0f, 200.0f, 255.0f, 100.0f);
                ephemeris.this.stroke(200);
                ephemeris.this.box(200.0f);
                ephemeris.this.fill(255);
                if (this.selected == 1 || ephemeris.this.pickMode == 1) {
                    this.msx = ephemeris.this.screenX(0.0f, 0.0f, 0.0f);
                    this.msy = ephemeris.this.screenY(0.0f, 0.0f, 0.0f);
                    this.lastAz = this.az;
                    this.az = ephemeris.this.atan2(this.currX, this.currY);
                }
                if (ephemeris.this.showLabels == 1 || this.selected == 1) {
                    ephemeris.this.text(this.title, ephemeris.this.screenX(0.0f, 0.0f, 0.0f), ephemeris.this.screenY(0.0f, 0.0f, 0.0f));
                }
                ephemeris.this.popMatrix();
            }
        }

        public OrbitalState propagate(double d) {
            return new OrbitalState();
        }

        public void generate(double d, double d2, double d3) {
            double d4 = d - this.startTime + (double)ephemeris.this.mod;
            d4 *= 1440.0;
            d2 *= 60.0;
            this.stepSize = d3 / 1440.0;
            int n = 0;
            while ((double)n < d2 / d3) {
                this.history.add(this.propagate(d4 + (double)n * d3));
                ++n;
            }
        }

        private final /* synthetic */ void this() {
            this.history = new Vector();
            this.currX = 0.0f;
            this.currY = 0.0f;
            this.currZ = 0.0f;
            this.selected = 0;
            this.msx = 0.0f;
            this.msy = 0.0f;
            this.az = 0.0f;
            this.lastAz = 0.0f;
        }

        Propagator() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Earth {
        int latRes;
        int lonRes;
        float rad;
        Tuple3[][] pts;

        public void draw() {
            ephemeris.this.textureMode(1);
            ephemeris.this.pushMatrix();
            ephemeris.this.rotateZ((float)ephemeris.this.lst);
            ((PGraphics3D)ephemeris.this.g).triangle.setCulling(true);
            ephemeris.this.tint(255.0f, 255.0f, 255.0f);
            ephemeris.this.beginShape(65);
            ephemeris.this.texture(ephemeris.this.img);
            int n = 0;
            while (n < this.latRes) {
                Tuple3 tuple3;
                Tuple3 tuple32;
                int n2 = 0;
                while (n2 < this.lonRes) {
                    tuple32 = this.pts[n2][n + 1];
                    tuple3 = this.pts[n2][n];
                    ephemeris.this.vertex(tuple32.x, tuple32.y, tuple32.z, tuple32.uv, tuple32.uw);
                    ephemeris.this.vertex(tuple3.x, tuple3.y, tuple3.z, tuple3.uv, tuple3.uw);
                    ++n2;
                }
                tuple32 = this.pts[0][n];
                tuple3 = this.pts[0][n + 1];
                ephemeris.this.vertex(tuple3.x, tuple3.y, tuple3.z, 1.0f, tuple3.uw);
                ephemeris.this.vertex(tuple32.x, tuple32.y, tuple32.z, 1.0f, tuple32.uw);
                ++n;
            }
            ephemeris.this.endShape();
            ephemeris.this.popMatrix();
            ((PGraphics3D)ephemeris.this.g).triangle.setCulling(false);
            if (ephemeris.this.showEquator == 1) {
                ephemeris.this.fill(255.0f, 255.0f, 255.0f, 50.0f);
                ephemeris.this.pushMatrix();
                ephemeris.this.ellipse(0.0f, 0.0f, 84328.266f, 84328.266f);
                ephemeris.this.popMatrix();
            }
        }

        private final /* synthetic */ void this() {
            this.latRes = 20;
            this.lonRes = 20;
            this.rad = 6378.135f;
        }

        public Earth() {
            this.this();
            this.pts = new Tuple3[this.lonRes][this.latRes + 1];
            float f = 0.0f;
            float f2 = 0.0f;
            int n = 0;
            while (n < this.lonRes) {
                f2 = (float)Math.PI + (float)((double)(n * 2) * 3.1415927410125732) / (float)this.lonRes;
                int n2 = 0;
                while (n2 < this.latRes + 1) {
                    f = (float)((double)n2 * (3.1415927410125732 / (double)this.latRes));
                    this.pts[n][n2] = new Tuple3();
                    this.pts[n][n2].x = this.rad * ephemeris.this.cos(f2) * ephemeris.this.sin(f);
                    this.pts[n][n2].y = this.rad * ephemeris.this.sin(f2) * ephemeris.this.sin(f);
                    this.pts[n][n2].z = this.rad * ephemeris.this.cos(f);
                    this.pts[n][n2].uv = (float)n / (float)this.lonRes;
                    this.pts[n][n2].uw = (float)n2 / (float)this.latRes;
                    ++n2;
                }
                ++n;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ElementSet {
        double XMO;
        double XNODEO;
        double OMEGAO;
        double EO;
        double XINCL;
        double XNO;
        double XNDT2O;
        double XNDD6O;
        double BSTAR;
        double EPOCH;
        double DS50;
        double julian;
        int satNum;
        private final String line1;
        private final String line2;

        public String getLine1() {
            return this.line1;
        }

        public String getLine2() {
            return this.line2;
        }

        public boolean isDeep() {
            double d = Math.pow(0.07436691969633102 / this.XNO, 0.6666666865348816);
            double d2 = 1.5 * ephemeris.this.CK2 * ((double)3 * Math.pow(Math.cos(this.XINCL), 2) - 1.0) / Math.pow(1.0 - this.EO * this.EO, 1.5);
            double d3 = d2 / (d * d);
            double d4 = d * (1.0 - d3 * (0.3333333432674408 + d3 * (1.0 + (double)1.654321f * d3)));
            double d5 = d2 / (d4 * d4);
            double d6 = this.XNO / (1.0 + d5);
            boolean bl = false;
            if (6.2831854820251465 / d6 / 1440.0 >= 0.15625) {
                bl = true;
            }
            return bl;
        }

        private final /* synthetic */ void this() {
            this.XMO = 0.0;
            this.XNODEO = 0.0;
            this.OMEGAO = 0.0;
            this.EO = 0.0;
            this.XINCL = 0.0;
            this.XNO = 0.0;
            this.XNDT2O = 0.0;
            this.XNDD6O = 0.0;
            this.BSTAR = 0.0;
            this.EPOCH = 0.0;
            this.DS50 = 0.0;
            this.julian = 0.0;
        }

        public ElementSet(String[] stringArray) {
            this(stringArray[0], stringArray[1]);
        }

        public ElementSet(String string, String string2) {
            this.this();
            this.line1 = string;
            this.line2 = string2;
            int n = 0;
            int n2 = 0;
            this.satNum = Integer.parseInt(this.line1.substring(2, 7));
            this.EPOCH = Double.parseDouble(this.line1.substring(18, 32));
            int n3 = Integer.parseInt(this.line1.substring(18, 20));
            double d = Double.parseDouble(this.line1.substring(20, 32));
            this.julian = ephemeris.this.toJulian(n3, d);
            this.XNDT2O = Double.parseDouble(this.line1.substring(34, 43));
            this.XNDD6O = Double.parseDouble("." + this.line1.substring(45, 50));
            n = Integer.parseInt(this.line1.substring(50, 52));
            this.BSTAR = Double.parseDouble("." + this.line1.substring(54, 59));
            n2 = this.line1.substring(59, 60).equals("+") ? Integer.parseInt(this.line1.substring(60, 61)) : Integer.parseInt(this.line1.substring(59, 61));
            this.XINCL = Double.parseDouble(this.line2.substring(8, 16));
            this.XNODEO = Double.parseDouble(this.line2.substring(17, 25));
            this.EO = Double.parseDouble("." + this.line2.substring(26, 33));
            this.OMEGAO = Double.parseDouble(this.line2.substring(34, 42));
            this.XMO = Double.parseDouble(this.line2.substring(43, 51));
            this.XNO = Double.parseDouble(this.line2.substring(52, 63));
            this.XNDD6O *= Math.pow(10.0, n);
            this.XNODEO *= 0.01745329238474369;
            this.OMEGAO *= 0.01745329238474369;
            this.XMO *= 0.01745329238474369;
            this.XINCL *= 0.01745329238474369;
            double d2 = 3.030085591254411E-6;
            this.XNO = this.XNO * d2 * 1440.0;
            this.XNDT2O *= d2;
            this.XNDD6O = this.XNDD6O * d2 / 1440.0;
            this.BSTAR *= Math.pow(10.0, n2);
            this.DS50 = ephemeris.computeDS50(this.EPOCH);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SDP4
    extends Propagator {
        private double A1;
        private double COSIO;
        private double THETA2;
        private double X3THM1;
        private double EOSQ;
        private double BETAO2;
        private double BETAO;
        private double DEL1;
        private double DELO;
        private double AO;
        private double XNODP;
        private double AODP;
        private double S4;
        private double QOMS24;
        private double PERIGE;
        private double PINVSQ;
        private double SING;
        private double COSG;
        private double TSI;
        private double ETA;
        private double ETASQ;
        private double EETA;
        private double PSISQ;
        private double COEF;
        private double COEF1;
        private double c1;
        private double c2;
        private double C4;
        private double SINIO;
        private double A3OVK2;
        private double X1MTH2;
        private double THETA4;
        private double TEMP1;
        private double TEMP2;
        private double TEMP3;
        private double XMDOT;
        private double X1M5TH;
        private double OMGDOT;
        private double XHDOT1;
        private double XNODOT;
        private double XNODCF;
        private double T2COF;
        private double XLCOF;
        private double AYCOF;
        private double X7THM1;
        private DoubleRef XMDF;
        private DoubleRef OMGADF;
        private double XNODDF;
        private double TSQ;
        private DoubleRef XNODE;
        private double TEMPA;
        private double TEMPE;
        private double TEMPL;
        private DoubleRef XN;
        private DoubleRef EM;
        private DoubleRef XINC;
        private double A;
        private DoubleRef E;
        private DoubleRef XMAM;
        private double XL;
        private double BETA;
        private double AXN;
        private double TEMP;
        private double XLL;
        private double AYNL;
        private double XLT;
        private double AYN;
        private double CAPU;
        private double SINEPW;
        private double COSEPW;
        private double TEMP4;
        private double TEMP5;
        private double TEMP6;
        private double EPW;
        private double ECOSE;
        private double ESINE;
        private double ELSQ;
        private double PL;
        private double R;
        private double RDOT;
        private double RFDOT;
        private double BETAL;
        private double COSU;
        private double SINU;
        private double U;
        private double COS2U;
        private double SIN2U;
        private double RK;
        private double UK;
        private double XNODEK;
        private double XINCK;
        private double RDOTK;
        private double RFDOTK;
        private double SINUK;
        private double COSUK;
        private double SINIK;
        private double COSIK;
        private double SINNOK;
        private double COSNOK;
        private double XMX;
        private double XMY;
        private double UX;
        private double UY;
        private double UZ;
        private double VX;
        private double VY;
        private double VZ;
        private DEEP deep;

        private final void initialize() {
            this.A1 = Math.pow(0.07436691969633102 / this.es.XNO, 0.6666666865348816);
            this.COSIO = Math.cos(this.es.XINCL);
            this.THETA2 = this.COSIO * this.COSIO;
            this.X3THM1 = (double)3 * this.THETA2 - 1.0;
            this.EOSQ = this.es.EO * this.es.EO;
            this.BETAO2 = 1.0 - this.EOSQ;
            this.BETAO = Math.sqrt(this.BETAO2);
            this.DEL1 = 1.5 * ephemeris.this.CK2 * this.X3THM1 / (this.A1 * this.A1 * this.BETAO * this.BETAO2);
            this.AO = this.A1 * (1.0 - this.DEL1 * (0.3333333432674408 + this.DEL1 * (1.0 + (double)1.654321f * this.DEL1)));
            this.DELO = 1.5 * ephemeris.this.CK2 * this.X3THM1 / (this.AO * this.AO * this.BETAO * this.BETAO2);
            this.XNODP = this.es.XNO / (1.0 + this.DELO);
            this.AODP = this.AO / (1.0 - this.DELO);
            this.S4 = 1.0122292806386566;
            this.QOMS24 = ephemeris.this.QOMS2T;
            this.PERIGE = (this.AODP * (1.0 - this.es.EO) - 1.0) * 6378.134765625;
            if (this.PERIGE < 156.0) {
                this.S4 = this.PERIGE - 78.0;
                if (this.PERIGE <= 98.0) {
                    this.S4 = 20.0;
                }
                this.QOMS24 = Math.pow((120.0 - this.S4) / 6378.134765625, 4);
                this.S4 = this.S4 / 6378.134765625 + 1.0;
            }
            this.PINVSQ = 1.0 / (this.AODP * this.AODP * this.BETAO2 * this.BETAO2);
            this.SING = Math.sin(this.es.OMEGAO);
            this.COSG = Math.cos(this.es.OMEGAO);
            this.TSI = 1.0 / (this.AODP - this.S4);
            this.ETA = this.AODP * this.es.EO * this.TSI;
            this.ETASQ = this.ETA * this.ETA;
            this.EETA = this.es.EO * this.ETA;
            this.PSISQ = Math.abs(1.0 - this.ETASQ);
            this.COEF = this.QOMS24 * Math.pow(this.TSI, 4);
            this.COEF1 = this.COEF / Math.pow(this.PSISQ, 3.5);
            this.c2 = this.COEF1 * this.XNODP * (this.AODP * (1.0 + 1.5 * this.ETASQ + this.EETA * ((double)4 + this.ETASQ)) + 0.75 * ephemeris.this.CK2 * this.TSI / this.PSISQ * this.X3THM1 * (8.0 + (double)3 * this.ETASQ * (8.0 + this.ETASQ)));
            this.c1 = this.es.BSTAR * this.c2;
            this.SINIO = Math.sin(this.es.XINCL);
            this.A3OVK2 = (double)2.53881E-6f / ephemeris.this.CK2 * Math.pow(1.0, 3);
            this.X1MTH2 = 1.0 - this.THETA2;
            this.C4 = (double)2 * this.XNODP * this.COEF1 * this.AODP * this.BETAO2 * (this.ETA * ((double)2 + 0.5 * this.ETASQ) + this.es.EO * (0.5 + (double)2 * this.ETASQ) - (double)2 * ephemeris.this.CK2 * this.TSI / (this.AODP * this.PSISQ) * (-3.0 * this.X3THM1 * (1.0 - (double)2 * this.EETA + this.ETASQ * (1.5 - 0.5 * this.EETA)) + 0.75 * this.X1MTH2 * ((double)2 * this.ETASQ - this.EETA * (1.0 + this.ETASQ)) * Math.cos((double)2 * this.es.OMEGAO)));
            this.THETA4 = this.THETA2 * this.THETA2;
            this.TEMP1 = (double)3 * ephemeris.this.CK2 * this.PINVSQ * this.XNODP;
            this.TEMP2 = this.TEMP1 * ephemeris.this.CK2 * this.PINVSQ;
            this.TEMP3 = 1.25 * ephemeris.this.CK4 * this.PINVSQ * this.PINVSQ * this.XNODP;
            this.XMDOT = this.XNODP + 0.5 * this.TEMP1 * this.BETAO * this.X3THM1 + 0.0625 * this.TEMP2 * this.BETAO * (13.0 - 78.0 * this.THETA2 + 137.0 * this.THETA4);
            this.X1M5TH = 1.0 - (double)5 * this.THETA2;
            this.OMGDOT = -0.5 * this.TEMP1 * this.X1M5TH + 0.0625 * this.TEMP2 * (7.0 - 114.0 * this.THETA2 + 395.0 * this.THETA4) + this.TEMP3 * ((double)3 - 36.0 * this.THETA2 + 49.0 * this.THETA4);
            this.XHDOT1 = -this.TEMP1 * this.COSIO;
            this.XNODOT = this.XHDOT1 + (0.5 * this.TEMP2 * ((double)4 - 19.0 * this.THETA2) + (double)2 * this.TEMP3 * ((double)3 - 7.0 * this.THETA2)) * this.COSIO;
            this.XNODCF = 3.5 * this.BETAO2 * this.XHDOT1 * this.c1;
            this.T2COF = 1.5 * this.c1;
            this.XLCOF = 0.125 * this.A3OVK2 * this.SINIO * ((double)3 + (double)5 * this.COSIO) / (1.0 + this.COSIO);
            this.AYCOF = 0.25 * this.A3OVK2 * this.SINIO;
            this.X7THM1 = 7.0 * this.THETA2 - 1.0;
            this.deep = new DEEP();
            this.deep.DPINIT(this.es, this.EOSQ, this.SINIO, this.COSIO, this.BETAO, this.AODP, this.THETA2, this.SING, this.COSG, this.BETAO2, this.XMDOT, this.OMGDOT, this.XNODOT, this.XNODP);
        }

        public OrbitalState propagate(double d) {
            this.XMDF.value = this.es.XMO + this.XMDOT * d;
            this.OMGADF.value = this.es.OMEGAO + this.OMGDOT * d;
            this.XNODDF = this.es.XNODEO + this.XNODOT * d;
            this.TSQ = d * d;
            this.XNODE.value = this.XNODDF + this.XNODCF * this.TSQ;
            this.TEMPA = 1.0 - this.c1 * d;
            this.TEMPE = this.es.BSTAR * this.C4 * d;
            this.TEMPL = this.T2COF * this.TSQ;
            this.XN.value = this.XNODP;
            this.deep.DPSEC(this.es, this.XMDF, this.OMGADF, this.XNODE, this.EM, this.XINC, this.XN, d);
            this.A = Math.pow(0.07436691969633102 / this.XN.value, 0.6666666865348816) * Math.pow(this.TEMPA, 2);
            this.E.value = this.EM.value - this.TEMPE;
            this.XMAM.value = this.XMDF.value + this.XNODP * this.TEMPL;
            this.deep.DPPER(this.E, this.XINC, this.OMGADF, this.XNODE, this.XMAM);
            this.XL = this.XMAM.value + this.OMGADF.value + this.XNODE.value;
            this.BETA = Math.sqrt(1.0 - this.E.value * this.E.value);
            this.XN.value = 0.07436691969633102 / Math.pow(this.A, 1.5);
            this.AXN = this.E.value * Math.cos(this.OMGADF.value);
            this.TEMP = 1.0 / (this.A * this.BETA * this.BETA);
            this.XLL = this.TEMP * this.XLCOF * this.AXN;
            this.AYNL = this.TEMP * this.AYCOF;
            this.XLT = this.XL + this.XLL;
            this.AYN = this.E.value * Math.sin(this.OMGADF.value) + this.AYNL;
            this.TEMP2 = this.CAPU = ephemeris.FMOD2P(this.XLT - this.XNODE.value);
            int n = 1;
            while (n <= 10) {
                this.SINEPW = Math.sin(this.TEMP2);
                this.COSEPW = Math.cos(this.TEMP2);
                this.TEMP3 = this.AXN * this.SINEPW;
                this.TEMP4 = this.AYN * this.COSEPW;
                this.TEMP5 = this.AXN * this.COSEPW;
                this.TEMP6 = this.AYN * this.SINEPW;
                this.EPW = (this.CAPU - this.TEMP4 + this.TEMP3 - this.TEMP2) / (1.0 - this.TEMP5 - this.TEMP6) + this.TEMP2;
                if (Math.abs(this.EPW - this.TEMP2) <= (double)1.0E-6f) break;
                this.TEMP2 = this.EPW;
                ++n;
            }
            this.ECOSE = this.TEMP5 + this.TEMP6;
            this.ESINE = this.TEMP3 - this.TEMP4;
            this.ELSQ = this.AXN * this.AXN + this.AYN * this.AYN;
            this.TEMP = 1.0 - this.ELSQ;
            this.PL = this.A * this.TEMP;
            this.R = this.A * (1.0 - this.ECOSE);
            this.TEMP1 = 1.0 / this.R;
            this.RDOT = 0.07436691969633102 * Math.sqrt(this.A) * this.ESINE * this.TEMP1;
            this.RFDOT = 0.07436691969633102 * Math.sqrt(this.PL) * this.TEMP1;
            this.TEMP2 = this.A * this.TEMP1;
            this.BETAL = Math.sqrt(this.TEMP);
            this.TEMP3 = 1.0 / (1.0 + this.BETAL);
            this.COSU = this.TEMP2 * (this.COSEPW - this.AXN + this.AYN * this.ESINE * this.TEMP3);
            this.SINU = this.TEMP2 * (this.SINEPW - this.AYN - this.AXN * this.ESINE * this.TEMP3);
            this.U = ephemeris.ACTAN(this.SINU, this.COSU);
            this.SIN2U = (double)2 * this.SINU * this.COSU;
            this.COS2U = (double)2 * this.COSU * this.COSU - 1.0;
            this.TEMP = 1.0 / this.PL;
            this.TEMP1 = ephemeris.this.CK2 * this.TEMP;
            this.TEMP2 = this.TEMP1 * this.TEMP;
            this.RK = this.R * (1.0 - 1.5 * this.TEMP2 * this.BETAL * this.X3THM1) + 0.5 * this.TEMP1 * this.X1MTH2 * this.COS2U;
            this.UK = this.U - 0.25 * this.TEMP2 * this.X7THM1 * this.SIN2U;
            this.XNODEK = this.XNODE.value + 1.5 * this.TEMP2 * this.COSIO * this.SIN2U;
            this.XINCK = this.XINC.value + 1.5 * this.TEMP2 * this.COSIO * this.SINIO * this.COS2U;
            this.RDOTK = this.RDOT - this.XN.value * this.TEMP1 * this.X1MTH2 * this.SIN2U;
            this.RFDOTK = this.RFDOT + this.XN.value * this.TEMP1 * (this.X1MTH2 * this.COS2U + 1.5 * this.X3THM1);
            this.SINUK = Math.sin(this.UK);
            this.COSUK = Math.cos(this.UK);
            this.SINIK = Math.sin(this.XINCK);
            this.COSIK = Math.cos(this.XINCK);
            this.SINNOK = Math.sin(this.XNODEK);
            this.COSNOK = Math.cos(this.XNODEK);
            this.XMX = -this.SINNOK * this.COSIK;
            this.XMY = this.COSNOK * this.COSIK;
            this.UX = this.XMX * this.SINUK + this.COSNOK * this.COSUK;
            this.UY = this.XMY * this.SINUK + this.SINNOK * this.COSUK;
            this.UZ = this.SINIK * this.SINUK;
            this.VX = this.XMX * this.COSUK - this.COSNOK * this.SINUK;
            this.VY = this.XMY * this.COSUK - this.SINNOK * this.SINUK;
            this.VZ = this.SINIK * this.COSUK;
            OrbitalState orbitalState = new OrbitalState();
            double d2 = d * 60.0 / 86400.0 - (double)ephemeris.this.mod;
            orbitalState.julianTime = this.startTime + d2;
            orbitalState.X = this.RK * this.UX;
            orbitalState.Y = this.RK * this.UY;
            orbitalState.Z = this.RK * this.UZ;
            orbitalState.XDOT = this.RDOTK * this.UX + this.RFDOTK * this.VX;
            orbitalState.YDOT = this.RDOTK * this.UY + this.RFDOTK * this.VY;
            orbitalState.ZDOT = this.RDOTK * this.UZ + this.RFDOTK * this.VZ;
            orbitalState.X *= 6378.134765625;
            orbitalState.Y *= 6378.134765625;
            orbitalState.Z *= 6378.134765625;
            orbitalState.XDOT = orbitalState.XDOT * 6378.134765625 * 1440.0 / 86400.0;
            orbitalState.YDOT = orbitalState.YDOT * 6378.134765625 * 1440.0 / 86400.0;
            orbitalState.ZDOT = orbitalState.ZDOT * 6378.134765625 * 1440.0 / 86400.0;
            return orbitalState;
        }

        private final /* synthetic */ void this() {
            this.XMDF = new DoubleRef(0.0);
            this.OMGADF = new DoubleRef(0.0);
            this.XNODE = new DoubleRef(0.0);
            this.XN = new DoubleRef(0.0);
            this.EM = new DoubleRef(0.0);
            this.XINC = new DoubleRef(0.0);
            this.E = new DoubleRef(0.0);
            this.XMAM = new DoubleRef(0.0);
        }

        public SDP4(String string, ElementSet elementSet) {
            this.this();
            this.title = string;
            this.es = elementSet;
            this.startTime = elementSet.julian;
            this.initialize();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SGP4
    extends Propagator {
        private double A1;
        private double COSIO;
        private double THETA2;
        private double X3THM1;
        private double EOSQ;
        private double BETAO2;
        private double BETAO;
        private double DEL1;
        private double AO;
        private double DELO;
        private double XNODP;
        private double AODP;
        private int ISIMP;
        private double S4;
        private double QOMS24;
        private double PERIGE;
        private double PINVSQ;
        private double TSI;
        private double ETA;
        private double ETASQ;
        private double EETA;
        private double PSISQ;
        private double COEF;
        private double COEF1;
        private double c1;
        private double c2;
        private double c3;
        private double c4;
        private double c5;
        private double SINIO;
        private double A3OVK2;
        private double X1MTH2;
        private double THETA4;
        private double TEMP1;
        private double TEMP2;
        private double TEMP3;
        private double XMDOT;
        private double X1M5TH;
        private double OMGDOT;
        private double XHDOT1;
        private double XNODOT;
        private double OMGCOF;
        private double XMCOF;
        private double XNODCF;
        private double T2COF;
        private double XLCOF;
        private double AYCOF;
        private double DELMO;
        private double SINMO;
        private double X7THM1;
        private double C1SQ;
        private double D2;
        private double D3;
        private double D4;
        private double TEMP;
        private double T3COF;
        private double T4COF;
        private double T5COF;
        private double XMDF;
        private double OMGADF;
        private double OMEGA;
        private double XNODDF;
        private double XMP;
        private double TSQ;
        private double XNODE;
        private double TEMPA;
        private double TEMPE;
        private double TEMPL;
        private double DELOMG;
        private double DELM;
        private double TCUBE;
        private double TFOUR;
        private double A;
        private double E;
        private double XL;
        private double BETA;
        private double XN;
        private double AXN;
        private double XLL;
        private double AYNL;
        private double XLT;
        private double AYN;
        private double CAPU;
        private double SINEPW;
        private double COSEPW;
        private double TEMP4;
        private double TEMP5;
        private double TEMP6;
        private double EPW;
        private double ECOSE;
        private double ESINE;
        private double ELSQ;
        private double PL;
        private double R;
        private double RDOT;
        private double RFDOT;
        private double BETAL;
        private double COSU;
        private double SINU;
        private double U;
        private double COS2U;
        private double SIN2U;
        private double RK;
        private double UK;
        private double XNODEK;
        private double XINCK;
        private double RDOTK;
        private double RFDOTK;
        private double SINUK;
        private double COSUK;
        private double SINIK;
        private double COSIK;
        private double SINNOK;
        private double COSNOK;
        private double XMX;
        private double XMY;
        private double UX;
        private double UY;
        private double UZ;
        private double VX;
        private double VY;
        private double VZ;

        private final void initialize() {
            this.A1 = Math.pow(0.07436691969633102 / this.es.XNO, 0.6666666865348816);
            this.COSIO = Math.cos(this.es.XINCL);
            this.THETA2 = this.COSIO * this.COSIO;
            this.X3THM1 = (double)3 * this.THETA2 - 1.0;
            this.EOSQ = this.es.EO * this.es.EO;
            this.BETAO2 = 1.0 - this.EOSQ;
            this.BETAO = Math.sqrt(this.BETAO2);
            this.DEL1 = 1.5 * ephemeris.this.CK2 * this.X3THM1 / (this.A1 * this.A1 * this.BETAO * this.BETAO2);
            this.AO = this.A1 * (1.0 - this.DEL1 * (0.3333333432674408 + this.DEL1 * (1.0 + (double)1.654321f * this.DEL1)));
            this.DELO = 1.5 * ephemeris.this.CK2 * this.X3THM1 / (this.AO * this.AO * this.BETAO * this.BETAO2);
            this.XNODP = this.es.XNO / (1.0 + this.DELO);
            this.AODP = this.AO / (1.0 - this.DELO);
            this.ISIMP = 0;
            if (this.AODP * (1.0 - this.es.EO) < 1.03449284282698) {
                this.ISIMP = 1;
            }
            this.S4 = 1.0122292806386566;
            this.QOMS24 = ephemeris.this.QOMS2T;
            this.PERIGE = (this.AODP * (1.0 - this.es.EO) - 1.0) * 6378.134765625;
            if (this.PERIGE < 156.0) {
                this.S4 = this.PERIGE - 78.0;
                if (this.PERIGE <= 98.0) {
                    this.S4 = 20.0;
                }
                this.QOMS24 = Math.pow((120.0 - this.S4) / 6378.134765625, 4);
                this.S4 = this.S4 / 6378.134765625 + 1.0;
            }
            this.PINVSQ = 1.0 / (this.AODP * this.AODP * this.BETAO2 * this.BETAO2);
            this.TSI = 1.0 / (this.AODP - this.S4);
            this.ETA = this.AODP * this.es.EO * this.TSI;
            this.ETASQ = this.ETA * this.ETA;
            this.EETA = this.es.EO * this.ETA;
            this.PSISQ = Math.abs(1.0 - this.ETASQ);
            this.COEF = this.QOMS24 * Math.pow(this.TSI, 4);
            this.COEF1 = this.COEF / Math.pow(this.PSISQ, 3.5);
            this.c2 = this.COEF1 * this.XNODP * (this.AODP * (1.0 + 1.5 * this.ETASQ + this.EETA * ((double)4 + this.ETASQ)) + 0.75 * ephemeris.this.CK2 * this.TSI / this.PSISQ * this.X3THM1 * (8.0 + (double)3 * this.ETASQ * (8.0 + this.ETASQ)));
            this.c1 = this.es.BSTAR * this.c2;
            this.SINIO = Math.sin(this.es.XINCL);
            this.A3OVK2 = (double)2.53881E-6f / ephemeris.this.CK2 * Math.pow(1.0, 3);
            this.c3 = this.COEF * this.TSI * this.A3OVK2 * this.XNODP * this.SINIO / this.es.EO;
            this.X1MTH2 = 1.0 - this.THETA2;
            this.c4 = (double)2 * this.XNODP * this.COEF1 * this.AODP * this.BETAO2 * (this.ETA * ((double)2 + 0.5 * this.ETASQ) + this.es.EO * (0.5 + (double)2 * this.ETASQ) - (double)2 * ephemeris.this.CK2 * this.TSI / (this.AODP * this.PSISQ) * (-3.0 * this.X3THM1 * (1.0 - (double)2 * this.EETA + this.ETASQ * (1.5 - 0.5 * this.EETA)) + 0.75 * this.X1MTH2 * ((double)2 * this.ETASQ - this.EETA * (1.0 + this.ETASQ)) * Math.cos((double)2 * this.es.OMEGAO)));
            this.c5 = (double)2 * this.COEF1 * this.AODP * this.BETAO2 * (1.0 + 2.75 * (this.ETASQ + this.EETA) + this.EETA * this.ETASQ);
            this.THETA4 = this.THETA2 * this.THETA2;
            this.TEMP1 = (double)3 * ephemeris.this.CK2 * this.PINVSQ * this.XNODP;
            this.TEMP2 = this.TEMP1 * ephemeris.this.CK2 * this.PINVSQ;
            this.TEMP3 = 1.25 * ephemeris.this.CK4 * this.PINVSQ * this.PINVSQ * this.XNODP;
            this.XMDOT = this.XNODP + 0.5 * this.TEMP1 * this.BETAO * this.X3THM1 + 0.0625 * this.TEMP2 * this.BETAO * (13.0 - 78.0 * this.THETA2 + 137.0 * this.THETA4);
            this.X1M5TH = 1.0 - (double)5 * this.THETA2;
            this.OMGDOT = -0.5 * this.TEMP1 * this.X1M5TH + 0.0625 * this.TEMP2 * (7.0 - 114.0 * this.THETA2 + 395.0 * this.THETA4) + this.TEMP3 * ((double)3 - 36.0 * this.THETA2 + 49.0 * this.THETA4);
            this.XHDOT1 = -this.TEMP1 * this.COSIO;
            this.XNODOT = this.XHDOT1 + (0.5 * this.TEMP2 * ((double)4 - 19.0 * this.THETA2) + (double)2 * this.TEMP3 * ((double)3 - 7.0 * this.THETA2)) * this.COSIO;
            this.OMGCOF = this.es.BSTAR * this.c3 * Math.cos(this.es.OMEGAO);
            this.XMCOF = -0.6666666865348816 * this.COEF * this.es.BSTAR / this.EETA;
            this.XNODCF = 3.5 * this.BETAO2 * this.XHDOT1 * this.c1;
            this.T2COF = 1.5 * this.c1;
            this.XLCOF = 0.125 * this.A3OVK2 * this.SINIO * ((double)3 + (double)5 * this.COSIO) / (1.0 + this.COSIO);
            this.AYCOF = 0.25 * this.A3OVK2 * this.SINIO;
            this.DELMO = Math.pow(1.0 + this.ETA * Math.cos(this.es.XMO), 3);
            this.SINMO = Math.sin(this.es.XMO);
            this.X7THM1 = 7.0 * this.THETA2 - 1.0;
            if (this.ISIMP != 1) {
                this.C1SQ = this.c1 * this.c1;
                this.D2 = (double)4 * this.AODP * this.TSI * this.C1SQ;
                this.TEMP = this.D2 * this.TSI * this.c1 / (double)3;
                this.D3 = (17.0 * this.AODP + this.S4) * this.TEMP;
                this.D4 = 0.5 * this.TEMP * this.AODP * this.TSI * (221.0 * this.AODP + 31.0 * this.S4) * this.c1;
                this.T3COF = this.D2 + (double)2 * this.C1SQ;
                this.T4COF = 0.25 * ((double)3 * this.D3 + this.c1 * (12.0 * this.D2 + 10.0 * this.C1SQ));
                this.T5COF = (double)0.2f * ((double)3 * this.D4 + 12.0 * this.c1 * this.D3 + 6.0 * this.D2 * this.D2 + 15.0 * this.C1SQ * ((double)2 * this.D2 + this.C1SQ));
            }
        }

        public OrbitalState propagate(double d) {
            this.XMDF = this.es.XMO + this.XMDOT * d;
            this.OMGADF = this.es.OMEGAO + this.OMGDOT * d;
            this.XNODDF = this.es.XNODEO + this.XNODOT * d;
            this.OMEGA = this.OMGADF;
            this.XMP = this.XMDF;
            this.TSQ = d * d;
            this.XNODE = this.XNODDF + this.XNODCF * this.TSQ;
            this.TEMPA = 1.0 - this.c1 * d;
            this.TEMPE = this.es.BSTAR * this.c4 * d;
            this.TEMPL = this.T2COF * this.TSQ;
            if (this.ISIMP != 1) {
                this.DELOMG = this.OMGCOF * d;
                this.DELM = this.XMCOF * (Math.pow(1.0 + this.ETA * Math.cos(this.XMDF), 3) - this.DELMO);
                this.TEMP = this.DELOMG + this.DELM;
                this.XMP = this.XMDF + this.TEMP;
                this.OMEGA = this.OMGADF - this.TEMP;
                this.TCUBE = this.TSQ * d;
                this.TFOUR = d * this.TCUBE;
                this.TEMPA = this.TEMPA - this.D2 * this.TSQ - this.D3 * this.TCUBE - this.D4 * this.TFOUR;
                this.TEMPE += this.es.BSTAR * this.c5 * (Math.sin(this.XMP) - this.SINMO);
                this.TEMPL = this.TEMPL + this.T3COF * this.TCUBE + this.TFOUR * (this.T4COF + d * this.T5COF);
            }
            this.A = this.AODP * Math.pow(this.TEMPA, 2);
            this.E = this.es.EO - this.TEMPE;
            this.XL = this.XMP + this.OMEGA + this.XNODE + this.XNODP * this.TEMPL;
            this.BETA = Math.sqrt(1.0 - this.E * this.E);
            this.XN = 0.07436691969633102 / Math.pow(this.A, 1.5);
            this.AXN = this.E * Math.cos(this.OMEGA);
            this.TEMP = 1.0 / (this.A * this.BETA * this.BETA);
            this.XLL = this.TEMP * this.XLCOF * this.AXN;
            this.AYNL = this.TEMP * this.AYCOF;
            this.XLT = this.XL + this.XLL;
            this.AYN = this.E * Math.sin(this.OMEGA) + this.AYNL;
            this.TEMP2 = this.CAPU = ephemeris.FMOD2P(this.XLT - this.XNODE);
            int n = 1;
            while (n <= 10) {
                this.SINEPW = Math.sin(this.TEMP2);
                this.COSEPW = Math.cos(this.TEMP2);
                this.TEMP3 = this.AXN * this.SINEPW;
                this.TEMP4 = this.AYN * this.COSEPW;
                this.TEMP5 = this.AXN * this.COSEPW;
                this.TEMP6 = this.AYN * this.SINEPW;
                this.EPW = (this.CAPU - this.TEMP4 + this.TEMP3 - this.TEMP2) / (1.0 - this.TEMP5 - this.TEMP6) + this.TEMP2;
                if (Math.abs(this.EPW - this.TEMP2) <= (double)1.0E-6f) break;
                this.TEMP2 = this.EPW;
                ++n;
            }
            this.ECOSE = this.TEMP5 + this.TEMP6;
            this.ESINE = this.TEMP3 - this.TEMP4;
            this.ELSQ = this.AXN * this.AXN + this.AYN * this.AYN;
            this.TEMP = 1.0 - this.ELSQ;
            this.PL = this.A * this.TEMP;
            this.R = this.A * (1.0 - this.ECOSE);
            this.TEMP1 = 1.0 / this.R;
            this.RDOT = 0.07436691969633102 * Math.sqrt(this.A) * this.ESINE * this.TEMP1;
            this.RFDOT = 0.07436691969633102 * Math.sqrt(this.PL) * this.TEMP1;
            this.TEMP2 = this.A * this.TEMP1;
            this.BETAL = Math.sqrt(this.TEMP);
            this.TEMP3 = 1.0 / (1.0 + this.BETAL);
            this.COSU = this.TEMP2 * (this.COSEPW - this.AXN + this.AYN * this.ESINE * this.TEMP3);
            this.SINU = this.TEMP2 * (this.SINEPW - this.AYN - this.AXN * this.ESINE * this.TEMP3);
            this.U = ephemeris.ACTAN(this.SINU, this.COSU);
            this.SIN2U = (double)2 * this.SINU * this.COSU;
            this.COS2U = (double)2 * this.COSU * this.COSU - 1.0;
            this.TEMP = 1.0 / this.PL;
            this.TEMP1 = ephemeris.this.CK2 * this.TEMP;
            this.TEMP2 = this.TEMP1 * this.TEMP;
            this.RK = this.R * (1.0 - 1.5 * this.TEMP2 * this.BETAL * this.X3THM1) + 0.5 * this.TEMP1 * this.X1MTH2 * this.COS2U;
            this.UK = this.U - 0.25 * this.TEMP2 * this.X7THM1 * this.SIN2U;
            this.XNODEK = this.XNODE + 1.5 * this.TEMP2 * this.COSIO * this.SIN2U;
            this.XINCK = this.es.XINCL + 1.5 * this.TEMP2 * this.COSIO * this.SINIO * this.COS2U;
            this.RDOTK = this.RDOT - this.XN * this.TEMP1 * this.X1MTH2 * this.SIN2U;
            this.RFDOTK = this.RFDOT + this.XN * this.TEMP1 * (this.X1MTH2 * this.COS2U + 1.5 * this.X3THM1);
            this.SINUK = Math.sin(this.UK);
            this.COSUK = Math.cos(this.UK);
            this.SINIK = Math.sin(this.XINCK);
            this.COSIK = Math.cos(this.XINCK);
            this.SINNOK = Math.sin(this.XNODEK);
            this.COSNOK = Math.cos(this.XNODEK);
            this.XMX = -this.SINNOK * this.COSIK;
            this.XMY = this.COSNOK * this.COSIK;
            this.UX = this.XMX * this.SINUK + this.COSNOK * this.COSUK;
            this.UY = this.XMY * this.SINUK + this.SINNOK * this.COSUK;
            this.UZ = this.SINIK * this.SINUK;
            this.VX = this.XMX * this.COSUK - this.COSNOK * this.SINUK;
            this.VY = this.XMY * this.COSUK - this.SINNOK * this.SINUK;
            this.VZ = this.SINIK * this.COSUK;
            OrbitalState orbitalState = new OrbitalState();
            double d2 = d * 60.0 / 86400.0;
            orbitalState.julianTime = this.startTime + d2 - (double)ephemeris.this.mod;
            orbitalState.X = this.RK * this.UX;
            orbitalState.Y = this.RK * this.UY;
            orbitalState.Z = this.RK * this.UZ;
            orbitalState.XDOT = this.RDOTK * this.UX + this.RFDOTK * this.VX;
            orbitalState.YDOT = this.RDOTK * this.UY + this.RFDOTK * this.VY;
            orbitalState.ZDOT = this.RDOTK * this.UZ + this.RFDOTK * this.VZ;
            orbitalState.X *= 6378.134765625;
            orbitalState.Y *= 6378.134765625;
            orbitalState.Z *= 6378.134765625;
            orbitalState.XDOT = orbitalState.XDOT * 6378.134765625 * 1440.0 / 86400.0;
            orbitalState.YDOT = orbitalState.YDOT * 6378.134765625 * 1440.0 / 86400.0;
            orbitalState.ZDOT = orbitalState.ZDOT * 6378.134765625 * 1440.0 / 86400.0;
            return orbitalState;
        }

        public SGP4(String string, ElementSet elementSet) {
            this.title = string;
            this.es = elementSet;
            this.startTime = elementSet.julian;
            this.initialize();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class OrbitalState {
        public double julianTime;
        public double X;
        public double Y;
        public double Z;
        public double XDOT;
        public double YDOT;
        public double ZDOT;

        public final String toString() {
            return this.X + " : " + this.Y + ':' + this.Z;
        }

        private final /* synthetic */ void this() {
            this.julianTime = 0.0;
            this.X = 0.0;
            this.Y = 0.0;
            this.Z = 0.0;
            this.XDOT = 0.0;
            this.YDOT = 0.0;
            this.ZDOT = 0.0;
        }

        public OrbitalState() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DoubleRef {
        double value;

        private final /* synthetic */ void this() {
            this.value = 0.0;
        }

        DoubleRef(double d) {
            this.this();
            this.value = d;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Tuple3 {
        float x;
        float y;
        float z;
        float uv;
        float uw;

        Tuple3() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DEEP {
        double DAY;
        double PREEP;
        double XNODCE;
        double ATIME;
        double DELT;
        double SAVTSN;
        double STEP2;
        double STEPN;
        double STEPP;
        double ZNS;
        double C1SS;
        double ZES;
        double ZNL;
        double C1L;
        double ZEL;
        double ZCOSIS;
        double ZSINIS;
        double ZSINGS;
        double ZCOSGS;
        double ZCOSHS;
        double ZSINHS;
        double Q22;
        double Q31;
        double Q33;
        double G22;
        double G32;
        double G44;
        double G52;
        double G54;
        double ROOT22;
        double ROOT32;
        double ROOT44;
        double ROOT52;
        double ROOT54;
        double THDT;
        double THGR;
        double EQ;
        double XNQ;
        double AQNV;
        double XQNCL;
        double XMAO;
        double XPIDOT;
        double SINQ;
        double COSQ;
        double OMEGAQ;
        double STEM;
        double CTEM;
        double ZCOSIL;
        double ZSINIL;
        double ZSINHL;
        double ZCOSHL;
        double C;
        double GAM;
        double ZMOL;
        double ZX;
        double ZY;
        double ZCOSGL;
        double ZSINGL;
        double ZMOS;
        int LS;
        double ZCOSG;
        double ZSING;
        double ZCOSI;
        double ZSINI;
        double ZCOSH;
        double ZSINH;
        double CC;
        double ZN;
        double ZE;
        double ZMO;
        double XNOI;
        double A1;
        double A3;
        double A7;
        double A8;
        double A9;
        double A10;
        double A2;
        double A4;
        double A5;
        double A6;
        double X1;
        double X2;
        double X3;
        double X4;
        double X5;
        double X6;
        double X7;
        double X8;
        double Z31;
        double Z32;
        double Z33;
        double Z1;
        double Z2;
        double Z3;
        double Z11;
        double Z12;
        double Z13;
        double Z21;
        double Z22;
        double Z23;
        double S1;
        double S2;
        double S3;
        double S4;
        double S5;
        double S6;
        double S7;
        double SE;
        double SI;
        double SL;
        double SGH;
        double SH;
        double EE2;
        double E3;
        double XI2;
        double XI3;
        double XL2;
        double XL3;
        double XL4;
        double XGH2;
        double XGH3;
        double XGH4;
        double XH2;
        double XH3;
        double SSE;
        double SSI;
        double SSL;
        double SSH;
        double SSG;
        double SE2;
        double SI2;
        double SL2;
        double SGH2;
        double SH2;
        double SE3;
        double SI3;
        double SL3;
        double SGH3;
        double SH3;
        double SL4;
        double SGH4;
        int IRESFL;
        int ISYNFL;
        double EOC;
        double G201;
        double G211;
        double G310;
        double G322;
        double G410;
        double G422;
        double G520;
        double G533;
        double G521;
        double G532;
        double SINI2;
        double F220;
        double F221;
        double F321;
        double F322;
        double F441;
        double F442;
        double F522;
        double F523;
        double F542;
        double F543;
        double XNO2;
        double AINV2;
        double TEMP1;
        double TEMP;
        double D2201;
        double D2211;
        double D3210;
        double D3222;
        double D4410;
        double D4422;
        double D5220;
        double D5232;
        double D5421;
        double D5433;
        double XLAMO;
        double BFACT;
        double G200;
        double G300;
        double F311;
        double F330;
        double DEL1;
        double DEL2;
        double DEL3;
        double FASX2;
        double FASX4;
        double FASX6;
        double XFACT;
        double XLI;
        double XNI;
        int IRET;
        int IRETN;
        double FT;
        double XNDOT;
        double XNDDT;
        double OMGDT;
        double XOMI;
        double X2OMI;
        double X2LI;
        double XLDOT;
        double XL;
        double T;
        double ZM;
        double ZF;
        double SINZF;
        double F2;
        double F3;
        double SES;
        double SIS;
        double SLS;
        double SGHS;
        double SHS;
        double SEL;
        double SIL;
        double SLL;
        double SGHL;
        double SHL;
        double PE;
        double PINC;
        double PL;
        double PGH;
        double PH;
        double SINIQ;
        double COSIQ;
        double SINOK;
        double COSOK;
        double ALFDP;
        double BETDP;
        double DALF;
        double DBET;
        double XLS;
        double DLS;
        double SINIS;
        double COSIS;

        public void DPINIT(ElementSet elementSet, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
            this.OMGDT = d11;
            this.SINIQ = d2;
            this.COSIQ = d3;
            this.THGR = ephemeris.THETAG(elementSet.DS50);
            this.EQ = elementSet.EO;
            this.XNQ = d13;
            this.AQNV = 1.0 / d5;
            this.XQNCL = elementSet.XINCL;
            this.XMAO = elementSet.XMO;
            this.XPIDOT = d11 + d12;
            this.SINQ = Math.sin(elementSet.XNODEO);
            this.COSQ = Math.cos(elementSet.XNODEO);
            this.OMEGAQ = elementSet.OMEGAO;
            this.DAY = elementSet.DS50 + 18261.5;
            if (this.DAY != this.PREEP) {
                this.PREEP = this.DAY;
                this.XNODCE = 4.52360200881958 - 9.242203086614609E-4 * this.DAY;
                this.STEM = Math.sin(this.XNODCE);
                this.CTEM = Math.cos(this.XNODCE);
                this.ZCOSIL = 0.9137516617774963 - 0.03568096086382866 * this.CTEM;
                this.ZSINIL = Math.sqrt(1.0 - this.ZCOSIL * this.ZCOSIL);
                this.ZSINHL = 0.08968351036310196 * this.STEM / this.ZSINIL;
                this.ZCOSHL = Math.sqrt(1.0 - this.ZSINHL * this.ZSINHL);
                this.C = 4.719967365264893 + 0.2299714982509613 * this.DAY;
                this.GAM = 5.835151195526123 + (double)0.001944368f * this.DAY;
                this.ZMOL = ephemeris.FMOD2P(this.C - this.GAM);
                this.ZX = 0.39785414934158325 * this.STEM / this.ZSINIL;
                this.ZY = this.ZCOSHL * this.CTEM + 0.9174486994743347 * this.ZSINHL * this.STEM;
                this.ZX = ephemeris.ACTAN(this.ZX, this.ZY);
                this.ZX = this.GAM + this.ZX - this.XNODCE;
                this.ZCOSGL = Math.cos(this.ZX);
                this.ZSINGL = Math.sin(this.ZX);
                this.ZMOS = 6.2565836906433105 + 0.017201976850628853 * this.DAY;
                this.ZMOS = ephemeris.FMOD2P(this.ZMOS);
            }
            this.LS = 0;
            this.SAVTSN = 1.0E20f;
            this.ZCOSG = this.ZCOSGS;
            this.ZSING = this.ZSINGS;
            this.ZCOSI = this.ZCOSIS;
            this.ZSINI = this.ZSINIS;
            this.ZCOSH = this.COSQ;
            this.ZSINH = this.SINQ;
            this.CC = this.C1SS;
            this.ZN = this.ZNS;
            this.ZE = this.ZES;
            this.ZMO = this.ZMOS;
            this.XNOI = 1.0 / this.XNQ;
            this.LS = 30;
            while (true) {
                this.A1 = this.ZCOSG * this.ZCOSH + this.ZSING * this.ZCOSI * this.ZSINH;
                this.A3 = -this.ZSING * this.ZCOSH + this.ZCOSG * this.ZCOSI * this.ZSINH;
                this.A7 = -this.ZCOSG * this.ZSINH + this.ZSING * this.ZCOSI * this.ZCOSH;
                this.A8 = this.ZSING * this.ZSINI;
                this.A9 = this.ZSING * this.ZSINH + this.ZCOSG * this.ZCOSI * this.ZCOSH;
                this.A10 = this.ZCOSG * this.ZSINI;
                this.A2 = d3 * this.A7 + d2 * this.A8;
                this.A4 = d3 * this.A9 + d2 * this.A10;
                this.A5 = -d2 * this.A7 + d3 * this.A8;
                this.A6 = -d2 * this.A9 + d3 * this.A10;
                this.X1 = this.A1 * d8 + this.A2 * d7;
                this.X2 = this.A3 * d8 + this.A4 * d7;
                this.X3 = -this.A1 * d7 + this.A2 * d8;
                this.X4 = -this.A3 * d7 + this.A4 * d8;
                this.X5 = this.A5 * d7;
                this.X6 = this.A6 * d7;
                this.X7 = this.A5 * d8;
                this.X8 = this.A6 * d8;
                this.Z31 = 12.0 * this.X1 * this.X1 - (double)3 * this.X3 * this.X3;
                this.Z32 = 24.0 * this.X1 * this.X2 - 6.0 * this.X3 * this.X4;
                this.Z33 = 12.0 * this.X2 * this.X2 - (double)3 * this.X4 * this.X4;
                this.Z1 = (double)3 * (this.A1 * this.A1 + this.A2 * this.A2) + this.Z31 * d;
                this.Z2 = 6.0 * (this.A1 * this.A3 + this.A2 * this.A4) + this.Z32 * d;
                this.Z3 = (double)3 * (this.A3 * this.A3 + this.A4 * this.A4) + this.Z33 * d;
                this.Z11 = -6.0 * this.A1 * this.A5 + d * (-24.0 * this.X1 * this.X7 - 6.0 * this.X3 * this.X5);
                this.Z12 = -6.0 * (this.A1 * this.A6 + this.A3 * this.A5) + d * (-24.0 * (this.X2 * this.X7 + this.X1 * this.X8) - 6.0 * (this.X3 * this.X6 + this.X4 * this.X5));
                this.Z13 = -6.0 * this.A3 * this.A6 + d * (-24.0 * this.X2 * this.X8 - 6.0 * this.X4 * this.X6);
                this.Z21 = 6.0 * this.A2 * this.A5 + d * (24.0 * this.X1 * this.X5 - 6.0 * this.X3 * this.X7);
                this.Z22 = 6.0 * (this.A4 * this.A5 + this.A2 * this.A6) + d * (24.0 * (this.X2 * this.X5 + this.X1 * this.X6) - 6.0 * (this.X4 * this.X7 + this.X3 * this.X8));
                this.Z23 = 6.0 * this.A4 * this.A6 + d * (24.0 * this.X2 * this.X6 - 6.0 * this.X4 * this.X8);
                this.Z1 = this.Z1 + this.Z1 + d9 * this.Z31;
                this.Z2 = this.Z2 + this.Z2 + d9 * this.Z32;
                this.Z3 = this.Z3 + this.Z3 + d9 * this.Z33;
                this.S3 = this.CC * this.XNOI;
                this.S2 = -0.5 * this.S3 / d4;
                this.S4 = this.S3 * d4;
                this.S1 = -15.0 * this.EQ * this.S4;
                this.S5 = this.X1 * this.X3 + this.X2 * this.X4;
                this.S6 = this.X2 * this.X3 + this.X1 * this.X4;
                this.S7 = this.X2 * this.X4 - this.X1 * this.X3;
                this.SE = this.S1 * this.ZN * this.S5;
                this.SI = this.S2 * this.ZN * (this.Z11 + this.Z13);
                this.SL = -this.ZN * this.S3 * (this.Z1 + this.Z3 - 14.0 - 6.0 * d);
                this.SGH = this.S4 * this.ZN * (this.Z31 + this.Z33 - 6.0);
                this.SH = -this.ZN * this.S2 * (this.Z21 + this.Z23);
                if (this.XQNCL < 0.05235987529158592) {
                    this.SH = 0.0;
                }
                this.EE2 = (double)2 * this.S1 * this.S6;
                this.E3 = (double)2 * this.S1 * this.S7;
                this.XI2 = (double)2 * this.S2 * this.Z12;
                this.XI3 = (double)2 * this.S2 * (this.Z13 - this.Z11);
                this.XL2 = -2.0 * this.S3 * this.Z2;
                this.XL3 = -2.0 * this.S3 * (this.Z3 - this.Z1);
                this.XL4 = -2.0 * this.S3 * (-21.0 - 9.0 * d) * this.ZE;
                this.XGH2 = (double)2 * this.S4 * this.Z32;
                this.XGH3 = (double)2 * this.S4 * (this.Z33 - this.Z31);
                this.XGH4 = -18.0 * this.S4 * this.ZE;
                this.XH2 = -2.0 * this.S2 * this.Z22;
                this.XH3 = -2.0 * this.S2 * (this.Z23 - this.Z21);
                if (this.LS == 40) break;
                this.SSE = this.SE;
                this.SSI = this.SI;
                this.SSL = this.SL;
                this.SSH = this.SH / d2;
                this.SSG = this.SGH - d3 * this.SSH;
                this.SE2 = this.EE2;
                this.SI2 = this.XI2;
                this.SL2 = this.XL2;
                this.SGH2 = this.XGH2;
                this.SH2 = this.XH2;
                this.SE3 = this.E3;
                this.SI3 = this.XI3;
                this.SL3 = this.XL3;
                this.SGH3 = this.XGH3;
                this.SH3 = this.XH3;
                this.SL4 = this.XL4;
                this.SGH4 = this.XGH4;
                this.LS = 1;
                this.ZCOSG = this.ZCOSGL;
                this.ZSING = this.ZSINGL;
                this.ZCOSI = this.ZCOSIL;
                this.ZSINI = this.ZSINIL;
                this.ZCOSH = this.ZCOSHL * this.COSQ + this.ZSINHL * this.SINQ;
                this.ZSINH = this.SINQ * this.ZCOSHL - this.COSQ * this.ZSINHL;
                this.ZN = this.ZNL;
                this.CC = this.C1L;
                this.ZE = this.ZEL;
                this.ZMO = this.ZMOL;
                this.LS = 40;
            }
            this.SSE += this.SE;
            this.SSI += this.SI;
            this.SSL += this.SL;
            this.SSG = this.SSG + this.SGH - d3 / d2 * this.SH;
            this.SSH += this.SH / d2;
            this.IRESFL = 0;
            this.ISYNFL = 0;
            if (this.XNQ >= 0.005235987715423107 || this.XNQ <= 0.003490658476948738) {
                if (this.XNQ < (double)0.00826f || this.XNQ > (double)0.00924f) {
                    return;
                }
                if (this.EQ < 0.5) {
                    return;
                }
                this.IRESFL = 1;
                this.EOC = this.EQ * d;
                this.G201 = (double)-0.306f - (this.EQ - (double)0.64f) * (double)0.44f;
                if (this.EQ <= (double)0.65f) {
                    this.G211 = (double)3.616f - (double)13.247f * this.EQ + (double)16.29f * d;
                    this.G310 = (double)-19.302f + (double)117.39f * this.EQ - (double)228.419f * d + (double)156.591f * this.EOC;
                    this.G322 = (double)-18.9068f + 109.7927017211914 * this.EQ - 214.63339233398438 * d + (double)146.5816f * this.EOC;
                    this.G410 = (double)-41.122f + (double)242.694f * this.EQ - 471.093994140625 * d + (double)313.953f * this.EOC;
                    this.G422 = (double)-146.407f + (double)841.88f * this.EQ - (double)1629.014f * d + 1083.43505859375 * this.EOC;
                    this.G520 = -532.114013671875 + 3017.97705078125 * this.EQ - 5740.0 * d + 3708.27587890625 * this.EOC;
                } else {
                    this.G211 = (double)-72.099f + (double)331.819f * this.EQ - (double)508.738f * d + (double)266.724f * this.EOC;
                    this.G310 = -346.843994140625 + (double)1582.851f * this.EQ - 2415.925048828125 * d + 1246.113037109375 * this.EOC;
                    this.G322 = (double)-342.585f + 1554.907958984375 * this.EQ - 2366.89892578125 * d + (double)1215.972f * this.EOC;
                    this.G410 = (double)-1052.797f + 4758.68603515625 * this.EQ - 7193.9921875 * d + 3651.95703125 * this.EOC;
                    this.G422 = -3581.68994140625 + 16178.1103515625 * this.EQ - 24462.76953125 * d + 12422.51953125 * this.EOC;
                    this.G520 = this.EQ <= (double)0.715f ? (double)1464.74f - 4664.75 * this.EQ + (double)3763.64f * d : -5149.66015625 + 29936.919921875 * this.EQ - 54087.359375 * d + 31324.560546875 * this.EOC;
                }
                if (this.EQ < (double)0.7f) {
                    this.G533 = -919.2277221679688 + 4988.60986328125 * this.EQ - 9064.76953125 * d + 5542.2099609375 * this.EOC;
                    this.G521 = -822.710693359375 + 4568.6171875 * this.EQ - 8491.4150390625 * d + 5337.52392578125 * this.EOC;
                    this.G532 = -853.666015625 + 4690.25 * this.EQ - 8624.76953125 * d + (double)5341.4f * this.EOC;
                } else {
                    this.G533 = -37995.78125 + 161616.515625 * this.EQ - 229838.203125 * d + 109377.9375 * this.EOC;
                    this.G521 = -51752.10546875 + 218913.953125 * this.EQ - 309468.15625 * d + 146349.421875 * this.EOC;
                    this.G532 = -40023.87890625 + 170470.890625 * this.EQ - 242699.484375 * d + 115605.8203125 * this.EOC;
                }
                this.SINI2 = d2 * d2;
                this.F220 = 0.75 * (1.0 + (double)2 * d3 + d6);
                this.F221 = 1.5 * this.SINI2;
                this.F321 = 1.875 * d2 * (1.0 - (double)2 * d3 - (double)3 * d6);
                this.F322 = -1.875 * d2 * (1.0 + (double)2 * d3 - (double)3 * d6);
                this.F441 = 35.0 * this.SINI2 * this.F220;
                this.F442 = 39.375 * this.SINI2 * this.SINI2;
                this.F522 = 9.84375 * d2 * (this.SINI2 * (1.0 - (double)2 * d3 - (double)5 * d6) + 0.3333333432674408 * (-2.0 + (double)4 * d3 + 6.0 * d6));
                this.F523 = d2 * (4.921875 * this.SINI2 * (-2.0 - (double)4 * d3 + 10.0 * d6) + 6.5625 * (1.0 + (double)2 * d3 - (double)3 * d6));
                this.F542 = 29.53125 * d2 * ((double)2 - 8.0 * d3 + d6 * (-12.0 + 8.0 * d3 + 10.0 * d6));
                this.F543 = 29.53125 * d2 * (-2.0 - 8.0 * d3 + d6 * (12.0 + 8.0 * d3 - 10.0 * d6));
                this.XNO2 = this.XNQ * this.XNQ;
                this.AINV2 = this.AQNV * this.AQNV;
                this.TEMP1 = (double)3 * this.XNO2 * this.AINV2;
                this.TEMP = this.TEMP1 * this.ROOT22;
                this.D2201 = this.TEMP * this.F220 * this.G201;
                this.D2211 = this.TEMP * this.F221 * this.G211;
                this.TEMP1 *= this.AQNV;
                this.TEMP = this.TEMP1 * this.ROOT32;
                this.D3210 = this.TEMP * this.F321 * this.G310;
                this.D3222 = this.TEMP * this.F322 * this.G322;
                this.TEMP1 *= this.AQNV;
                this.TEMP = (double)2 * this.TEMP1 * this.ROOT44;
                this.D4410 = this.TEMP * this.F441 * this.G410;
                this.D4422 = this.TEMP * this.F442 * this.G422;
                this.TEMP1 *= this.AQNV;
                this.TEMP = this.TEMP1 * this.ROOT52;
                this.D5220 = this.TEMP * this.F522 * this.G520;
                this.D5232 = this.TEMP * this.F523 * this.G532;
                this.TEMP = (double)2 * this.TEMP1 * this.ROOT54;
                this.D5421 = this.TEMP * this.F542 * this.G521;
                this.D5433 = this.TEMP * this.F543 * this.G533;
                this.XLAMO = this.XMAO + (double)2 * elementSet.XNODEO - (double)2 * this.THGR;
                this.BFACT = d10 + d12 + d12 - this.THDT - this.THDT;
                this.BFACT = this.BFACT + this.SSL + this.SSH + this.SSH;
            } else {
                this.IRESFL = 1;
                this.ISYNFL = 1;
                this.G200 = 1.0 + d * (-2.5 + 0.8125 * d);
                this.G310 = 1.0 + (double)2 * d;
                this.G300 = 1.0 + d * (-6.0 + (double)6.60937f * d);
                this.F220 = 0.75 * (1.0 + d3) * (1.0 + d3);
                this.F311 = 0.9375 * d2 * d2 * (1.0 + (double)3 * d3) - 0.75 * (1.0 + d3);
                this.F330 = 1.0 + d3;
                this.F330 = 1.875 * this.F330 * this.F330 * this.F330;
                this.DEL1 = (double)3 * this.XNQ * this.XNQ * this.AQNV * this.AQNV;
                this.DEL2 = (double)2 * this.DEL1 * this.F220 * this.G200 * this.Q22;
                this.DEL3 = (double)3 * this.DEL1 * this.F330 * this.G300 * this.Q33 * this.AQNV;
                this.DEL1 = this.DEL1 * this.F311 * this.G310 * this.Q31 * this.AQNV;
                this.FASX2 = 0.13130907714366913;
                this.FASX4 = 2.88431978225708;
                this.FASX6 = 0.37448087334632874;
                this.XLAMO = this.XMAO + elementSet.XNODEO + elementSet.OMEGAO - this.THGR;
                this.BFACT = d10 + this.XPIDOT - this.THDT;
                this.BFACT = this.BFACT + this.SSL + this.SSG + this.SSH;
            }
            this.XFACT = this.BFACT - this.XNQ;
            this.XLI = this.XLAMO;
            this.XNI = this.XNQ;
            this.ATIME = 0.0;
            this.STEPP = 720.0;
            this.STEPN = -720.0;
            this.STEP2 = 259200.0;
        }

        public void DPSEC(ElementSet elementSet, DoubleRef doubleRef, DoubleRef doubleRef2, DoubleRef doubleRef3, DoubleRef doubleRef4, DoubleRef doubleRef5, DoubleRef doubleRef6, double d) {
            this.T = d;
            doubleRef.value += this.SSL * d;
            doubleRef2.value += this.SSG * d;
            doubleRef3.value += this.SSH * d;
            doubleRef4.value = elementSet.EO + this.SSE * d;
            doubleRef5.value = elementSet.XINCL + this.SSI * d;
            if (doubleRef5.value < 0.0) {
                doubleRef5.value = -doubleRef5.value;
                doubleRef3.value += 3.1415927410125732;
                doubleRef2.value -= 3.1415927410125732;
            }
            if (this.IRESFL == 0) {
                return;
            }
            while (true) {
                boolean bl = true;
                if (this.ATIME == 0.0 || d >= 0.0 && this.ATIME < 0.0 || d < 0.0 && this.ATIME >= 0.0) {
                    this.DELT = d < 0.0 ? this.STEPN : this.STEPP;
                    this.ATIME = 0.0;
                    this.XNI = this.XNQ;
                    this.XLI = this.XLAMO;
                } else if (Math.abs(d) < Math.abs(this.ATIME)) {
                    this.DELT = this.STEPP;
                    if (d >= 0.0) {
                        this.DELT = this.STEPN;
                    }
                    this.IRET = 100;
                    this.IRETN = 165;
                    bl = false;
                } else {
                    this.DELT = this.STEPN;
                    if (d > 0.0) {
                        this.DELT = this.STEPP;
                    }
                }
                do {
                    if (bl) {
                        if (Math.abs(d - this.ATIME) >= this.STEPP) {
                            this.IRET = 125;
                            this.IRETN = 165;
                        } else {
                            this.FT = d - this.ATIME;
                            this.IRETN = 140;
                        }
                    }
                    bl = true;
                    if (this.ISYNFL != 0) {
                        this.XNDOT = this.DEL1 * Math.sin(this.XLI - this.FASX2) + this.DEL2 * Math.sin((double)2 * (this.XLI - this.FASX4)) + this.DEL3 * Math.sin((double)3 * (this.XLI - this.FASX6));
                        this.XNDDT = this.DEL1 * Math.cos(this.XLI - this.FASX2) + (double)2 * this.DEL2 * Math.cos((double)2 * (this.XLI - this.FASX4)) + (double)3 * this.DEL3 * Math.cos((double)3 * (this.XLI - this.FASX6));
                    } else {
                        this.XOMI = this.OMEGAQ + this.OMGDT * this.ATIME;
                        this.X2OMI = this.XOMI + this.XOMI;
                        this.X2LI = this.XLI + this.XLI;
                        this.XNDOT = this.D2201 * Math.sin(this.X2OMI + this.XLI - this.G22) + this.D2211 * Math.sin(this.XLI - this.G22) + this.D3210 * Math.sin(this.XOMI + this.XLI - this.G32) + this.D3222 * Math.sin(-this.XOMI + this.XLI - this.G32) + this.D4410 * Math.sin(this.X2OMI + this.X2LI - this.G44) + this.D4422 * Math.sin(this.X2LI - this.G44) + this.D5220 * Math.sin(this.XOMI + this.XLI - this.G52) + this.D5232 * Math.sin(-this.XOMI + this.XLI - this.G52) + this.D5421 * Math.sin(this.XOMI + this.X2LI - this.G54) + this.D5433 * Math.sin(-this.XOMI + this.X2LI - this.G54);
                        this.XNDDT = this.D2201 * Math.cos(this.X2OMI + this.XLI - this.G22) + this.D2211 * Math.cos(this.XLI - this.G22) + this.D3210 * Math.cos(this.XOMI + this.XLI - this.G32) + this.D3222 * Math.cos(-this.XOMI + this.XLI - this.G32) + this.D5220 * Math.cos(this.XOMI + this.XLI - this.G52) + this.D5232 * Math.cos(-this.XOMI + this.XLI - this.G52) + (double)2 * (this.D4410 * Math.cos(this.X2OMI + this.X2LI - this.G44) + this.D4422 * Math.cos(this.X2LI - this.G44) + this.D5421 * Math.cos(this.XOMI + this.X2LI - this.G54) + this.D5433 * Math.cos(-this.XOMI + this.X2LI - this.G54));
                    }
                    this.XLDOT = this.XNI + this.XFACT;
                    this.XNDDT *= this.XLDOT;
                    if (this.IRETN == 140) {
                        doubleRef6.value = this.XNI + this.XNDOT * this.FT + this.XNDDT * this.FT * this.FT * 0.5;
                        this.XL = this.XLI + this.XLDOT * this.FT + this.XNDOT * this.FT * this.FT * 0.5;
                        this.TEMP = -doubleRef3.value + this.THGR + d * this.THDT;
                        doubleRef.value = this.XL - doubleRef2.value + this.TEMP;
                        if (this.ISYNFL == 0) {
                            doubleRef.value = this.XL + this.TEMP + this.TEMP;
                        }
                        return;
                    }
                    this.XLI = this.XLI + this.XLDOT * this.DELT + this.XNDOT * this.STEP2;
                    this.XNI = this.XNI + this.XNDOT * this.DELT + this.XNDDT * this.STEP2;
                    this.ATIME += this.DELT;
                } while (this.IRET != 100);
            }
        }

        public void DPPER(DoubleRef doubleRef, DoubleRef doubleRef2, DoubleRef doubleRef3, DoubleRef doubleRef4, DoubleRef doubleRef5) {
            this.SINIS = Math.sin(doubleRef2.value);
            this.COSIS = Math.cos(doubleRef2.value);
            if (Math.abs(this.SAVTSN - this.T) >= 30.0) {
                this.SAVTSN = this.T;
                this.ZM = this.ZMOS + this.ZNS * this.T;
                this.ZF = this.ZM + (double)2 * this.ZES * Math.sin(this.ZM);
                this.SINZF = Math.sin(this.ZF);
                this.F2 = 0.5 * this.SINZF * this.SINZF - 0.25;
                this.F3 = -0.5 * this.SINZF * Math.cos(this.ZF);
                this.SES = this.SE2 * this.F2 + this.SE3 * this.F3;
                this.SIS = this.SI2 * this.F2 + this.SI3 * this.F3;
                this.SLS = this.SL2 * this.F2 + this.SL3 * this.F3 + this.SL4 * this.SINZF;
                this.SGHS = this.SGH2 * this.F2 + this.SGH3 * this.F3 + this.SGH4 * this.SINZF;
                this.SHS = this.SH2 * this.F2 + this.SH3 * this.F3;
                this.ZM = this.ZMOL + this.ZNL * this.T;
                this.ZF = this.ZM + (double)2 * this.ZEL * Math.sin(this.ZM);
                this.SINZF = Math.sin(this.ZF);
                this.F2 = 0.5 * this.SINZF * this.SINZF - 0.25;
                this.F3 = -0.5 * this.SINZF * Math.cos(this.ZF);
                this.SEL = this.EE2 * this.F2 + this.E3 * this.F3;
                this.SIL = this.XI2 * this.F2 + this.XI3 * this.F3;
                this.SLL = this.XL2 * this.F2 + this.XL3 * this.F3 + this.XL4 * this.SINZF;
                this.SGHL = this.XGH2 * this.F2 + this.XGH3 * this.F3 + this.XGH4 * this.SINZF;
                this.SHL = this.XH2 * this.F2 + this.XH3 * this.F3;
                this.PE = this.SES + this.SEL;
                this.PINC = this.SIS + this.SIL;
                this.PL = this.SLS + this.SLL;
            }
            this.PGH = this.SGHS + this.SGHL;
            this.PH = this.SHS + this.SHL;
            doubleRef2.value += this.PINC;
            doubleRef.value += this.PE;
            if (this.XQNCL >= (double)0.2f) {
                this.PH /= this.SINIQ;
                this.PGH -= this.COSIQ * this.PH;
                doubleRef3.value += this.PGH;
                doubleRef4.value += this.PH;
                doubleRef5.value += this.PL;
            } else {
                this.SINOK = Math.sin(doubleRef4.value);
                this.COSOK = Math.cos(doubleRef4.value);
                this.ALFDP = this.SINIS * this.SINOK;
                this.BETDP = this.SINIS * this.COSOK;
                this.DALF = this.PH * this.COSOK + this.PINC * this.COSIS * this.SINOK;
                this.DBET = -this.PH * this.SINOK + this.PINC * this.COSIS * this.COSOK;
                this.ALFDP += this.DALF;
                this.BETDP += this.DBET;
                this.XLS = doubleRef5.value + doubleRef3.value + this.COSIS * doubleRef4.value;
                this.DLS = this.PL + this.PGH - this.PINC * doubleRef4.value * this.SINIS;
                this.XLS += this.DLS;
                doubleRef4.value = ephemeris.ACTAN(this.ALFDP, this.BETDP);
                doubleRef5.value += this.PL;
                doubleRef3.value = this.XLS - doubleRef5.value - Math.cos(doubleRef2.value) * doubleRef4.value;
            }
        }

        private final /* synthetic */ void this() {
            this.ZNS = 1.19459E-5f;
            this.C1SS = 2.986479785249685E-6;
            this.ZES = 0.01675f;
            this.ZNL = 1.5835218073334545E-4;
            this.C1L = 4.796806365447992E-7;
            this.ZEL = 0.0549f;
            this.ZCOSIS = 0.9174486994743347;
            this.ZSINIS = 0.39785414934158325;
            this.ZSINGS = -0.9808845520019531;
            this.ZCOSGS = 0.1945904940366745;
            this.ZCOSHS = 1.0;
            this.ZSINHS = 0.0;
            this.Q22 = 1.7891678680825862E-6;
            this.Q31 = 2.146074848496937E-6;
            this.Q33 = 2.2123015241959365E-7;
            this.G22 = 5.76863956451416;
            this.G32 = 0.9524089694023132;
            this.G44 = 1.801499843597412;
            this.G52 = 1.050832986831665;
            this.G54 = 4.410889625549316;
            this.ROOT22 = 1.7891678680825862E-6;
            this.ROOT32 = 3.7393792240436596E-7;
            this.ROOT44 = 7.363695431195083E-9;
            this.ROOT52 = 1.1428638657662304E-7;
            this.ROOT54 = 2.1765802493689534E-9;
            this.THDT = 0.004375269170850515;
        }

        public DEEP() {
            this.this();
        }
    }
}

