/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PApplet
extends Applet
implements PConstants,
Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    public static final String javaVersionName = System.getProperty("java.version").substring(0, 3);
    public static final float javaVersion = new Float(javaVersionName.substring(0, 3)).floatValue();
    public static int platform;
    public static String platformName;
    static final String NEW_RENDERER = "new renderer";
    static final boolean THREAD_DEBUG = false;
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 100;
    public static final int MIN_WINDOW_WIDTH = 128;
    public static final int MIN_WINDOW_HEIGHT = 128;
    public static final String LEECH_WAKEUP = "Error while running applet.";
    public static final String ARGS_EDITOR_LOCATION = "--editor-location";
    public static final String ARGS_EXTERNAL = "--external";
    public static final String ARGS_LOCATION = "--location";
    public static final String ARGS_DISPLAY = "--display";
    public static final String ARGS_BGCOLOR = "--bgcolor";
    public static final String ARGS_PRESENT = "--present";
    public static final String ARGS_STOP_COLOR = "--stop-color";
    public static final String ARGS_HIDE_STOP = "--hide-stop";
    public static final String ARGS_SKETCH_FOLDER = "--sketch-path";
    public static final char EXTERNAL_STOP = 's';
    public static final String EXTERNAL_QUIT = "__QUIT__";
    public static final String EXTERNAL_MOVE = "__MOVE__";
    static final boolean CRUSTY_THREADS = false;
    static final int PERLIN_YWRAPB = 4;
    static final int PERLIN_YWRAP = 16;
    static final int PERLIN_ZWRAPB = 8;
    static final int PERLIN_ZWRAP = 256;
    static final int PERLIN_SIZE = 4095;
    static final int BYTES = 1;
    static final int CHARS = 2;
    static final int INTS = 3;
    static final int FLOATS = 4;
    static final int STRINGS = 5;
    private static NumberFormat int_nf;
    private static int int_nf_digits;
    private static boolean int_nf_commas;
    private static NumberFormat float_nf;
    private static int float_nf_left;
    private static int float_nf_right;
    private static boolean float_nf_commas;
    public PGraphics g;
    public Frame frame;
    public Dimension screen;
    public PGraphics recorder;
    public String[] args;
    public String sketchPath;
    private Object blocker;
    public boolean defaultSize;
    public int[] pixels;
    public int width;
    public int height;
    public int mouseX;
    public int mouseY;
    public int pmouseX;
    public int pmouseY;
    protected int dmouseX;
    protected int dmouseY;
    protected int emouseX;
    protected int emouseY;
    public boolean firstMouse;
    public int mouseButton;
    public boolean mousePressed;
    public MouseEvent mouseEvent;
    public char key;
    public int keyCode;
    public boolean keyPressed;
    public KeyEvent keyEvent;
    public boolean focused;
    public boolean online;
    long millisOffset;
    public float frameRate;
    protected long frameRateLastMillis;
    protected long frameRateLastDelayTime;
    protected float frameRateTarget;
    protected boolean looping;
    protected boolean redraw;
    public int frameCount;
    public boolean finished;
    protected boolean exit;
    Thread thread;
    public Exception exception;
    protected RegisteredMethods sizeMethods;
    protected RegisteredMethods preMethods;
    protected RegisteredMethods drawMethods;
    protected RegisteredMethods postMethods;
    protected RegisteredMethods mouseEventMethods;
    protected RegisteredMethods keyEventMethods;
    protected RegisteredMethods disposeMethods;
    public PrintStream leechErr;
    protected boolean listenersAdded;
    MouseEvent[] mouseEventQueue;
    int mouseEventCount;
    KeyEvent[] keyEventQueue;
    int keyEventCount;
    int cursorType;
    boolean cursorVisible;
    PImage invisibleCursor;
    Random internalRandom;
    int perlin_octaves;
    float perlin_amp_falloff;
    int perlin_TWOPI;
    int perlin_PI;
    float[] perlin_cosTable;
    float[] perlin;
    Random perlinRandom;
    protected String[] loadImageFormats;
    int sort_mode;
    byte[] sort_bytes;
    char[] sort_chars;
    int[] sort_ints;
    float[] sort_floats;
    String[] sort_strings;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$event$MouseEvent;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;
    static /* synthetic */ Class class$processing$core$PApplet;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$awt$Point;
    static /* synthetic */ Class class$java$awt$Toolkit;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$awt$Font;

    public void init() {
        Dimension dimension = this.getSize();
        try {
            if (javaVersion >= 1.4f) {
                Class clazz = class$java$awt$Component;
                if (clazz == null) {
                    clazz = class$java$awt$Component = PApplet.class("[Ljava.awt.Component;", false);
                }
                Method method = clazz.getMethod("setFocusTraversalKeysEnabled", Boolean.TYPE);
                method.invoke((Object)this, Boolean.FALSE);
            }
        }
        catch (Exception exception) {}
        this.millisOffset = System.currentTimeMillis();
        this.finished = false;
        this.looping = true;
        this.redraw = true;
        this.firstMouse = true;
        this.sizeMethods = new RegisteredMethods();
        this.preMethods = new RegisteredMethods();
        this.drawMethods = new RegisteredMethods();
        this.postMethods = new RegisteredMethods();
        this.mouseEventMethods = new RegisteredMethods();
        this.keyEventMethods = new RegisteredMethods();
        this.disposeMethods = new RegisteredMethods();
        try {
            this.getAppletContext();
            this.online = true;
        }
        catch (NullPointerException nullPointerException) {
            this.online = false;
        }
        if (javaVersion < 1.3f) {
            this.addMouseListener(new MouseAdapter(){

                public final void mousePressed(MouseEvent mouseEvent) {
                    PApplet.this.link("http://java.com/");
                }
            });
            return;
        }
        try {
            if (this.sketchPath == null) {
                this.sketchPath = System.getProperty("user.dir");
            }
        }
        catch (Exception exception) {}
        if (dimension.width != 0 && dimension.height != 0) {
            this.size(dimension.width, dimension.height);
        } else {
            this.size(100, 100);
            this.defaultSize = true;
        }
        this.start();
    }

    public void start() {
        if (javaVersion < 1.3f) {
            return;
        }
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.finished = true;
        if (this.thread == null) {
            return;
        }
        this.thread = null;
        if (this.g != null) {
            this.g.dispose();
        }
        this.disposeMethods.handle();
    }

    public void destroy() {
        this.stop();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void registerSize(Object object) {
        Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
        this.registerWithArgs(this.preMethods, "size", object, classArray);
    }

    public void registerPre(Object object) {
        this.registerNoArgs(this.preMethods, "pre", object);
    }

    public void registerDraw(Object object) {
        this.registerNoArgs(this.drawMethods, "draw", object);
    }

    public void registerPost(Object object) {
        this.registerNoArgs(this.postMethods, "post", object);
    }

    public void registerMouseEvent(Object object) {
        Class[] classArray = new Class[1];
        Class clazz = class$java$awt$event$MouseEvent;
        if (clazz == null) {
            clazz = class$java$awt$event$MouseEvent = PApplet.class("[Ljava.awt.event.MouseEvent;", false);
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        this.registerWithArgs(this.mouseEventMethods, "mouseEvent", object, classArray2);
    }

    public void registerKeyEvent(Object object) {
        Class[] classArray = new Class[1];
        Class clazz = class$java$awt$event$KeyEvent;
        if (clazz == null) {
            clazz = class$java$awt$event$KeyEvent = PApplet.class("[Ljava.awt.event.KeyEvent;", false);
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        this.registerWithArgs(this.keyEventMethods, "keyEvent", object, classArray2);
    }

    public void registerDispose(Object object) {
        this.registerNoArgs(this.disposeMethods, "dispose", object);
    }

    protected void registerNoArgs(RegisteredMethods registeredMethods, String string, Object object) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            registeredMethods.add(object, method);
        }
        catch (Exception exception) {
            this.die("Could not register " + string + " + () for " + object, exception);
        }
    }

    protected void registerWithArgs(RegisteredMethods registeredMethods, String string, Object object, Class[] classArray) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, classArray);
            registeredMethods.add(object, method);
        }
        catch (Exception exception) {
            this.die("Could not register " + string + " + () for " + object, exception);
        }
    }

    public void setup() {
    }

    public void draw() {
        this.finished = true;
    }

    public void size(int n, int n2) {
        if (this.g != null) {
            this.size(n, n2, this.g.getClass().getName());
        } else {
            this.size(n, n2, "processing.core.PGraphicsJava2D");
        }
    }

    public void size(int n, int n2, String string) {
        this.size(n, n2, string, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void size(int n, int n2, String string, String string2) {
        String string3;
        String string4 = string3 = this.g == null ? null : this.g.getClass().getName();
        if (string2 != null) {
            string2 = this.savePath(string2);
        }
        if (string3 == null) {
            this.g = PApplet.createGraphics(n, n2, string, string2, this);
            this.updateSize(n, n2);
            return;
        }
        if (string3.equals(string)) {
            if (n == this.g.width) {
                if (n2 == this.g.height) return;
            }
            this.g.resize(n, n2);
            this.updateSize(n, n2);
            this.redraw();
            return;
        }
        if (this.frameCount > 0) {
            throw new RuntimeException("size() cannot be called to change the renderer outside of setup()");
        }
        this.g = PApplet.createGraphics(n, n2, string, string2, this);
        this.updateSize(n, n2);
        throw new RuntimeException(NEW_RENDERER);
    }

    protected void updateSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.defaultSize = false;
        this.setSize(this.width, this.height);
        Object[] objectArray = new Object[]{new Integer(this.width), new Integer(this.height)};
        this.sizeMethods.handle(objectArray);
    }

    public PGraphics createGraphics(int n, int n2, String string) {
        PGraphics pGraphics = PApplet.createGraphics(n, n2, string, null, null);
        pGraphics.parent = this;
        return pGraphics;
    }

    public PGraphics createGraphics(int n, int n2, String string, String string2) {
        if (string2 != null) {
            string2 = this.savePath(string2);
        }
        PGraphics pGraphics = PApplet.createGraphics(n, n2, string, string2, null);
        pGraphics.parent = this;
        return pGraphics;
    }

    protected static PGraphics createGraphics(int n, int n2, String string, String string2, PApplet pApplet) {
        String string3;
        if (string.equals("processing.opengl.PGraphicsOpenGL") && platform == 1 && (string3 = System.getProperty("java.version")) != null && string3.equals("1.5.0_10")) {
            System.err.println("OpenGL support is broken with Java 1.5.0_10");
            System.err.println("See http://dev.processing.org/bugs/show_bug.cgi?id=513 for more info.");
            throw new RuntimeException("Please update your Java installation (see bug #513)");
        }
        if (string.equals("processing.core.PGraphics2D")) {
            throw new RuntimeException("P2D is not yet implemented, use JAVA2D or P3D instead.");
        }
        string3 = "Before using OpenGL, first select Import Library > opengl from the Sketch menu.";
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = null;
            Object[] objectArray = null;
            if (string2 == null) {
                Class[] classArray2 = new Class[3];
                classArray2[0] = Integer.TYPE;
                classArray2[1] = Integer.TYPE;
                Class clazz2 = class$processing$core$PApplet;
                if (clazz2 == null) {
                    clazz2 = class$processing$core$PApplet = PApplet.class("[Lprocessing.core.PApplet;", false);
                }
                classArray2[2] = clazz2;
                classArray = classArray2;
                objectArray = new Object[]{new Integer(n), new Integer(n2), pApplet};
            } else {
                Class clazz3;
                Class[] classArray3 = new Class[4];
                classArray3[0] = Integer.TYPE;
                classArray3[1] = Integer.TYPE;
                Class clazz4 = class$processing$core$PApplet;
                if (clazz4 == null) {
                    clazz4 = classArray3[2] = (class$processing$core$PApplet = PApplet.class("[Lprocessing.core.PApplet;", false));
                }
                if ((clazz3 = class$java$lang$String) == null) {
                    clazz3 = class$java$lang$String = PApplet.class("[Ljava.lang.String;", false);
                }
                classArray3[3] = clazz3;
                classArray = classArray3;
                objectArray = new Object[]{new Integer(n), new Integer(n2), pApplet, string2};
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            PGraphics pGraphics = (PGraphics)constructor.newInstance(objectArray);
            return pGraphics;
        }
        catch (InvocationTargetException invocationTargetException) {
            String string4 = invocationTargetException.getTargetException().getMessage();
            if (string4 != null && string4.indexOf("no jogl in java.library.path") != -1) {
                throw new RuntimeException(string3);
            }
            invocationTargetException.getTargetException().printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            if (platform == 3) {
                throwable.printStackTrace(System.out);
            }
            throw new RuntimeException(throwable.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classNotFoundException.getMessage().indexOf("processing.opengl.PGraphicsGL") != -1) {
                throw new RuntimeException(string3);
            }
            throw new RuntimeException("You need to use \"Import Library\" to add " + string + " to your sketch.");
        }
        catch (Exception exception) {
            if (exception instanceof IllegalArgumentException || exception instanceof NoSuchMethodException || exception instanceof IllegalAccessException) {
                String string5 = "public " + string.substring(string.lastIndexOf(46) + 1) + "(int width, int height, PApplet parent" + (string2 == null ? "" : ", String filename") + ") does not exist.";
                throw new RuntimeException(string5);
            }
            if (platform == 3) {
                exception.printStackTrace(System.out);
            }
            throw new RuntimeException(exception.getMessage());
        }
    }

    public PImage createImage(int n, int n2, int n3) {
        PImage pImage = new PImage(n, n2, n3);
        pImage.parent = this;
        return pImage;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (javaVersion < 1.3f) {
            graphics.setColor(new Color(64, 64, 64));
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.white);
            graphics.setFont(new Font("Dialog", 0, 9));
            graphics.drawString("You need to install", 3, 15);
            graphics.drawString("Java 1.3 or later", 3, 28);
            graphics.drawString("to view this content.", 3, 41);
            graphics.drawString("Click here to visit", 3, 59);
            graphics.drawString("java.com and install.", 3, 72);
            return;
        }
        if (this.frameCount == 0) {
            return;
        }
        if (this.g != null && this.g.image != null) {
            graphics.drawImage(this.g.image, 0, 0, null);
        }
    }

    public synchronized void handleDisplay() {
        if (this.looping || this.redraw) {
            this.g.beginDraw();
            if (this.frameCount == 0) {
                try {
                    this.setup();
                }
                catch (RuntimeException runtimeException) {
                    String string = runtimeException.getMessage();
                    if (string != null && runtimeException.getMessage().indexOf(NEW_RENDERER) != -1) {
                        return;
                    }
                    throw runtimeException;
                }
                this.width = this.g.width;
                this.height = this.g.height;
                this.defaultSize = false;
            } else {
                float f;
                if (this.frameRateLastMillis != 0L && (f = (float)(System.currentTimeMillis() - this.frameRateLastMillis)) != 0.0f) {
                    this.frameRate = this.frameRate * 0.9f + 1.0f / (f / 1000.0f) * 0.1f;
                }
                this.frameRateLastMillis = System.currentTimeMillis();
                this.preMethods.handle();
                this.pmouseX = this.dmouseX;
                this.pmouseY = this.dmouseY;
                this.draw();
                this.dmouseX = this.mouseX;
                this.dmouseY = this.mouseY;
                this.dequeueMouseEvents();
                this.dequeueKeyEvents();
                this.drawMethods.handle();
                this.redraw = false;
            }
            this.g.endDraw();
            ++this.frameCount;
            this.repaint();
            this.getToolkit().sync();
            this.postMethods.handle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (Thread.currentThread() == this.thread && !this.finished) {
                this.g.requestDisplay(this);
                try {
                    int n;
                    int n2 = n = this.looping || this.finished ? 1 : 10000;
                    if (this.frameCount == 1) {
                        n = 1;
                    } else if (this.finished) {
                        n = 0;
                    } else if (this.looping) {
                        if (this.frameRateTarget != 0.0f) {
                            long l;
                            long l2;
                            this.frameRateLastDelayTime = this.frameRateLastDelayTime == 0L ? System.currentTimeMillis() : ((n = (int)((l2 = this.frameRateLastDelayTime + (long)(1000.0f / this.frameRateTarget)) - (l = System.currentTimeMillis()))) > 0 ? l2 : l);
                        } else {
                            n = 1;
                        }
                    }
                    Object object = this.blocker;
                    synchronized (object) {
                        if (n > 0) {
                            this.blocker.wait(n);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            Exception exception2;
            this.finished = true;
            if (exception instanceof InvocationTargetException) {
                exception2 = (Exception)((InvocationTargetException)exception).getTargetException();
            }
            this.exception = exception2;
            if (this.leechErr != null) {
                this.leechErr.println(LEECH_WAKEUP);
                exception2.printStackTrace(this.leechErr);
                exception2.printStackTrace(System.out);
            }
            System.err.println(LEECH_WAKEUP);
            exception2.printStackTrace();
            exception2.printStackTrace(System.out);
        }
        this.stop();
        if (this.exit && this.leechErr == null && !this.online) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void redraw() {
        if (this.looping) return;
        this.redraw = true;
        if (this.thread == null) return;
        Object object = this.blocker;
        synchronized (object) {
            this.blocker.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void loop() {
        if (this.looping) return;
        this.looping = true;
        if (this.thread == null) return;
        Object object = this.blocker;
        synchronized (object) {
            this.blocker.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void noLoop() {
        if (!this.looping) return;
        this.looping = false;
        this.frameRateLastDelayTime = 0L;
        this.frameRateLastMillis = 0L;
        if (this.thread == null) return;
        Object object = this.blocker;
        synchronized (object) {
            this.blocker.notifyAll();
            return;
        }
    }

    public void addListeners() {
        if (!this.listenersAdded) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(this);
            this.addFocusListener(this);
            this.addComponentListener(new ComponentAdapter(){

                public final void componentResized(ComponentEvent componentEvent) {
                    Component component = componentEvent.getComponent();
                    Rectangle rectangle = component.getBounds();
                    PApplet.this.size(rectangle.width, rectangle.height);
                }
            });
            this.listenersAdded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void enqueueMouseEvent(MouseEvent mouseEvent) {
        MouseEvent[] mouseEventArray = this.mouseEventQueue;
        synchronized (this.mouseEventQueue) {
            if (this.mouseEventCount == this.mouseEventQueue.length) {
                MouseEvent[] mouseEventArray2 = new MouseEvent[this.mouseEventCount << 1];
                System.arraycopy(this.mouseEventQueue, 0, mouseEventArray2, 0, this.mouseEventCount);
                this.mouseEventQueue = mouseEventArray2;
            }
            this.mouseEventQueue[this.mouseEventCount++] = mouseEvent;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dequeueMouseEvents() {
        MouseEvent[] mouseEventArray = this.mouseEventQueue;
        synchronized (this.mouseEventQueue) {
            int n = 0;
            while (true) {
                if (n >= this.mouseEventCount) {
                    this.mouseEventCount = 0;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.mouseEvent = this.mouseEventQueue[n];
                this.handleMouseEvent(this.mouseEvent);
                ++n;
            }
        }
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 506 || n == 503) {
            this.pmouseX = this.emouseX;
            this.pmouseY = this.emouseY;
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
        }
        this.mouseEvent = mouseEvent;
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 0x10) != 0) {
            this.mouseButton = 37;
        } else if ((n2 & 8) != 0) {
            this.mouseButton = 3;
        } else if ((n2 & 4) != 0) {
            this.mouseButton = 39;
        }
        if ((platform == 3 || platform == 2) && this.mouseEvent.isPopupTrigger()) {
            this.mouseButton = 39;
        }
        this.mouseEventMethods.handle(new Object[]{mouseEvent});
        if (this.firstMouse) {
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this.dmouseX = this.mouseX;
            this.dmouseY = this.mouseY;
            this.firstMouse = false;
        }
        switch (n) {
            case 501: {
                this.mousePressed = true;
                this.mousePressed();
                break;
            }
            case 502: {
                this.mousePressed = false;
                this.mouseReleased();
                break;
            }
            case 500: {
                this.mouseClicked();
                break;
            }
            case 506: {
                this.mouseDragged();
                break;
            }
            case 503: {
                this.mouseMoved();
                break;
            }
        }
        if (n == 506 || n == 503) {
            this.emouseX = this.mouseX;
            this.emouseY = this.mouseY;
        }
    }

    protected void checkMouseEvent(MouseEvent mouseEvent) {
        if (this.looping) {
            this.enqueueMouseEvent(mouseEvent);
        } else {
            this.handleMouseEvent(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    public void mousePressed() {
    }

    public void mouseReleased() {
    }

    public void mouseClicked() {
    }

    public void mouseDragged() {
    }

    public void mouseMoved() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void enqueueKeyEvent(KeyEvent keyEvent) {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            if (this.keyEventCount == this.keyEventQueue.length) {
                KeyEvent[] keyEventArray2 = new KeyEvent[this.keyEventCount << 1];
                System.arraycopy(this.keyEventQueue, 0, keyEventArray2, 0, this.keyEventCount);
                this.keyEventQueue = keyEventArray2;
            }
            this.keyEventQueue[this.keyEventCount++] = keyEvent;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dequeueKeyEvents() {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            int n = 0;
            while (true) {
                if (n >= this.keyEventCount) {
                    this.keyEventCount = 0;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.keyEvent = this.keyEventQueue[n];
                this.handleKeyEvent(this.keyEvent);
                ++n;
            }
        }
    }

    protected void handleKeyEvent(KeyEvent keyEvent) {
        this.keyEvent = keyEvent;
        this.key = keyEvent.getKeyChar();
        this.keyCode = keyEvent.getKeyCode();
        this.keyEventMethods.handle(new Object[]{keyEvent});
        switch (keyEvent.getID()) {
            case 401: {
                this.keyPressed = true;
                this.keyPressed();
                break;
            }
            case 402: {
                this.keyPressed = false;
                this.keyReleased();
                break;
            }
            case 400: {
                this.keyTyped();
                break;
            }
        }
        if (keyEvent.getID() == 401 && this.key == '\u001b') {
            this.exit();
        }
    }

    protected void checkKeyEvent(KeyEvent keyEvent) {
        if (this.looping) {
            this.enqueueKeyEvent(keyEvent);
        } else {
            this.handleKeyEvent(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.checkKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.checkKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.checkKeyEvent(keyEvent);
    }

    public void keyPressed() {
    }

    public void keyReleased() {
    }

    public void keyTyped() {
    }

    public void focusGained() {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focused = true;
        this.focusGained();
    }

    public void focusLost() {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focused = false;
        this.focusLost();
    }

    public int millis() {
        return (int)(System.currentTimeMillis() - this.millisOffset);
    }

    public static int second() {
        return Calendar.getInstance().get(13);
    }

    public static int minute() {
        return Calendar.getInstance().get(12);
    }

    public static int hour() {
        return Calendar.getInstance().get(11);
    }

    public static int day() {
        return Calendar.getInstance().get(5);
    }

    public static int month() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int year() {
        return Calendar.getInstance().get(1);
    }

    public void delay(int n) {
        if (this.frameCount == 0) {
            return;
        }
        if (n > 0) {
            try {
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void frameRate(float f) {
        this.frameRateTarget = f;
    }

    public String param(String string) {
        if (this.online) {
            return this.getParameter(string);
        }
        System.err.println("param() only works inside a web browser");
        return null;
    }

    public void status(String string) {
        if (this.online) {
            this.showStatus(string);
        } else {
            System.out.println(string);
        }
    }

    public void link(String string) {
        this.link(string, null);
    }

    public void link(String string, String string2) {
        block12: {
            if (this.online) {
                try {
                    if (string2 == null) {
                        this.getAppletContext().showDocument(new URL(string));
                    }
                    this.getAppletContext().showDocument(new URL(string), string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new RuntimeException("Could not open " + string);
                }
            } else {
                try {
                    if (platform == 1) {
                        string = string.replaceAll("&", "^&");
                        Runtime.getRuntime().exec("cmd /c start " + string);
                        break block12;
                    }
                    if (platform == 3 || platform == 2) {
                        try {
                            Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                            Class[] classArray = new Class[1];
                            Class clazz2 = class$java$lang$String;
                            if (clazz2 == null) {
                                clazz2 = class$java$lang$String = PApplet.class("[Ljava.lang.String;", false);
                            }
                            classArray[0] = clazz2;
                            Method method = clazz.getMethod("openURL", classArray);
                            method.invoke(null, string);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break block12;
                    }
                    throw new RuntimeException("Can't open URLs for this platform");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException("Could not open " + string);
                }
            }
        }
    }

    public void open(String string) {
        if (platform == 1) {
            try {
                Runtime.getRuntime().exec("cmd /c \"" + string + '\"');
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException("Could not open " + string);
            }
        } else if (platform == 3) {
            try {
                if (string.indexOf(32) != -1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = string.toCharArray();
                    int n = 0;
                    while (n < cArray.length) {
                        if (cArray[n] == ' ') {
                            stringBuffer.append("\\\\ ");
                        } else {
                            stringBuffer.append(cArray[n]);
                        }
                        ++n;
                    }
                    string = stringBuffer.toString();
                }
                Runtime.getRuntime().exec("open " + string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException("Could not open " + string);
            }
        } else if (platform == 2) {
            String string2 = "file://" + string;
            if (string2.indexOf(32) != -1) {
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = string2.toCharArray();
                int n = 0;
                while (n < cArray.length) {
                    if (cArray[n] == ' ') {
                        stringBuffer.append("%20");
                    } else {
                        stringBuffer.append(cArray[n]);
                    }
                    ++n;
                }
                string2 = stringBuffer.toString();
            }
            this.link(string2);
        } else {
            this.open(new String[]{string});
        }
    }

    public Process open(String[] stringArray) {
        try {
            return Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Could not open " + PApplet.join(stringArray, ' '));
        }
    }

    public void die(String string) {
        this.stop();
        throw new RuntimeException(string);
    }

    public void die(String string, Exception exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
        this.die(string);
    }

    public void exit() {
        if (this.thread == null) {
            if (this.leechErr == null && !this.online) {
                System.exit(0);
            }
        } else {
            this.finished = true;
            this.exit = true;
        }
    }

    public void save(String string) {
        this.g.save(this.savePath(string));
    }

    public void saveFrame() {
        if (this.online) {
            System.err.println("Can't use saveFrame() when running in a browser.");
            return;
        }
        this.g.save(this.savePath("screen-" + PApplet.nf(this.frameCount, 4) + ".tif"));
    }

    public void saveFrame(String string) {
        if (this.online) {
            System.err.println("Can't use saveFrame() when running in a browser.");
            return;
        }
        this.g.save(this.savePath(this.insertFrame(string)));
    }

    public void cursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
        this.cursorVisible = true;
        this.cursorType = n;
    }

    public void cursor(PImage pImage, int n, int n2) {
        if (javaVersion < 1.2f) {
            System.err.println("Java 1.2 or higher is required to use cursor()");
            System.err.println("(You're using version " + javaVersionName + ')');
            return;
        }
        Image image = this.createImage(new MemoryImageSource(pImage.width, pImage.height, pImage.pixels, 0, pImage.width));
        Point point = new Point(n, n2);
        try {
            Class clazz;
            Class clazz2;
            Class clazz3 = class$java$awt$Toolkit;
            if (clazz3 == null) {
                clazz3 = class$java$awt$Toolkit = PApplet.class("[Ljava.awt.Toolkit;", false);
            }
            Class[] classArray = new Class[3];
            Class clazz4 = class$java$awt$Image;
            if (clazz4 == null) {
                clazz4 = classArray[0] = (class$java$awt$Image = PApplet.class("[Ljava.awt.Image;", false));
            }
            if ((clazz2 = class$java$awt$Point) == null) {
                clazz2 = classArray[1] = (class$java$awt$Point = PApplet.class("[Ljava.awt.Point;", false));
            }
            if ((clazz = class$java$lang$String) == null) {
                clazz = class$java$lang$String = PApplet.class("[Ljava.lang.String;", false);
            }
            classArray[2] = clazz;
            Method method = clazz3.getMethod("createCustomCursor", classArray);
            Cursor cursor = (Cursor)method.invoke((Object)Toolkit.getDefaultToolkit(), image, point, "no cursor");
            this.setCursor(cursor);
            this.cursorVisible = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            System.err.println("cursor() is not available when using Java " + javaVersionName);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("cursor() error: the hotspot " + point + " is out of bounds for the given image.");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void cursor() {
        if (!this.cursorVisible) {
            this.cursorVisible = true;
            this.setCursor(Cursor.getPredefinedCursor(this.cursorType));
        }
    }

    public void noCursor() {
        if (!this.cursorVisible) {
            return;
        }
        if (this.invisibleCursor == null) {
            this.invisibleCursor = new PImage(16, 16, 2);
        }
        this.cursor(this.invisibleCursor, 0, 0);
        this.cursorVisible = false;
    }

    public static void print(byte by) {
        System.out.print(by);
        System.out.flush();
    }

    public static void print(boolean bl) {
        System.out.print(bl);
        System.out.flush();
    }

    public static void print(char c) {
        System.out.print(c);
        System.out.flush();
    }

    public static void print(int n) {
        System.out.print(n);
        System.out.flush();
    }

    public static void print(float f) {
        System.out.print(f);
        System.out.flush();
    }

    public static void print(double d) {
        System.out.print(d);
        System.out.flush();
    }

    public static void print(String string) {
        System.out.print(string);
        System.out.flush();
    }

    public static void print(Object object) {
        block18: {
            block19: {
                block17: {
                    if (object != null) break block17;
                    System.out.print("null");
                    break block18;
                }
                String string = object.getClass().getName();
                if (string.charAt(0) != '[') break block19;
                switch (string.charAt(1)) {
                    case '[': {
                        System.out.print(object);
                        System.out.print(' ');
                        break;
                    }
                    case 'L': {
                        Object[] objectArray = (Object[])object;
                        int n = 0;
                        while (n < objectArray.length) {
                            System.out.print(objectArray[n]);
                            System.out.print(' ');
                            ++n;
                        }
                        break block18;
                    }
                    case 'Z': {
                        boolean[] blArray = (boolean[])object;
                        int n = 0;
                        while (n < blArray.length) {
                            System.out.print(blArray[n]);
                            System.out.print(' ');
                            ++n;
                        }
                        break block18;
                    }
                    case 'B': {
                        byte[] byArray = (byte[])object;
                        int n = 0;
                        while (n < byArray.length) {
                            System.out.print(byArray[n]);
                            System.out.print(' ');
                            ++n;
                        }
                        break block18;
                    }
                    case 'C': {
                        char[] cArray = (char[])object;
                        int n = 0;
                        while (n < cArray.length) {
                            System.out.print(cArray[n]);
                            System.out.print(' ');
                            ++n;
                        }
                        break block18;
                    }
                    case 'I': {
                        int[] nArray = (int[])object;
                        int n = 0;
                        while (n < nArray.length) {
                            System.out.print(nArray[n]);
                            System.out.print(' ');
                            ++n;
                        }
                        break block18;
                    }
                    case 'F': {
                        float[] fArray = (float[])object;
                        int n = 0;
                        while (n < fArray.length) {
                            System.out.print(fArray[n]);
                            System.out.print(' ');
                            ++n;
                        }
                        break block18;
                    }
                    case 'D': {
                        double[] dArray = (double[])object;
                        int n = 0;
                        while (n < dArray.length) {
                            System.out.print(dArray[n]);
                            System.out.print(' ');
                            ++n;
                        }
                        break block18;
                    }
                    default: {
                        System.out.print(object);
                    }
                }
                break block18;
            }
            System.out.print(object);
        }
    }

    public static void println() {
        System.out.println();
    }

    public static void println(byte by) {
        PApplet.print(by);
        System.out.println();
    }

    public static void println(boolean bl) {
        PApplet.print(bl);
        System.out.println();
    }

    public static void println(char c) {
        PApplet.print(c);
        System.out.println();
    }

    public static void println(int n) {
        PApplet.print(n);
        System.out.println();
    }

    public static void println(float f) {
        PApplet.print(f);
        System.out.println();
    }

    public static void println(double d) {
        PApplet.print(d);
        System.out.println();
    }

    public static void println(String string) {
        PApplet.print(string);
        System.out.println();
    }

    public static void println(Object object) {
        block18: {
            block19: {
                block17: {
                    if (object != null) break block17;
                    System.out.println("null");
                    break block18;
                }
                String string = object.getClass().getName();
                if (string.charAt(0) != '[') break block19;
                switch (string.charAt(1)) {
                    case '[': {
                        System.out.println(object);
                        break;
                    }
                    case 'L': {
                        Object[] objectArray = (Object[])object;
                        int n = 0;
                        while (n < objectArray.length) {
                            System.out.println(objectArray[n]);
                            ++n;
                        }
                        break block18;
                    }
                    case 'Z': {
                        boolean[] blArray = (boolean[])object;
                        int n = 0;
                        while (n < blArray.length) {
                            System.out.println(blArray[n]);
                            ++n;
                        }
                        break block18;
                    }
                    case 'B': {
                        byte[] byArray = (byte[])object;
                        int n = 0;
                        while (n < byArray.length) {
                            System.out.println(byArray[n]);
                            ++n;
                        }
                        break block18;
                    }
                    case 'C': {
                        char[] cArray = (char[])object;
                        int n = 0;
                        while (n < cArray.length) {
                            System.out.println(cArray[n]);
                            ++n;
                        }
                        break block18;
                    }
                    case 'I': {
                        int[] nArray = (int[])object;
                        int n = 0;
                        while (n < nArray.length) {
                            System.out.println(nArray[n]);
                            ++n;
                        }
                        break block18;
                    }
                    case 'F': {
                        float[] fArray = (float[])object;
                        int n = 0;
                        while (n < fArray.length) {
                            System.out.println(fArray[n]);
                            ++n;
                        }
                        break block18;
                    }
                    case 'D': {
                        double[] dArray = (double[])object;
                        int n = 0;
                        while (n < dArray.length) {
                            System.out.println(dArray[n]);
                            ++n;
                        }
                        break block18;
                    }
                    default: {
                        System.out.println(object);
                    }
                }
                break block18;
            }
            System.out.println(object);
        }
    }

    public static final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final float sq(float f) {
        return f * f;
    }

    public static final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static final float log(float f) {
        return (float)Math.log(f);
    }

    public static final float exp(float f) {
        return (float)Math.exp(f);
    }

    public static final float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public static final float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static final float max(float f, float f2, float f3) {
        return f > f2 ? (f > f3 ? f : f3) : (f2 > f3 ? f2 : f3);
    }

    public static final float min(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static final float min(float f, float f2, float f3) {
        return f < f2 ? (f < f3 ? f : f3) : (f2 < f3 ? f2 : f3);
    }

    public static final float lerp(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public static final float norm(float f, float f2, float f3) {
        return (f - f2) / (f3 - f2);
    }

    public static final float map(float f, float f2, float f3, float f4, float f5) {
        return f4 + (f5 - f4) * ((f - f2) / (f3 - f2));
    }

    public static final float constrain(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final int max(int n, int n2, int n3) {
        return n > n2 ? (n > n3 ? n : n3) : (n2 > n3 ? n2 : n3);
    }

    public static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final int min(int n, int n2, int n3) {
        return n < n2 ? (n < n3 ? n : n3) : (n2 < n3 ? n2 : n3);
    }

    public static final int constrain(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public final float sin(float f) {
        return (float)Math.sin(f);
    }

    public final float cos(float f) {
        return (float)Math.cos(f);
    }

    public final float tan(float f) {
        return (float)Math.tan(f);
    }

    public final float asin(float f) {
        return (float)Math.asin(f);
    }

    public final float acos(float f) {
        return (float)Math.acos(f);
    }

    public final float atan(float f) {
        return (float)Math.atan(f);
    }

    public final float atan2(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    public static final float degrees(float f) {
        return f * 57.295776f;
    }

    public static final float radians(float f) {
        return f * ((float)Math.PI / 180);
    }

    public static final int ceil(float f) {
        return (int)Math.ceil(f);
    }

    public static final int floor(float f) {
        return (int)Math.floor(f);
    }

    public static final int round(float f) {
        return Math.round(f);
    }

    public static final float mag(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static final float mag(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static final float dist(float f, float f2, float f3, float f4) {
        return PApplet.sqrt(PApplet.sq(f3 - f) + PApplet.sq(f4 - f2));
    }

    public static final float dist(float f, float f2, float f3, float f4, float f5, float f6) {
        return PApplet.sqrt(PApplet.sq(f4 - f) + PApplet.sq(f5 - f2) + PApplet.sq(f6 - f3));
    }

    public final float random(float f) {
        if (f == 0.0f) {
            return 0.0f;
        }
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        float f2 = 0.0f;
        while ((f2 = this.internalRandom.nextFloat() * f) == f) {
        }
        return f2;
    }

    public final float random(float f, float f2) {
        if (f >= f2) {
            return f;
        }
        float f3 = f2 - f;
        return this.random(f3) + f;
    }

    public final void randomSeed(long l) {
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        this.internalRandom.setSeed(l);
    }

    public float noise(float f) {
        return this.noise(f, 0.0f, 0.0f);
    }

    public float noise(float f, float f2) {
        return this.noise(f, f2, 0.0f);
    }

    public float noise(float f, float f2, float f3) {
        int n;
        if (this.perlin == null) {
            if (this.perlinRandom == null) {
                this.perlinRandom = new Random();
            }
            this.perlin = new float[4096];
            n = 0;
            while (n < 4096) {
                this.perlin[n] = this.perlinRandom.nextFloat();
                ++n;
            }
            this.perlin_cosTable = PGraphics.cosLUT;
            this.perlin_PI = 720;
            this.perlin_TWOPI = 720;
            this.perlin_PI >>= 1;
        }
        if (f < 0.0f) {
            f = -f;
        }
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        n = (int)f;
        int n2 = (int)f2;
        int n3 = (int)f3;
        float f4 = f - (float)n;
        float f5 = f2 - (float)n2;
        float f6 = f3 - (float)n3;
        float f7 = 0.0f;
        float f8 = 0.5f;
        int n4 = 0;
        while (n4 < this.perlin_octaves) {
            int n5 = n + (n2 << 4) + (n3 << 8);
            float f9 = this.noise_fsc(f4);
            float f10 = this.noise_fsc(f5);
            float f11 = this.perlin[n5 & 0xFFF];
            f11 += f9 * (this.perlin[n5 + 1 & 0xFFF] - f11);
            float f12 = this.perlin[n5 + 16 & 0xFFF];
            f12 += f9 * (this.perlin[n5 + 16 + 1 & 0xFFF] - f12);
            f11 += f10 * (f12 - f11);
            f12 = this.perlin[(n5 += 256) & 0xFFF];
            f12 += f9 * (this.perlin[n5 + 1 & 0xFFF] - f12);
            float f13 = this.perlin[n5 + 16 & 0xFFF];
            f13 += f9 * (this.perlin[n5 + 16 + 1 & 0xFFF] - f13);
            f12 += f10 * (f13 - f12);
            f11 += this.noise_fsc(f6) * (f12 - f11);
            f7 += f11 * f8;
            f8 *= this.perlin_amp_falloff;
            n <<= 1;
            f4 *= 2.0f;
            n2 <<= 1;
            f5 *= 2.0f;
            n3 <<= 1;
            f6 *= 2.0f;
            if (f4 >= 1.0f) {
                ++n;
                f4 -= 1.0f;
            }
            if (f5 >= 1.0f) {
                ++n2;
                f5 -= 1.0f;
            }
            if (f6 >= 1.0f) {
                ++n3;
                f6 -= 1.0f;
            }
            ++n4;
        }
        return f7;
    }

    private final float noise_fsc(float f) {
        return 0.5f * (1.0f - this.perlin_cosTable[(int)(f * (float)this.perlin_PI) % this.perlin_TWOPI]);
    }

    public void noiseDetail(int n) {
        if (n > 0) {
            this.perlin_octaves = n;
        }
    }

    public void noiseDetail(int n, float f) {
        if (n > 0) {
            this.perlin_octaves = n;
        }
        if (f > 0.0f) {
            this.perlin_amp_falloff = f;
        }
    }

    public void noiseSeed(long l) {
        if (this.perlinRandom == null) {
            this.perlinRandom = new Random();
        }
        this.perlinRandom.setSeed(l);
        this.perlin = null;
    }

    public PImage loadImage(String string) {
        String string2 = string.toLowerCase();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return this.loadImage(string, "unknown");
        }
        String string3 = string2.substring(n + 1);
        int n2 = string3.indexOf(63);
        if (n2 != -1) {
            string3 = string3.substring(0, n2);
        }
        return this.loadImage(string, string3);
    }

    public PImage loadImage(String string, String string2) {
        if ((string2 = string2.toLowerCase()).equals("tga")) {
            try {
                return this.loadImageTGA(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        if (string2.equals("tif") || string2.equals("tiff")) {
            byte[] byArray = this.loadBytes(string);
            return byArray == null ? null : PImage.loadTIFF(byArray);
        }
        if (string2.equals("png") && javaVersion < 1.3f) {
            System.err.println("PNG images can only be loaded when using Java 1.3 and later.");
            return null;
        }
        try {
            if (string2.equals("jpg") || string2.equals("jpeg") || string2.equals("gif") || string2.equals("png") || string2.equals("unknown")) {
                byte[] byArray = this.loadBytes(string);
                if (byArray == null) {
                    return null;
                }
                Image image = Toolkit.getDefaultToolkit().createImage(byArray);
                PImage pImage = this.loadImageSync(image);
                if (string2.equals("gif") || string2.equals("png")) {
                    pImage.checkAlpha();
                }
                return pImage;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (javaVersion >= 1.4f) {
            if (this.loadImageFormats == null) {
                try {
                    Class<?> clazz = Class.forName("javax.imageio.ImageIO");
                    Method method = clazz.getMethod("getReaderFormatNames", null);
                    this.loadImageFormats = (String[])method.invoke(null, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.loadImageFormats != null) {
                int n = 0;
                while (n < this.loadImageFormats.length) {
                    if (string2.equals(this.loadImageFormats[n])) {
                        return this.loadImageIO(string);
                    }
                    ++n;
                }
            }
        }
        System.err.println("Could not find a method to load " + string);
        return null;
    }

    public PImage loadImageSync(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        PImage pImage = new PImage(image);
        pImage.parent = this;
        return pImage;
    }

    protected PImage loadImageIO(String string) {
        InputStream inputStream = this.openStream(string);
        if (inputStream == null) {
            System.err.println("The image " + string + " could not be found.");
            return null;
        }
        try {
            Class<?> clazz = Class.forName("javax.imageio.ImageIO");
            Class[] classArray = new Class[1];
            Class clazz2 = class$java$io$InputStream;
            if (clazz2 == null) {
                clazz2 = class$java$io$InputStream = PApplet.class("[Ljava.io.InputStream;", false);
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("read", classArray);
            Object object = method.invoke(null, inputStream);
            Class<?> clazz3 = Class.forName("java.awt.image.BufferedImage");
            Method method2 = clazz3.getMethod("getHeight", null);
            Integer n = (Integer)method2.invoke(object, null);
            Method method3 = clazz3.getMethod("getWidth", null);
            Integer n2 = (Integer)method3.invoke(object, null);
            PImage pImage = new PImage(n2, n);
            pImage.parent = this;
            Method method4 = clazz3.getMethod("getRGB", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, pImage.pixels.getClass(), Integer.TYPE, Integer.TYPE);
            method4.invoke(object, new Integer(0), new Integer(0), new Integer(pImage.width), new Integer(pImage.height), pImage.pixels, new Integer(0), new Integer(pImage.width));
            pImage.checkAlpha();
            return pImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected PImage loadImageTGA(String string) throws IOException {
        int n;
        InputStream inputStream = this.openStream(string);
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = new byte[18];
        int n2 = 0;
        do {
            if ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) continue;
            return null;
        } while ((n2 += n) < 18);
        n = 0;
        if (byArray[2] == 11 && byArray[16] == 8 && byArray[17] == 40) {
            n = 4;
        } else if (byArray[2] == 10 && byArray[16] == 24 && byArray[17] == 32) {
            n = 1;
        } else if (byArray[2] == 10 && byArray[16] == 32 && byArray[17] == 40) {
            n = 2;
        }
        if (n == 0) {
            System.err.println("Unknown .tga file format for " + string);
            return null;
        }
        int n3 = ((byArray[13] & 0xFF) << 8) + (byArray[12] & 0xFF);
        int n4 = ((byArray[15] & 0xFF) << 8) + (byArray[14] & 0xFF);
        PImage pImage = new PImage(n3, n4, n);
        pImage.parent = this;
        int n5 = 0;
        int[] nArray = pImage.pixels;
        block11: while (n5 < nArray.length) {
            int n6;
            boolean bl;
            int n7 = inputStream.read();
            boolean bl2 = false;
            if ((n7 & 0x80) != 0) {
                bl2 = true;
            }
            if (bl = bl2) {
                n7 -= 127;
                n6 = 0;
                switch (n) {
                    case 4: {
                        n6 = inputStream.read();
                        break;
                    }
                    case 1: {
                        n6 = 0xFF000000 | inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16;
                        break;
                    }
                    case 2: {
                        n6 = inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
                        break;
                    }
                }
                int n8 = 0;
                while (n8 < n7) {
                    nArray[n5++] = n6;
                    if (n5 == nArray.length) continue block11;
                    ++n8;
                }
                continue;
            }
            ++n7;
            switch (n) {
                case 4: {
                    n6 = 0;
                    while (n6 < n7) {
                        nArray[n5++] = inputStream.read();
                        ++n6;
                    }
                    continue block11;
                }
                case 1: {
                    n6 = 0;
                    while (n6 < n7) {
                        nArray[n5++] = 0xFF000000 | inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16;
                        ++n6;
                    }
                    continue block11;
                }
                case 2: {
                    n6 = 0;
                    while (n6 < n7) {
                        nArray[n5++] = inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
                        ++n6;
                    }
                    continue block11;
                }
            }
        }
        return pImage;
    }

    public PFont loadFont(String string) {
        try {
            String string2 = string.toLowerCase();
            InputStream inputStream = this.openStream(string);
            if (string2.endsWith(".vlw.gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (!string2.endsWith(".vlw")) {
                throw new IOException("I don't know how to load a font named " + string);
            }
            return new PFont(inputStream);
        }
        catch (Exception exception) {
            this.die("Could not load font " + string + ". Make sure that the font has been copied to the data folder of your sketch.", exception);
            return null;
        }
    }

    public PFont createFont(String string, float f) {
        return this.createFont(string, f, true, PFont.DEFAULT_CHARSET);
    }

    public PFont createFont(String string, float f, boolean bl) {
        return this.createFont(string, f, bl, PFont.DEFAULT_CHARSET);
    }

    public PFont createFont(String string, float f, boolean bl, char[] cArray) {
        if (javaVersion < 1.3f) {
            throw new RuntimeException("Can only create fonts with Java 1.3 or higher");
        }
        String string2 = string.toLowerCase();
        Font font = null;
        try {
            Class clazz = class$java$awt$Font;
            if (clazz == null) {
                clazz = class$java$awt$Font = PApplet.class("[Ljava.awt.Font;", false);
            }
            Method method = clazz.getMethod("deriveFont", Float.TYPE);
            Float f2 = new Float(f);
            if (string2.endsWith(".otf") || string2.endsWith(".ttf")) {
                InputStream inputStream = this.openStream(string);
                if (inputStream == null) {
                    System.err.println("The font \"" + string + "\" is missing or inaccessible, make sure the URL is valid or that the file has been added to your sketch and is readable.");
                    return null;
                }
                Class clazz2 = class$java$awt$Font;
                if (clazz2 == null) {
                    clazz2 = class$java$awt$Font = PApplet.class("[Ljava.awt.Font;", false);
                }
                Class[] classArray = new Class[2];
                classArray[0] = Integer.TYPE;
                Class clazz3 = class$java$io$InputStream;
                if (clazz3 == null) {
                    clazz3 = class$java$io$InputStream = PApplet.class("[Ljava.io.InputStream;", false);
                }
                classArray[1] = clazz3;
                Method method2 = clazz2.getMethod("createFont", classArray);
                Class clazz4 = class$java$awt$Font;
                if (clazz4 == null) {
                    clazz4 = class$java$awt$Font = PApplet.class("[Ljava.awt.Font;", false);
                }
                Field field = clazz4.getField("TRUETYPE_FONT");
                Integer n = new Integer(field.getInt(field));
                Font font2 = (Font)method2.invoke((Object)string, n, this.openStream(string));
                font = (Font)method.invoke((Object)font2, f2);
            } else {
                Font font3 = new Font(string, 0, 1);
                font = (Font)method.invoke((Object)font3, f2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Problem using createFont() with the file " + string);
        }
        return new PFont(font, bl, cArray);
    }

    public File inputFile() {
        return this.inputFile("Select a file...");
    }

    public File inputFile(String string) {
        Frame frame = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                frame = (Frame)container;
                break;
            }
            container = container.getParent();
        }
        return PApplet.inputFile(string, frame);
    }

    public static File inputFile(Frame frame) {
        return PApplet.inputFile("Select a file...", frame);
    }

    public static File inputFile(String string, Frame frame) {
        if (frame == null) {
            frame = new Frame();
        }
        FileDialog fileDialog = new FileDialog(frame, string, 0);
        fileDialog.setVisible(true);
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 == null) {
            return null;
        }
        return new File(string2, string3);
    }

    public File outputFile() {
        return this.outputFile("Save as...");
    }

    public File outputFile(String string) {
        Frame frame = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                frame = (Frame)container;
                break;
            }
            container = container.getParent();
        }
        return PApplet.outputFile(string, frame);
    }

    public static File outputFile(Frame frame) {
        return PApplet.outputFile("Save as...", frame);
    }

    public static File outputFile(String string, Frame frame) {
        if (frame == null) {
            frame = new Frame();
        }
        FileDialog fileDialog = new FileDialog(frame, string, 1);
        fileDialog.setVisible(true);
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 == null) {
            return null;
        }
        return new File(string2, string3);
    }

    public BufferedReader createReader(String string) {
        try {
            InputStream inputStream = this.openStream(string);
            if (inputStream == null) {
                System.err.println(string + " does not exist or could not be read");
                return null;
            }
            return PApplet.createReader(inputStream);
        }
        catch (Exception exception) {
            if (string == null) {
                System.err.println("Filename passed to reader() was null");
            } else {
                System.err.println("Couldn't create a reader for " + string);
            }
            return null;
        }
    }

    public static BufferedReader createReader(File file) {
        try {
            return PApplet.createReader(new FileInputStream(file));
        }
        catch (Exception exception) {
            if (file == null) {
                throw new RuntimeException("File passed to reader() was null");
            }
            exception.printStackTrace();
            throw new RuntimeException("Couldn't create a reader for " + file.getAbsolutePath());
        }
    }

    public static BufferedReader createReader(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return new BufferedReader(inputStreamReader);
    }

    public static InputStream gzipInput(InputStream inputStream) {
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Problem with gzip input");
        }
    }

    public static OutputStream gzipOutput(OutputStream outputStream) {
        try {
            return new GZIPOutputStream(outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Problem with gzip output");
        }
    }

    public PrintWriter createWriter(String string) {
        try {
            return PApplet.createWriter(new FileOutputStream(this.savePath(string)));
        }
        catch (Exception exception) {
            if (string == null) {
                this.die("Filename passed to writer() was null", exception);
            } else {
                this.die("Couldn't create a writer for " + string, exception);
            }
            return null;
        }
    }

    public static PrintWriter createWriter(File file) {
        try {
            return PApplet.createWriter(new FileOutputStream(file));
        }
        catch (Exception exception) {
            if (file == null) {
                throw new RuntimeException("File passed to writer() was null");
            }
            exception.printStackTrace();
            throw new RuntimeException("Couldn't create a writer for " + file.getAbsolutePath());
        }
    }

    public static PrintWriter createWriter(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        return new PrintWriter(outputStreamWriter);
    }

    public static InputStream openStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            if (file == null) {
                throw new RuntimeException("File passed to openStream() was null");
            }
            iOException.printStackTrace();
            throw new RuntimeException("Couldn't openStream() for " + file.getAbsolutePath());
        }
    }

    /*
     * Exception decompiling
     */
    public InputStream openStream(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] loadBytes(String string) {
        InputStream inputStream = this.openStream(string);
        if (inputStream != null) {
            return PApplet.loadBytes(inputStream);
        }
        System.err.println("The file \"" + string + "\" is missing or inaccessible, make sure the URL is valid or that the file has been added to your sketch and is readable.");
        return null;
    }

    public static byte[] loadBytes(InputStream inputStream) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = bufferedInputStream.read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = bufferedInputStream.read();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String[] loadStrings(File file) {
        InputStream inputStream = PApplet.openStream(file);
        if (inputStream != null) {
            return PApplet.loadStrings(inputStream);
        }
        return null;
    }

    public String[] loadStrings(String string) {
        InputStream inputStream = this.openStream(string);
        if (inputStream != null) {
            return PApplet.loadStrings(inputStream);
        }
        System.err.println("The file \"" + string + "\" is missing or inaccessible, make sure the URL is valid or that the file has been added to your sketch and is readable.");
        return null;
    }

    public static String[] loadStrings(InputStream inputStream) {
        try {
            String[] stringArray;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String[] stringArray2 = new String[100];
            int n = 0;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (n == stringArray2.length) {
                    stringArray = new String[n << 1];
                    System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    stringArray2 = stringArray;
                }
                stringArray2[n++] = string;
            }
            bufferedReader.close();
            if (n == stringArray2.length) {
                return stringArray2;
            }
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            return stringArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void saveStream(String string, String string2) {
        this.saveBytes(string, this.loadBytes(string2));
    }

    public void saveStream(File file, String string) {
        PApplet.saveBytes(file, this.loadBytes(string));
    }

    public void saveBytes(String string, byte[] byArray) {
        try {
            String string2 = this.savePath(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PApplet.saveBytes(fileOutputStream, byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("error saving bytes to " + string);
            iOException.printStackTrace();
        }
    }

    public static void saveBytes(File file, byte[] byArray) {
        try {
            String string = file.getAbsolutePath();
            PApplet.createPath(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PApplet.saveBytes(fileOutputStream, byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("error saving bytes to " + file);
            iOException.printStackTrace();
        }
    }

    public static void saveBytes(OutputStream outputStream, byte[] byArray) {
        try {
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Couldn't save bytes");
        }
    }

    public void saveStrings(String string, String[] stringArray) {
        try {
            String string2 = this.savePath(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PApplet.saveStrings(fileOutputStream, stringArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("saveStrings() failed: " + iOException.getMessage());
        }
    }

    public static void saveStrings(File file, String[] stringArray) {
        try {
            String string = file.getAbsolutePath();
            PApplet.createPath(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PApplet.saveStrings(fileOutputStream, stringArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("error while saving strings");
            iOException.printStackTrace();
        }
    }

    public static void saveStrings(OutputStream outputStream, String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        int n = 0;
        while (n < stringArray.length) {
            printWriter.println(stringArray[n]);
            ++n;
        }
        printWriter.flush();
    }

    public String sketchPath(String string) {
        if (this.sketchPath == null) {
            throw new RuntimeException("The applet was not inited properly, or security restrictions prevented it from determining its path.");
        }
        try {
            if (new File(string).isAbsolute()) {
                return string;
            }
        }
        catch (Exception exception) {}
        return this.sketchPath + File.separator + string;
    }

    public String savePath(String string) {
        String string2 = this.sketchPath(string);
        PApplet.createPath(string2);
        return string2;
    }

    public String dataPath(String string) {
        if (new File(string).isAbsolute()) {
            return string;
        }
        return this.sketchPath + File.separator + "data" + File.separator + string;
    }

    public static void createPath(String string) {
        File file;
        File file2 = new File(string);
        String string2 = file2.getParent();
        if (string2 != null && !(file = new File(string2)).exists()) {
            file.mkdirs();
        }
    }

    public byte[] sort(byte[] byArray) {
        return this.sort(byArray, byArray.length);
    }

    public char[] sort(char[] cArray) {
        return this.sort(cArray, cArray.length);
    }

    public int[] sort(int[] nArray) {
        return this.sort(nArray, nArray.length);
    }

    public float[] sort(float[] fArray) {
        return this.sort(fArray, fArray.length);
    }

    public String[] sort(String[] stringArray) {
        return this.sort(stringArray, stringArray.length);
    }

    public byte[] sort(byte[] byArray, int n) {
        if (n == 0) {
            return null;
        }
        this.sort_mode = 1;
        this.sort_bytes = new byte[n];
        System.arraycopy(byArray, 0, this.sort_bytes, 0, n);
        this.sort_internal(0, n - 1);
        return this.sort_bytes;
    }

    public char[] sort(char[] cArray, int n) {
        if (n == 0) {
            return null;
        }
        this.sort_mode = 2;
        this.sort_chars = new char[n];
        System.arraycopy(cArray, 0, this.sort_chars, 0, n);
        this.sort_internal(0, n - 1);
        return this.sort_chars;
    }

    public int[] sort(int[] nArray, int n) {
        if (n == 0) {
            return null;
        }
        this.sort_mode = 3;
        this.sort_ints = new int[n];
        System.arraycopy(nArray, 0, this.sort_ints, 0, n);
        this.sort_internal(0, n - 1);
        return this.sort_ints;
    }

    public float[] sort(float[] fArray, int n) {
        if (n == 0) {
            return null;
        }
        this.sort_mode = 4;
        this.sort_floats = new float[n];
        System.arraycopy(fArray, 0, this.sort_floats, 0, n);
        this.sort_internal(0, n - 1);
        return this.sort_floats;
    }

    public String[] sort(String[] stringArray, int n) {
        if (n == 0) {
            return null;
        }
        this.sort_mode = 5;
        this.sort_strings = new String[n];
        System.arraycopy(stringArray, 0, this.sort_strings, 0, n);
        this.sort_internal(0, n - 1);
        return this.sort_strings;
    }

    protected void sort_internal(int n, int n2) {
        int n3 = (n + n2) / 2;
        this.sort_swap(n3, n2);
        int n4 = this.sort_partition(n - 1, n2);
        this.sort_swap(n4, n2);
        if (n4 - n > 1) {
            this.sort_internal(n, n4 - 1);
        }
        if (n2 - n4 > 1) {
            this.sort_internal(n4 + 1, n2);
        }
    }

    protected int sort_partition(int n, int n2) {
        int n3 = n2;
        while (true) {
            if (this.sort_compare(++n, n3) < 0) {
                continue;
            }
            while (n2 != 0 && this.sort_compare(--n2, n3) > 0) {
            }
            this.sort_swap(n, n2);
            if (n >= n2) break;
        }
        this.sort_swap(n, n2);
        return n;
    }

    protected void sort_swap(int n, int n2) {
        switch (this.sort_mode) {
            case 1: {
                byte by = this.sort_bytes[n];
                this.sort_bytes[n] = this.sort_bytes[n2];
                this.sort_bytes[n2] = by;
                break;
            }
            case 2: {
                char c = this.sort_chars[n];
                this.sort_chars[n] = this.sort_chars[n2];
                this.sort_chars[n2] = c;
                break;
            }
            case 3: {
                int n3 = this.sort_ints[n];
                this.sort_ints[n] = this.sort_ints[n2];
                this.sort_ints[n2] = n3;
                break;
            }
            case 4: {
                float f = this.sort_floats[n];
                this.sort_floats[n] = this.sort_floats[n2];
                this.sort_floats[n2] = f;
                break;
            }
            case 5: {
                String string = this.sort_strings[n];
                this.sort_strings[n] = this.sort_strings[n2];
                this.sort_strings[n2] = string;
                break;
            }
        }
    }

    protected int sort_compare(int n, int n2) {
        switch (this.sort_mode) {
            case 1: {
                return this.sort_bytes[n] - this.sort_bytes[n2];
            }
            case 2: {
                return this.sort_chars[n] - this.sort_chars[n2];
            }
            case 3: {
                return this.sort_ints[n] - this.sort_ints[n2];
            }
            case 4: {
                if (this.sort_floats[n] < this.sort_floats[n2]) {
                    return -1;
                }
                int n3 = 0;
                if (this.sort_floats[n] == this.sort_floats[n2]) {
                    n3 = 1;
                }
                return 1 - n3;
            }
            case 5: {
                return this.sort_strings[n].compareTo(this.sort_strings[n2]);
            }
        }
        return 0;
    }

    public static void arraycopy(Object object, int n, Object object2, int n2, int n3) {
        System.arraycopy(object, n, object2, n2, n3);
    }

    public static void arraycopy(Object object, Object object2, int n) {
        System.arraycopy(object, 0, object2, 0, n);
    }

    public static void arraycopy(Object object, Object object2) {
        System.arraycopy(object, 0, object2, 0, Array.getLength(object));
    }

    public static boolean[] expand(boolean[] blArray) {
        return PApplet.expand(blArray, blArray.length << 1);
    }

    public static boolean[] expand(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, Math.min(n, blArray.length));
        return blArray2;
    }

    public static byte[] expand(byte[] byArray) {
        return PApplet.expand(byArray, byArray.length << 1);
    }

    public static byte[] expand(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n, byArray.length));
        return byArray2;
    }

    public static char[] expand(char[] cArray) {
        return PApplet.expand(cArray, cArray.length << 1);
    }

    public static char[] expand(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, Math.min(n, cArray.length));
        return cArray2;
    }

    public static int[] expand(int[] nArray) {
        return PApplet.expand(nArray, nArray.length << 1);
    }

    public static int[] expand(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(n, nArray.length));
        return nArray2;
    }

    public static float[] expand(float[] fArray) {
        return PApplet.expand(fArray, fArray.length << 1);
    }

    public static float[] expand(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(n, fArray.length));
        return fArray2;
    }

    public static String[] expand(String[] stringArray) {
        return PApplet.expand(stringArray, stringArray.length << 1);
    }

    public static String[] expand(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(n, stringArray.length));
        return stringArray2;
    }

    public static Object expand(Object object) {
        return PApplet.expand(object, Array.getLength(object) << 1);
    }

    public static Object expand(Object object, int n) {
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n);
        System.arraycopy(object, 0, object2, 0, Math.min(Array.getLength(object), n));
        return object2;
    }

    public static byte[] append(byte[] byArray, byte by) {
        byArray = PApplet.expand(byArray, byArray.length + 1);
        byArray[byArray.length - 1] = by;
        return byArray;
    }

    public static char[] append(char[] cArray, char c) {
        cArray = PApplet.expand(cArray, cArray.length + 1);
        cArray[cArray.length - 1] = c;
        return cArray;
    }

    public static int[] append(int[] nArray, int n) {
        nArray = PApplet.expand(nArray, nArray.length + 1);
        nArray[nArray.length - 1] = n;
        return nArray;
    }

    public static float[] append(float[] fArray, float f) {
        fArray = PApplet.expand(fArray, fArray.length + 1);
        fArray[fArray.length - 1] = f;
        return fArray;
    }

    public static String[] append(String[] stringArray, String string) {
        stringArray = PApplet.expand(stringArray, stringArray.length + 1);
        stringArray[stringArray.length - 1] = string;
        return stringArray;
    }

    public static Object append(Object object, Object object2) {
        int n = Array.getLength(object);
        object = PApplet.expand(object, n + 1);
        Array.set(object, n, object2);
        return object;
    }

    public static boolean[] shorten(boolean[] blArray) {
        return PApplet.subset(blArray, 0, blArray.length - 1);
    }

    public static byte[] shorten(byte[] byArray) {
        return PApplet.subset(byArray, 0, byArray.length - 1);
    }

    public static char[] shorten(char[] cArray) {
        return PApplet.subset(cArray, 0, cArray.length - 1);
    }

    public static int[] shorten(int[] nArray) {
        return PApplet.subset(nArray, 0, nArray.length - 1);
    }

    public static float[] shorten(float[] fArray) {
        return PApplet.subset(fArray, 0, fArray.length - 1);
    }

    public static String[] shorten(String[] stringArray) {
        return PApplet.subset(stringArray, 0, stringArray.length - 1);
    }

    public static Object shorten(Object object) {
        int n = Array.getLength(object);
        return PApplet.subset(object, 0, n - 1);
    }

    public static final boolean[] splice(boolean[] blArray, boolean bl, int n) {
        boolean[] blArray2 = new boolean[blArray.length + 1];
        System.arraycopy(blArray, 0, blArray2, 0, n);
        blArray2[n] = bl;
        System.arraycopy(blArray, n, blArray2, n + 1, blArray.length - n);
        return blArray2;
    }

    public static final boolean[] splice(boolean[] blArray, boolean[] blArray2, int n) {
        boolean[] blArray3 = new boolean[blArray.length + blArray2.length];
        System.arraycopy(blArray, 0, blArray3, 0, n);
        System.arraycopy(blArray2, 0, blArray3, n, blArray2.length);
        System.arraycopy(blArray, n, blArray3, n + blArray2.length, blArray.length - n);
        return blArray3;
    }

    public static final byte[] splice(byte[] byArray, byte by, int n) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        System.arraycopy(byArray, n, byArray2, n + 1, byArray.length - n);
        return byArray2;
    }

    public static final byte[] splice(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(byArray, n, byArray3, n + byArray2.length, byArray.length - n);
        return byArray3;
    }

    public static final char[] splice(char[] cArray, char c, int n) {
        char[] cArray2 = new char[cArray.length + 1];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        cArray2[n] = c;
        System.arraycopy(cArray, n, cArray2, n + 1, cArray.length - n);
        return cArray2;
    }

    public static final char[] splice(char[] cArray, char[] cArray2, int n) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        System.arraycopy(cArray2, 0, cArray3, n, cArray2.length);
        System.arraycopy(cArray, n, cArray3, n + cArray2.length, cArray.length - n);
        return cArray3;
    }

    public static final int[] splice(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        nArray2[n2] = n;
        System.arraycopy(nArray, n2, nArray2, n2 + 1, nArray.length - n2);
        return nArray2;
    }

    public static final int[] splice(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        System.arraycopy(nArray2, 0, nArray3, n, nArray2.length);
        System.arraycopy(nArray, n, nArray3, n + nArray2.length, nArray.length - n);
        return nArray3;
    }

    public static final float[] splice(float[] fArray, float f, int n) {
        float[] fArray2 = new float[fArray.length + 1];
        System.arraycopy(fArray, 0, fArray2, 0, n);
        fArray2[n] = f;
        System.arraycopy(fArray, n, fArray2, n + 1, fArray.length - n);
        return fArray2;
    }

    public static final float[] splice(float[] fArray, float[] fArray2, int n) {
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, n);
        System.arraycopy(fArray2, 0, fArray3, n, fArray2.length);
        System.arraycopy(fArray, n, fArray3, n + fArray2.length, fArray.length - n);
        return fArray3;
    }

    public static final String[] splice(String[] stringArray, String string, int n) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray2[n] = string;
        System.arraycopy(stringArray, n, stringArray2, n + 1, stringArray.length - n);
        return stringArray2;
    }

    public static final String[] splice(String[] stringArray, String[] stringArray2, int n) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        System.arraycopy(stringArray2, 0, stringArray3, n, stringArray2.length);
        System.arraycopy(stringArray, n, stringArray3, n + stringArray2.length, stringArray.length - n);
        return stringArray3;
    }

    public static final Object splice(Object object, Object object2, int n) {
        Object[] objectArray = null;
        int n2 = Array.getLength(object);
        if (object.getClass().getName().charAt(0) == '[') {
            int n3 = Array.getLength(object2);
            objectArray = new Object[n2 + n3];
            System.arraycopy(object, 0, objectArray, 0, n);
            System.arraycopy(object2, 0, objectArray, n, n3);
            System.arraycopy(object, n, objectArray, n + n3, n2 - n);
        } else {
            objectArray = new Object[n2 + 1];
            System.arraycopy(object, 0, objectArray, 0, n);
            Array.set(objectArray, n, object2);
            System.arraycopy(object, n, objectArray, n + 1, n2 - n);
        }
        return objectArray;
    }

    public static boolean[] subset(boolean[] blArray, int n) {
        return PApplet.subset(blArray, n, blArray.length - n);
    }

    public static boolean[] subset(boolean[] blArray, int n, int n2) {
        boolean[] blArray2 = new boolean[n2];
        System.arraycopy(blArray, n, blArray2, 0, n2);
        return blArray2;
    }

    public static byte[] subset(byte[] byArray, int n) {
        return PApplet.subset(byArray, n, byArray.length - n);
    }

    public static byte[] subset(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static char[] subset(char[] cArray, int n) {
        return PApplet.subset(cArray, n, cArray.length - n);
    }

    public static char[] subset(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return cArray2;
    }

    public static int[] subset(int[] nArray, int n) {
        return PApplet.subset(nArray, n, nArray.length - n);
    }

    public static int[] subset(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        return nArray2;
    }

    public static float[] subset(float[] fArray, int n) {
        return PApplet.subset(fArray, n, fArray.length - n);
    }

    public static float[] subset(float[] fArray, int n, int n2) {
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, n, fArray2, 0, n2);
        return fArray2;
    }

    public static String[] subset(String[] stringArray, int n) {
        return PApplet.subset(stringArray, n, stringArray.length - n);
    }

    public static String[] subset(String[] stringArray, int n, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    public static Object subset(Object object, int n) {
        int n2 = Array.getLength(object);
        int n3 = n2 - n;
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n3);
        System.arraycopy(object, 0, object2, 0, n3);
        return object2;
    }

    public static Object subset(Object object, int n, int n2) {
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n2);
        System.arraycopy(object, n, object2, 0, n2);
        return object2;
    }

    public static boolean[] concat(boolean[] blArray, boolean[] blArray2) {
        boolean[] blArray3 = new boolean[blArray.length + blArray2.length];
        System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
        System.arraycopy(blArray2, 0, blArray3, blArray.length, blArray2.length);
        return blArray3;
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static char[] concat(char[] cArray, char[] cArray2) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    public static int[] concat(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static float[] concat(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
        System.arraycopy(fArray2, 0, fArray3, fArray.length, fArray2.length);
        return fArray3;
    }

    public static String[] concat(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static Object concat(Object object, Object object2) {
        Class<?> clazz = object.getClass().getComponentType();
        int n = Array.getLength(object);
        int n2 = Array.getLength(object2);
        Object object3 = Array.newInstance(clazz, n + n2);
        System.arraycopy(object, 0, object3, 0, n);
        System.arraycopy(object2, 0, object3, n, n2);
        return object3;
    }

    public static boolean[] reverse(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        int n = blArray.length - 1;
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray2[n2] = blArray[n - n2];
            ++n2;
        }
        return blArray2;
    }

    public static byte[] reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = byArray.length - 1;
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray2[n2] = byArray[n - n2];
            ++n2;
        }
        return byArray2;
    }

    public static char[] reverse(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        int n = cArray.length - 1;
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray2[n2] = cArray[n - n2];
            ++n2;
        }
        return cArray2;
    }

    public static int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = nArray.length - 1;
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = nArray[n - n2];
            ++n2;
        }
        return nArray2;
    }

    public static float[] reverse(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        int n = fArray.length - 1;
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray2[n2] = fArray[n - n2];
            ++n2;
        }
        return fArray2;
    }

    public static String[] reverse(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2] = stringArray[n - n2];
            ++n2;
        }
        return stringArray2;
    }

    public static Object reverse(Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(clazz, n);
        int n2 = 0;
        while (n2 < n) {
            Array.set(object2, n2, Array.get(object, n - 1 - n2));
            ++n2;
        }
        return object2;
    }

    public static String trim(String string) {
        return string.replace('\u00a0', ' ').trim();
    }

    public static String[] trim(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n].replace('\u00a0', ' ').trim();
            ++n;
        }
        return stringArray2;
    }

    public static String join(String[] stringArray, char c) {
        return PApplet.join(stringArray, String.valueOf(c));
    }

    public static String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] split(String string) {
        return PApplet.split(string, " \t\n\r\f\u00a0");
    }

    public static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String[] split(String string, char c) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == c) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            String[] stringArray = new String[]{new String(string)};
            return stringArray;
        }
        String[] stringArray = new String[n + 1];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < cArray.length) {
            if (cArray[n5] == c) {
                stringArray[n3++] = new String(cArray, n4, n5 - n4);
                n4 = n5 + 1;
            }
            ++n5;
        }
        stringArray[n3] = new String(cArray, n4, cArray.length - n4);
        return stringArray;
    }

    public static final boolean parseBoolean(String string) {
        return new Boolean(string);
    }

    public static final boolean[] parseBoolean(String[] stringArray) {
        boolean[] blArray = new boolean[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            blArray[n] = new Boolean(stringArray[n]);
            ++n;
        }
        return blArray;
    }

    public static final byte parseByte(char c) {
        return (byte)c;
    }

    public static final byte parseByte(int n) {
        return (byte)n;
    }

    public static final byte[] parseByte(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    public static final byte[] parseByte(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        return byArray;
    }

    public static final char parseChar(byte by) {
        return (char)(by & 0xFF);
    }

    public static final char parseChar(int n) {
        return (char)n;
    }

    public static final char[] parseChar(int[] nArray) {
        char[] cArray = new char[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            cArray[n] = (char)nArray[n];
            ++n;
        }
        return cArray;
    }

    public static final char[] parseChar(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            cArray[n] = (char)(byArray[n] & 0xFF);
            ++n;
        }
        return cArray;
    }

    public static final int parseInt(byte by) {
        return by & 0xFF;
    }

    public static final int parseInt(char c) {
        return c;
    }

    public static final int parseInt(float f) {
        return (int)f;
    }

    public static final int parseInt(String string) {
        return PApplet.parseInt(string, 0);
    }

    public static final int parseInt(String string, int n) {
        try {
            int n2 = string.indexOf(46);
            if (n2 == -1) {
                return Integer.parseInt(string);
            }
            return Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static final int[] parseInt(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        return nArray;
    }

    public static final int[] parseInt(char[] cArray) {
        int[] nArray = new int[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            nArray[n] = cArray[n];
            ++n;
        }
        return nArray;
    }

    public static int[] parseInt(float[] fArray) {
        int[] nArray = new int[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            nArray[n] = (int)fArray[n];
            ++n;
        }
        return nArray;
    }

    public static int[] parseInt(String[] stringArray) {
        return PApplet.parseInt(stringArray, 0);
    }

    public static int[] parseInt(String[] stringArray, int n) {
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                nArray[n2] = Integer.parseInt(stringArray[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                nArray[n2] = n;
            }
            ++n2;
        }
        return nArray;
    }

    public static final float parseFloat(int n) {
        return n;
    }

    public static final float parseFloat(String string) {
        return PApplet.parseFloat(string, Float.NaN);
    }

    public static final float parseFloat(String string, float f) {
        try {
            return new Float(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static final float[] parseFloat(int[] nArray) {
        float[] fArray = new float[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            fArray[n] = nArray[n];
            ++n;
        }
        return fArray;
    }

    public static final float[] parseFloat(String[] stringArray) {
        return PApplet.parseFloat(stringArray, 0.0f);
    }

    public static final float[] parseFloat(String[] stringArray, float f) {
        float[] fArray = new float[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                fArray[n] = new Float(stringArray[n]).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                fArray[n] = f;
            }
            ++n;
        }
        return fArray;
    }

    public static final String str(boolean bl) {
        return String.valueOf(bl);
    }

    public static final String str(byte by) {
        return String.valueOf(by);
    }

    public static final String str(char c) {
        return String.valueOf(c);
    }

    public static final String str(short s) {
        return String.valueOf(s);
    }

    public static final String str(int n) {
        return String.valueOf(n);
    }

    public static final String str(float f) {
        return String.valueOf(f);
    }

    public static final String str(long l) {
        return String.valueOf(l);
    }

    public static final String str(double d) {
        return String.valueOf(d);
    }

    public static final String[] str(boolean[] blArray) {
        String[] stringArray = new String[blArray.length];
        int n = 0;
        while (n < blArray.length) {
            stringArray[n] = String.valueOf(blArray);
            ++n;
        }
        return stringArray;
    }

    public static final String[] str(byte[] byArray) {
        String[] stringArray = new String[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            stringArray[n] = String.valueOf(byArray);
            ++n;
        }
        return stringArray;
    }

    public static final String[] str(char[] cArray) {
        String[] stringArray = new String[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            stringArray[n] = String.valueOf(cArray);
            ++n;
        }
        return stringArray;
    }

    public static final String[] str(short[] sArray) {
        String[] stringArray = new String[sArray.length];
        int n = 0;
        while (n < sArray.length) {
            stringArray[n] = String.valueOf(sArray);
            ++n;
        }
        return stringArray;
    }

    public static final String[] str(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = String.valueOf(nArray);
            ++n;
        }
        return stringArray;
    }

    public static final String[] str(float[] fArray) {
        String[] stringArray = new String[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            stringArray[n] = String.valueOf(fArray);
            ++n;
        }
        return stringArray;
    }

    public static final String[] str(long[] lArray) {
        String[] stringArray = new String[lArray.length];
        int n = 0;
        while (n < lArray.length) {
            stringArray[n] = String.valueOf(lArray);
            ++n;
        }
        return stringArray;
    }

    public static final String[] str(double[] dArray) {
        String[] stringArray = new String[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            stringArray[n] = String.valueOf(dArray);
            ++n;
        }
        return stringArray;
    }

    public static String[] nf(int[] nArray, int n) {
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = PApplet.nf(nArray[n2], n);
            ++n2;
        }
        return stringArray;
    }

    public static String nf(int n, int n2) {
        if (int_nf != null && int_nf_digits == n2 && !int_nf_commas) {
            return int_nf.format(n);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(false);
        int_nf_commas = false;
        int_nf.setMinimumIntegerDigits(n2);
        int_nf_digits = n2;
        return int_nf.format(n);
    }

    public static String[] nfc(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = PApplet.nfc(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public static String nfc(int n) {
        if (int_nf != null && int_nf_digits == 0 && int_nf_commas) {
            return int_nf.format(n);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(true);
        int_nf_commas = true;
        int_nf.setMinimumIntegerDigits(0);
        int_nf_digits = 0;
        return int_nf.format(n);
    }

    public static String nfs(int n, int n2) {
        return n < 0 ? PApplet.nf(n, n2) : " " + PApplet.nf(n, n2);
    }

    public static String[] nfs(int[] nArray, int n) {
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = PApplet.nfs(nArray[n2], n);
            ++n2;
        }
        return stringArray;
    }

    public static String nfp(int n, int n2) {
        return n < 0 ? PApplet.nf(n, n2) : "+" + PApplet.nf(n, n2);
    }

    public static String[] nfp(int[] nArray, int n) {
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = PApplet.nfp(nArray[n2], n);
            ++n2;
        }
        return stringArray;
    }

    public static String[] nf(float[] fArray, int n, int n2) {
        String[] stringArray = new String[fArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = PApplet.nf(fArray[n3], n, n2);
            ++n3;
        }
        return stringArray;
    }

    public static String nf(float f, int n, int n2) {
        if (float_nf != null && float_nf_left == n && float_nf_right == n2 && !float_nf_commas) {
            return float_nf.format(f);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(false);
        float_nf_commas = false;
        if (n != 0) {
            float_nf.setMinimumIntegerDigits(n);
        }
        if (n2 != 0) {
            float_nf.setMinimumFractionDigits(n2);
            float_nf.setMaximumFractionDigits(n2);
        }
        float_nf_left = n;
        float_nf_right = n2;
        return float_nf.format(f);
    }

    public static String[] nfc(float[] fArray, int n) {
        String[] stringArray = new String[fArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = PApplet.nfc(fArray[n2], n);
            ++n2;
        }
        return stringArray;
    }

    public static String nfc(float f, int n) {
        if (float_nf != null && float_nf_left == 0 && float_nf_right == n && float_nf_commas) {
            return float_nf.format(f);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(true);
        float_nf_commas = true;
        if (n != 0) {
            float_nf.setMinimumFractionDigits(n);
            float_nf.setMaximumFractionDigits(n);
        }
        float_nf_left = 0;
        float_nf_right = n;
        return float_nf.format(f);
    }

    public static String[] nfs(float[] fArray, int n, int n2) {
        String[] stringArray = new String[fArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = PApplet.nfs(fArray[n3], n, n2);
            ++n3;
        }
        return stringArray;
    }

    public static String nfs(float f, int n, int n2) {
        return f < 0.0f ? PApplet.nf(f, n, n2) : " " + PApplet.nf(f, n, n2);
    }

    public static String[] nfp(float[] fArray, int n, int n2) {
        String[] stringArray = new String[fArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = PApplet.nfp(fArray[n3], n, n2);
            ++n3;
        }
        return stringArray;
    }

    public static String nfp(float f, int n, int n2) {
        return f < 0.0f ? PApplet.nf(f, n, n2) : "+" + PApplet.nf(f, n, n2);
    }

    public static final String hex(byte by) {
        return PApplet.hex(by, 2);
    }

    public static final String hex(char c) {
        return PApplet.hex(c, 4);
    }

    public static final String hex(int n) {
        return PApplet.hex(n, 8);
    }

    public static final String hex(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        int n3 = string.length();
        if (n3 > n2) {
            return string.substring(n3 - n2);
        }
        if (n3 < n2) {
            return "00000000".substring(8 - (n2 - n3)) + string;
        }
        return string;
    }

    public static final int unhex(String string) {
        return (int)Long.parseLong(string, 16);
    }

    public static final String binary(byte by) {
        return PApplet.binary(by, 8);
    }

    public static final String binary(char c) {
        return PApplet.binary(c, 16);
    }

    public static final String binary(int n) {
        return Integer.toBinaryString(n);
    }

    public static final String binary(int n, int n2) {
        String string = Integer.toBinaryString(n);
        int n3 = string.length();
        if (n3 > n2) {
            return string.substring(n3 - n2);
        }
        if (n3 < n2) {
            int n4 = 32 - (n2 - n3);
            return "00000000000000000000000000000000".substring(n4) + string;
        }
        return string;
    }

    public static final int unbinary(String string) {
        return Integer.parseInt(string, 2);
    }

    public final int color(int n) {
        if (this.g == null) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        return this.g.color(n);
    }

    public final int color(float f) {
        if (this.g == null) {
            int n = (int)f;
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        return this.g.color(f);
    }

    public final int color(int n, int n2) {
        if (this.g == null) {
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n > 255) {
                return n2 << 24 | n & 0xFFFFFF;
            }
            return n2 << 24 | n << 16 | n << 8 | n;
        }
        return this.g.color(n, n2);
    }

    public final int color(float f, float f2) {
        if (this.g == null) {
            int n = (int)f;
            int n2 = (int)f2;
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        return this.g.color(f, f2);
    }

    public final int color(int n, int n2, int n3) {
        if (this.g == null) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return 0xFF000000 | n << 16 | n2 << 8 | n3;
        }
        return this.g.color(n, n2, n3);
    }

    public final int color(float f, float f2, float f3) {
        if (this.g == null) {
            if (f > 255.0f) {
                f = 255.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 > 255.0f) {
                f2 = 255.0f;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 > 255.0f) {
                f3 = 255.0f;
            } else if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            return 0xFF000000 | (int)f << 16 | (int)f2 << 8 | (int)f3;
        }
        return this.g.color(f, f2, f3);
    }

    public final int color(int n, int n2, int n3, int n4) {
        if (this.g == null) {
            if (n4 > 255) {
                n4 = 255;
            } else if (n4 < 0) {
                n4 = 0;
            }
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return n4 << 24 | n << 16 | n2 << 8 | n3;
        }
        return this.g.color(n, n2, n3, n4);
    }

    public final int color(float f, float f2, float f3, float f4) {
        if (this.g == null) {
            if (f4 > 255.0f) {
                f4 = 255.0f;
            } else if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            if (f > 255.0f) {
                f = 255.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 > 255.0f) {
                f2 = 255.0f;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 > 255.0f) {
                f3 = 255.0f;
            } else if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            return (int)f4 << 24 | (int)f << 16 | (int)f2 << 8 | (int)f3;
        }
        return this.g.color(f, f2, f3, f4);
    }

    public void setupExternalMessages() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public final void componentMoved(ComponentEvent componentEvent) {
                Point point = ((Frame)componentEvent.getSource()).getLocation();
                System.err.println("__MOVE__ " + point.x + ' ' + point.y);
                System.err.flush();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
                System.err.println(PApplet.EXTERNAL_QUIT);
                System.err.flush();
                System.exit(0);
            }
        });
    }

    public void setupFrameResizeListener() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public final void componentResized(ComponentEvent componentEvent) {
                Frame frame = (Frame)componentEvent.getComponent();
                if (frame.isVisible()) {
                    Insets insets = frame.getInsets();
                    Dimension dimension = frame.getSize();
                    int n = dimension.width - insets.left - insets.right;
                    int n2 = dimension.height - insets.top - insets.bottom;
                    PApplet.this.setBounds(insets.left, insets.top, n, n2);
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: PApplet <appletname>");
            System.err.println("For additional options, see the javadoc for PApplet");
            System.exit(1);
        }
        try {
            GraphicsDevice[] graphicsDeviceArray;
            Object object;
            boolean bl = false;
            int[] nArray = null;
            int[] nArray2 = null;
            String string = null;
            boolean bl2 = false;
            Color color = Color.black;
            Color color2 = Color.gray;
            GraphicsDevice graphicsDevice = null;
            boolean bl3 = false;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            try {
                string4 = System.getProperty("user.dir");
            }
            catch (Exception exception) {}
            int n = 0;
            while (n < stringArray.length) {
                block37: {
                    block35: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block36: {
                                            int n2 = stringArray[n].indexOf(61);
                                            if (n2 == -1) break block35;
                                            string2 = stringArray[n].substring(0, n2);
                                            string3 = stringArray[n].substring(n2 + 1);
                                            if (!string2.equals(ARGS_EDITOR_LOCATION)) break block36;
                                            bl = true;
                                            nArray2 = PApplet.parseInt(PApplet.split(string3, ','));
                                            break block37;
                                        }
                                        if (!string2.equals(ARGS_DISPLAY)) break block38;
                                        int n3 = Integer.parseInt(string3) - 1;
                                        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
                                        graphicsDeviceArray = ((GraphicsEnvironment)object).getScreenDevices();
                                        if (n3 >= 0 && n3 < graphicsDeviceArray.length) {
                                            graphicsDevice = graphicsDeviceArray[n3];
                                        } else {
                                            System.err.println("Display " + string3 + " does not exist, using the default display instead.");
                                        }
                                        break block37;
                                    }
                                    if (!string2.equals(ARGS_BGCOLOR)) break block39;
                                    if (string3.charAt(0) == '#') {
                                        string3 = string3.substring(1);
                                    }
                                    color = new Color(Integer.parseInt(string3, 16));
                                    break block37;
                                }
                                if (!string2.equals(ARGS_STOP_COLOR)) break block40;
                                if (string3.charAt(0) == '#') {
                                    string3 = string3.substring(1);
                                }
                                color2 = new Color(Integer.parseInt(string3, 16));
                                break block37;
                            }
                            if (!string2.equals(ARGS_SKETCH_FOLDER)) break block41;
                            string4 = string3;
                            break block37;
                        }
                        if (!string2.equals(ARGS_LOCATION)) break block37;
                        nArray = PApplet.parseInt(PApplet.split(string3, ','));
                        break block37;
                    }
                    if (stringArray[n].equals(ARGS_PRESENT)) {
                        bl2 = true;
                    } else if (stringArray[n].equals(ARGS_HIDE_STOP)) {
                        bl3 = true;
                    } else if (stringArray[n].equals(ARGS_EXTERNAL)) {
                        bl = true;
                    } else {
                        string = stringArray[n];
                        break;
                    }
                }
                ++n;
            }
            if (graphicsDevice == null) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            }
            Frame frame = new Frame(graphicsDevice.getDefaultConfiguration());
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setResizable(false);
            object = Class.forName(string);
            graphicsDeviceArray = (GraphicsDevice[])((Class)object).newInstance();
            graphicsDeviceArray.frame = frame;
            graphicsDeviceArray.sketchPath = string4;
            graphicsDeviceArray.args = PApplet.subset(stringArray, 1);
            graphicsDeviceArray.init();
            while (graphicsDeviceArray.defaultSize && !graphicsDeviceArray.finished) {
                try {
                    Thread.sleep(5);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (bl2) {
                frame.setUndecorated(true);
                frame.setBackground(color);
                graphicsDevice.setFullScreenWindow(frame);
                frame.add((Component)graphicsDeviceArray);
                Dimension dimension2 = frame.getSize();
                graphicsDeviceArray.setBounds((dimension2.width - graphicsDeviceArray.width) / 2, (dimension2.height - graphicsDeviceArray.height) / 2, graphicsDeviceArray.width, graphicsDeviceArray.height);
                if (!bl3) {
                    Label label = new Label("stop");
                    label.setForeground(color2);
                    label.addMouseListener(new MouseAdapter(){

                        public final void mousePressed(MouseEvent mouseEvent) {
                            System.exit(0);
                        }
                    });
                    frame.add(label);
                    Dimension dimension3 = label.getPreferredSize();
                    dimension3 = new Dimension(100, dimension3.height);
                    label.setSize(dimension3);
                    label.setLocation(20, dimension2.height - dimension3.height - 20);
                }
                if (bl) {
                    graphicsDeviceArray.setupExternalMessages();
                }
            } else {
                int n4;
                frame.pack();
                Insets insets = frame.getInsets();
                int n5 = Math.max(graphicsDeviceArray.width, 128) + insets.left + insets.right;
                int n6 = Math.max(graphicsDeviceArray.height, 128) + insets.top + insets.bottom;
                frame.setSize(n5, n6);
                if (nArray != null) {
                    frame.setLocation(nArray[0], nArray[1]);
                } else if (bl) {
                    n4 = nArray2[0] - 20;
                    int n7 = nArray2[1];
                    if (n4 - n5 > 10) {
                        frame.setLocation(n4 - n5, n7);
                    } else {
                        n4 = nArray2[0] + 66;
                        n7 = nArray2[1] + 66;
                        if (n4 + n5 > dimension.width - 33 || n7 + n6 > dimension.height - 33) {
                            n4 = (dimension.width - n5) / 2;
                            n7 = (dimension.height - n6) / 2;
                        }
                        frame.setLocation(n4, n7);
                    }
                } else {
                    frame.setLocation((dimension.width - graphicsDeviceArray.width) / 2, (dimension.height - graphicsDeviceArray.height) / 2);
                }
                frame.setLayout(null);
                frame.add((Component)graphicsDeviceArray);
                if (color == Color.black) {
                    color = SystemColor.control;
                }
                frame.setBackground(color);
                n4 = n6 - insets.top - insets.bottom;
                graphicsDeviceArray.setBounds((n5 - graphicsDeviceArray.width) / 2, insets.top + (n4 - graphicsDeviceArray.height) / 2, graphicsDeviceArray.width, graphicsDeviceArray.height);
                if (bl) {
                    graphicsDeviceArray.setupExternalMessages();
                } else {
                    frame.addWindowListener(new WindowAdapter(){

                        public final void windowClosing(WindowEvent windowEvent) {
                            System.exit(0);
                        }
                    });
                }
                graphicsDeviceArray.setupFrameResizeListener();
                if (graphicsDeviceArray.displayable()) {
                    frame.setVisible(true);
                }
            }
            graphicsDeviceArray.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public PGraphics beginRecord(String string, String string2) {
        string2 = this.insertFrame(string2);
        PGraphics pGraphics = this.createGraphics(this.width, this.height, string, string2);
        this.beginRecord(pGraphics);
        return pGraphics;
    }

    public void beginRecord(PGraphics pGraphics) {
        this.recorder = pGraphics;
        pGraphics.beginDraw();
    }

    public void endRecord() {
        if (this.recorder != null) {
            this.recorder.endDraw();
            this.recorder.dispose();
            this.recorder = null;
        }
    }

    public PGraphics beginRaw(String string, String string2) {
        string2 = this.insertFrame(string2);
        PGraphics pGraphics = this.createGraphics(this.width, this.height, string, string2);
        this.g.beginRaw(pGraphics);
        return pGraphics;
    }

    public String insertFrame(String string) {
        int n = string.indexOf(35);
        int n2 = string.lastIndexOf(35);
        if (n != -1 && n2 - n > 0) {
            String string2 = string.substring(0, n);
            int n3 = n2 - n + 1;
            String string3 = string.substring(n2 + 1);
            return string2 + PApplet.nf(this.frameCount, n3) + string3;
        }
        return string;
    }

    public void loadPixels() {
        this.g.loadPixels();
        this.pixels = this.g.pixels;
    }

    public void imageMode(int n) {
        if (this.recorder != null) {
            this.recorder.imageMode(n);
        }
        this.g.imageMode(n);
    }

    public void smooth() {
        if (this.recorder != null) {
            this.recorder.smooth();
        }
        this.g.smooth();
    }

    public void noSmooth() {
        if (this.recorder != null) {
            this.recorder.noSmooth();
        }
        this.g.noSmooth();
    }

    public void updatePixels() {
        if (this.recorder != null) {
            this.recorder.updatePixels();
        }
        this.g.updatePixels();
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        if (this.recorder != null) {
            this.recorder.updatePixels(n, n2, n3, n4);
        }
        this.g.updatePixels(n, n2, n3, n4);
    }

    public int get(int n, int n2) {
        return this.g.get(n, n2);
    }

    public PImage get(int n, int n2, int n3, int n4) {
        return this.g.get(n, n2, n3, n4);
    }

    public PImage get() {
        return this.g.get();
    }

    public void set(int n, int n2, int n3) {
        if (this.recorder != null) {
            this.recorder.set(n, n2, n3);
        }
        this.g.set(n, n2, n3);
    }

    public void set(int n, int n2, PImage pImage) {
        if (this.recorder != null) {
            this.recorder.set(n, n2, pImage);
        }
        this.g.set(n, n2, pImage);
    }

    public void mask(int[] nArray) {
        if (this.recorder != null) {
            this.recorder.mask(nArray);
        }
        this.g.mask(nArray);
    }

    public void mask(PImage pImage) {
        if (this.recorder != null) {
            this.recorder.mask(pImage);
        }
        this.g.mask(pImage);
    }

    public void filter(int n) {
        if (this.recorder != null) {
            this.recorder.filter(n);
        }
        this.g.filter(n);
    }

    public void filter(int n, float f) {
        if (this.recorder != null) {
            this.recorder.filter(n, f);
        }
        this.g.filter(n, f);
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.recorder != null) {
            this.recorder.copy(n, n2, n3, n4, n5, n6, n7, n8);
        }
        this.g.copy(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.recorder != null) {
            this.recorder.copy(pImage, n, n2, n3, n4, n5, n6, n7, n8);
        }
        this.g.copy(pImage, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static int blendColor(int n, int n2, int n3) {
        return PGraphics.blendColor(n, n2, n3);
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.recorder != null) {
            this.recorder.blend(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        this.g.blend(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.recorder != null) {
            this.recorder.blend(pImage, n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        this.g.blend(pImage, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void hint(int n) {
        if (this.recorder != null) {
            this.recorder.hint(n);
        }
        this.g.hint(n);
    }

    public void noHint(int n) {
        if (this.recorder != null) {
            this.recorder.noHint(n);
        }
        this.g.noHint(n);
    }

    public void beginShape() {
        if (this.recorder != null) {
            this.recorder.beginShape();
        }
        this.g.beginShape();
    }

    public void beginShape(int n) {
        if (this.recorder != null) {
            this.recorder.beginShape(n);
        }
        this.g.beginShape(n);
    }

    public void normal(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.normal(f, f2, f3);
        }
        this.g.normal(f, f2, f3);
    }

    public void textureMode(int n) {
        if (this.recorder != null) {
            this.recorder.textureMode(n);
        }
        this.g.textureMode(n);
    }

    public void texture(PImage pImage) {
        if (this.recorder != null) {
            this.recorder.texture(pImage);
        }
        this.g.texture(pImage);
    }

    public void vertex(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.vertex(f, f2);
        }
        this.g.vertex(f, f2);
    }

    public void vertex(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.vertex(f, f2, f3);
        }
        this.g.vertex(f, f2, f3);
    }

    public void vertex(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.vertex(f, f2, f3, f4);
        }
        this.g.vertex(f, f2, f3, f4);
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        if (this.recorder != null) {
            this.recorder.vertex(f, f2, f3, f4, f5);
        }
        this.g.vertex(f, f2, f3, f4, f5);
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.bezierVertex(f, f2, f3, f4, f5, f6);
        }
        this.g.bezierVertex(f, f2, f3, f4, f5, f6);
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.recorder != null) {
            this.recorder.bezierVertex(f, f2, f3, f4, f5, f6, f7, f8, f9);
        }
        this.g.bezierVertex(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public void curveVertex(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.curveVertex(f, f2);
        }
        this.g.curveVertex(f, f2);
    }

    public void curveVertex(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.curveVertex(f, f2, f3);
        }
        this.g.curveVertex(f, f2, f3);
    }

    public void breakShape() {
        if (this.recorder != null) {
            this.recorder.breakShape();
        }
        this.g.breakShape();
    }

    public final void endShape() {
        if (this.recorder != null) {
            this.recorder.endShape();
        }
        this.g.endShape();
    }

    public void endShape(int n) {
        if (this.recorder != null) {
            this.recorder.endShape(n);
        }
        this.g.endShape(n);
    }

    public void point(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.point(f, f2);
        }
        this.g.point(f, f2);
    }

    public void point(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.point(f, f2, f3);
        }
        this.g.point(f, f2, f3);
    }

    public void line(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.line(f, f2, f3, f4);
        }
        this.g.line(f, f2, f3, f4);
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.line(f, f2, f3, f4, f5, f6);
        }
        this.g.line(f, f2, f3, f4, f5, f6);
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.triangle(f, f2, f3, f4, f5, f6);
        }
        this.g.triangle(f, f2, f3, f4, f5, f6);
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.recorder != null) {
            this.recorder.quad(f, f2, f3, f4, f5, f6, f7, f8);
        }
        this.g.quad(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void rectMode(int n) {
        if (this.recorder != null) {
            this.recorder.rectMode(n);
        }
        this.g.rectMode(n);
    }

    public void rect(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.rect(f, f2, f3, f4);
        }
        this.g.rect(f, f2, f3, f4);
    }

    public void ellipseMode(int n) {
        if (this.recorder != null) {
            this.recorder.ellipseMode(n);
        }
        this.g.ellipseMode(n);
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.ellipse(f, f2, f3, f4);
        }
        this.g.ellipse(f, f2, f3, f4);
    }

    public void arc(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.arc(f, f2, f3, f4, f5, f6);
        }
        this.g.arc(f, f2, f3, f4, f5, f6);
    }

    public void box(float f) {
        if (this.recorder != null) {
            this.recorder.box(f);
        }
        this.g.box(f);
    }

    public void box(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.box(f, f2, f3);
        }
        this.g.box(f, f2, f3);
    }

    public void sphereDetail(int n) {
        if (this.recorder != null) {
            this.recorder.sphereDetail(n);
        }
        this.g.sphereDetail(n);
    }

    public void sphere(float f) {
        if (this.recorder != null) {
            this.recorder.sphere(f);
        }
        this.g.sphere(f);
    }

    public float bezierPoint(float f, float f2, float f3, float f4, float f5) {
        return this.g.bezierPoint(f, f2, f3, f4, f5);
    }

    public float bezierTangent(float f, float f2, float f3, float f4, float f5) {
        return this.g.bezierTangent(f, f2, f3, f4, f5);
    }

    public void bezierDetail(int n) {
        if (this.recorder != null) {
            this.recorder.bezierDetail(n);
        }
        this.g.bezierDetail(n);
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.recorder != null) {
            this.recorder.bezier(f, f2, f3, f4, f5, f6, f7, f8);
        }
        this.g.bezier(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (this.recorder != null) {
            this.recorder.bezier(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        }
        this.g.bezier(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public float curvePoint(float f, float f2, float f3, float f4, float f5) {
        return this.g.curvePoint(f, f2, f3, f4, f5);
    }

    public float curveTangent(float f, float f2, float f3, float f4, float f5) {
        return this.g.curveTangent(f, f2, f3, f4, f5);
    }

    public void curveDetail(int n) {
        if (this.recorder != null) {
            this.recorder.curveDetail(n);
        }
        this.g.curveDetail(n);
    }

    public void curveTightness(float f) {
        if (this.recorder != null) {
            this.recorder.curveTightness(f);
        }
        this.g.curveTightness(f);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.recorder != null) {
            this.recorder.curve(f, f2, f3, f4, f5, f6, f7, f8);
        }
        this.g.curve(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (this.recorder != null) {
            this.recorder.curve(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        }
        this.g.curve(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public void image(PImage pImage, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.image(pImage, f, f2);
        }
        this.g.image(pImage, f, f2);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.image(pImage, f, f2, f3, f4);
        }
        this.g.image(pImage, f, f2, f3, f4);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (this.recorder != null) {
            this.recorder.image(pImage, f, f2, f3, f4, n, n2, n3, n4);
        }
        this.g.image(pImage, f, f2, f3, f4, n, n2, n3, n4);
    }

    public void textAlign(int n) {
        if (this.recorder != null) {
            this.recorder.textAlign(n);
        }
        this.g.textAlign(n);
    }

    public float textAscent() {
        return this.g.textAscent();
    }

    public float textDescent() {
        return this.g.textDescent();
    }

    public void textFont(PFont pFont) {
        if (this.recorder != null) {
            this.recorder.textFont(pFont);
        }
        this.g.textFont(pFont);
    }

    public void textFont(PFont pFont, float f) {
        if (this.recorder != null) {
            this.recorder.textFont(pFont, f);
        }
        this.g.textFont(pFont, f);
    }

    public void textLeading(float f) {
        if (this.recorder != null) {
            this.recorder.textLeading(f);
        }
        this.g.textLeading(f);
    }

    public void textMode(int n) {
        if (this.recorder != null) {
            this.recorder.textMode(n);
        }
        this.g.textMode(n);
    }

    public void textSize(float f) {
        if (this.recorder != null) {
            this.recorder.textSize(f);
        }
        this.g.textSize(f);
    }

    public float textWidth(char c) {
        return this.g.textWidth(c);
    }

    public float textWidth(String string) {
        return this.g.textWidth(string);
    }

    public void text(char c) {
        if (this.recorder != null) {
            this.recorder.text(c);
        }
        this.g.text(c);
    }

    public void text(char c, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.text(c, f, f2);
        }
        this.g.text(c, f, f2);
    }

    public void text(char c, float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.text(c, f, f2, f3);
        }
        this.g.text(c, f, f2, f3);
    }

    public void text(String string) {
        if (this.recorder != null) {
            this.recorder.text(string);
        }
        this.g.text(string);
    }

    public void text(String string, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.text(string, f, f2);
        }
        this.g.text(string, f, f2);
    }

    public void text(String string, float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.text(string, f, f2, f3);
        }
        this.g.text(string, f, f2, f3);
    }

    public void text(String string, float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.text(string, f, f2, f3, f4);
        }
        this.g.text(string, f, f2, f3, f4);
    }

    public void text(String string, float f, float f2, float f3, float f4, float f5) {
        if (this.recorder != null) {
            this.recorder.text(string, f, f2, f3, f4, f5);
        }
        this.g.text(string, f, f2, f3, f4, f5);
    }

    public void text(int n, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.text(n, f, f2);
        }
        this.g.text(n, f, f2);
    }

    public void text(int n, float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.text(n, f, f2, f3);
        }
        this.g.text(n, f, f2, f3);
    }

    public void text(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.text(f, f2, f3);
        }
        this.g.text(f, f2, f3);
    }

    public void text(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.text(f, f2, f3, f4);
        }
        this.g.text(f, f2, f3, f4);
    }

    public void translate(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.translate(f, f2);
        }
        this.g.translate(f, f2);
    }

    public void translate(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.translate(f, f2, f3);
        }
        this.g.translate(f, f2, f3);
    }

    public void rotate(float f) {
        if (this.recorder != null) {
            this.recorder.rotate(f);
        }
        this.g.rotate(f);
    }

    public void rotateX(float f) {
        if (this.recorder != null) {
            this.recorder.rotateX(f);
        }
        this.g.rotateX(f);
    }

    public void rotateY(float f) {
        if (this.recorder != null) {
            this.recorder.rotateY(f);
        }
        this.g.rotateY(f);
    }

    public void rotateZ(float f) {
        if (this.recorder != null) {
            this.recorder.rotateZ(f);
        }
        this.g.rotateZ(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.rotate(f, f2, f3, f4);
        }
        this.g.rotate(f, f2, f3, f4);
    }

    public void scale(float f) {
        if (this.recorder != null) {
            this.recorder.scale(f);
        }
        this.g.scale(f);
    }

    public void scale(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.scale(f, f2);
        }
        this.g.scale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.scale(f, f2, f3);
        }
        this.g.scale(f, f2, f3);
    }

    public void pushMatrix() {
        if (this.recorder != null) {
            this.recorder.pushMatrix();
        }
        this.g.pushMatrix();
    }

    public void popMatrix() {
        if (this.recorder != null) {
            this.recorder.popMatrix();
        }
        this.g.popMatrix();
    }

    public void resetMatrix() {
        if (this.recorder != null) {
            this.recorder.resetMatrix();
        }
        this.g.resetMatrix();
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(f, f2, f3, f4, f5, f6);
        }
        this.g.applyMatrix(f, f2, f3, f4, f5, f6);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        }
        this.g.applyMatrix(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public void loadMatrix() {
        if (this.recorder != null) {
            this.recorder.loadMatrix();
        }
        this.g.loadMatrix();
    }

    public void printMatrix() {
        if (this.recorder != null) {
            this.recorder.printMatrix();
        }
        this.g.printMatrix();
    }

    public void beginCamera() {
        if (this.recorder != null) {
            this.recorder.beginCamera();
        }
        this.g.beginCamera();
    }

    public void endCamera() {
        if (this.recorder != null) {
            this.recorder.endCamera();
        }
        this.g.endCamera();
    }

    public void camera() {
        if (this.recorder != null) {
            this.recorder.camera();
        }
        this.g.camera();
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.recorder != null) {
            this.recorder.camera(f, f2, f3, f4, f5, f6, f7, f8, f9);
        }
        this.g.camera(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public void printCamera() {
        if (this.recorder != null) {
            this.recorder.printCamera();
        }
        this.g.printCamera();
    }

    public void ortho() {
        if (this.recorder != null) {
            this.recorder.ortho();
        }
        this.g.ortho();
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.ortho(f, f2, f3, f4, f5, f6);
        }
        this.g.ortho(f, f2, f3, f4, f5, f6);
    }

    public void perspective() {
        if (this.recorder != null) {
            this.recorder.perspective();
        }
        this.g.perspective();
    }

    public void perspective(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.perspective(f, f2, f3, f4);
        }
        this.g.perspective(f, f2, f3, f4);
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.frustum(f, f2, f3, f4, f5, f6);
        }
        this.g.frustum(f, f2, f3, f4, f5, f6);
    }

    public void printProjection() {
        if (this.recorder != null) {
            this.recorder.printProjection();
        }
        this.g.printProjection();
    }

    public float screenX(float f, float f2) {
        return this.g.screenX(f, f2);
    }

    public float screenY(float f, float f2) {
        return this.g.screenY(f, f2);
    }

    public float screenX(float f, float f2, float f3) {
        return this.g.screenX(f, f2, f3);
    }

    public float screenY(float f, float f2, float f3) {
        return this.g.screenY(f, f2, f3);
    }

    public float screenZ(float f, float f2, float f3) {
        return this.g.screenZ(f, f2, f3);
    }

    public float modelX(float f, float f2, float f3) {
        return this.g.modelX(f, f2, f3);
    }

    public float modelY(float f, float f2, float f3) {
        return this.g.modelY(f, f2, f3);
    }

    public float modelZ(float f, float f2, float f3) {
        return this.g.modelZ(f, f2, f3);
    }

    public void colorMode(int n) {
        if (this.recorder != null) {
            this.recorder.colorMode(n);
        }
        this.g.colorMode(n);
    }

    public void colorMode(int n, float f) {
        if (this.recorder != null) {
            this.recorder.colorMode(n, f);
        }
        this.g.colorMode(n, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.colorMode(n, f, f2, f3);
        }
        this.g.colorMode(n, f, f2, f3);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.colorMode(n, f, f2, f3, f4);
        }
        this.g.colorMode(n, f, f2, f3, f4);
    }

    public void strokeWeight(float f) {
        if (this.recorder != null) {
            this.recorder.strokeWeight(f);
        }
        this.g.strokeWeight(f);
    }

    public void strokeJoin(int n) {
        if (this.recorder != null) {
            this.recorder.strokeJoin(n);
        }
        this.g.strokeJoin(n);
    }

    public void strokeCap(int n) {
        if (this.recorder != null) {
            this.recorder.strokeCap(n);
        }
        this.g.strokeCap(n);
    }

    public void noStroke() {
        if (this.recorder != null) {
            this.recorder.noStroke();
        }
        this.g.noStroke();
    }

    public void stroke(int n) {
        if (this.recorder != null) {
            this.recorder.stroke(n);
        }
        this.g.stroke(n);
    }

    public void stroke(int n, float f) {
        if (this.recorder != null) {
            this.recorder.stroke(n, f);
        }
        this.g.stroke(n, f);
    }

    public void stroke(float f) {
        if (this.recorder != null) {
            this.recorder.stroke(f);
        }
        this.g.stroke(f);
    }

    public void stroke(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.stroke(f, f2);
        }
        this.g.stroke(f, f2);
    }

    public void stroke(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.stroke(f, f2, f3);
        }
        this.g.stroke(f, f2, f3);
    }

    public void stroke(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.stroke(f, f2, f3, f4);
        }
        this.g.stroke(f, f2, f3, f4);
    }

    public void noTint() {
        if (this.recorder != null) {
            this.recorder.noTint();
        }
        this.g.noTint();
    }

    public void tint(int n) {
        if (this.recorder != null) {
            this.recorder.tint(n);
        }
        this.g.tint(n);
    }

    public void tint(int n, float f) {
        if (this.recorder != null) {
            this.recorder.tint(n, f);
        }
        this.g.tint(n, f);
    }

    public void tint(float f) {
        if (this.recorder != null) {
            this.recorder.tint(f);
        }
        this.g.tint(f);
    }

    public void tint(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.tint(f, f2);
        }
        this.g.tint(f, f2);
    }

    public void tint(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.tint(f, f2, f3);
        }
        this.g.tint(f, f2, f3);
    }

    public void tint(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.tint(f, f2, f3, f4);
        }
        this.g.tint(f, f2, f3, f4);
    }

    public void noFill() {
        if (this.recorder != null) {
            this.recorder.noFill();
        }
        this.g.noFill();
    }

    public void fill(int n) {
        if (this.recorder != null) {
            this.recorder.fill(n);
        }
        this.g.fill(n);
    }

    public void fill(int n, float f) {
        if (this.recorder != null) {
            this.recorder.fill(n, f);
        }
        this.g.fill(n, f);
    }

    public void fill(float f) {
        if (this.recorder != null) {
            this.recorder.fill(f);
        }
        this.g.fill(f);
    }

    public void fill(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.fill(f, f2);
        }
        this.g.fill(f, f2);
    }

    public void fill(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.fill(f, f2, f3);
        }
        this.g.fill(f, f2, f3);
    }

    public void fill(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.fill(f, f2, f3, f4);
        }
        this.g.fill(f, f2, f3, f4);
    }

    public void ambient(int n) {
        if (this.recorder != null) {
            this.recorder.ambient(n);
        }
        this.g.ambient(n);
    }

    public void ambient(float f) {
        if (this.recorder != null) {
            this.recorder.ambient(f);
        }
        this.g.ambient(f);
    }

    public void ambient(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.ambient(f, f2, f3);
        }
        this.g.ambient(f, f2, f3);
    }

    public void specular(int n) {
        if (this.recorder != null) {
            this.recorder.specular(n);
        }
        this.g.specular(n);
    }

    public void specular(float f) {
        if (this.recorder != null) {
            this.recorder.specular(f);
        }
        this.g.specular(f);
    }

    public void specular(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.specular(f, f2);
        }
        this.g.specular(f, f2);
    }

    public void specular(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.specular(f, f2, f3);
        }
        this.g.specular(f, f2, f3);
    }

    public void specular(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.specular(f, f2, f3, f4);
        }
        this.g.specular(f, f2, f3, f4);
    }

    public void shininess(float f) {
        if (this.recorder != null) {
            this.recorder.shininess(f);
        }
        this.g.shininess(f);
    }

    public void emissive(int n) {
        if (this.recorder != null) {
            this.recorder.emissive(n);
        }
        this.g.emissive(n);
    }

    public void emissive(float f) {
        if (this.recorder != null) {
            this.recorder.emissive(f);
        }
        this.g.emissive(f);
    }

    public void emissive(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.emissive(f, f2, f3);
        }
        this.g.emissive(f, f2, f3);
    }

    public void lights() {
        if (this.recorder != null) {
            this.recorder.lights();
        }
        this.g.lights();
    }

    public void ambientLight(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.ambientLight(f, f2, f3);
        }
        this.g.ambientLight(f, f2, f3);
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.ambientLight(f, f2, f3, f4, f5, f6);
        }
        this.g.ambientLight(f, f2, f3, f4, f5, f6);
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.directionalLight(f, f2, f3, f4, f5, f6);
        }
        this.g.directionalLight(f, f2, f3, f4, f5, f6);
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.pointLight(f, f2, f3, f4, f5, f6);
        }
        this.g.pointLight(f, f2, f3, f4, f5, f6);
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (this.recorder != null) {
            this.recorder.spotLight(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
        }
        this.g.spotLight(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
    }

    public void lightFalloff(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.lightFalloff(f, f2, f3);
        }
        this.g.lightFalloff(f, f2, f3);
    }

    public void lightSpecular(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.lightSpecular(f, f2, f3);
        }
        this.g.lightSpecular(f, f2, f3);
    }

    public void background(int n) {
        if (this.recorder != null) {
            this.recorder.background(n);
        }
        this.g.background(n);
    }

    public void background(int n, float f) {
        if (this.recorder != null) {
            this.recorder.background(n, f);
        }
        this.g.background(n, f);
    }

    public void background(float f) {
        if (this.recorder != null) {
            this.recorder.background(f);
        }
        this.g.background(f);
    }

    public void background(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.background(f, f2);
        }
        this.g.background(f, f2);
    }

    public void background(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.background(f, f2, f3);
        }
        this.g.background(f, f2, f3);
    }

    public void background(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.background(f, f2, f3, f4);
        }
        this.g.background(f, f2, f3, f4);
    }

    public void background(PImage pImage) {
        if (this.recorder != null) {
            this.recorder.background(pImage);
        }
        this.g.background(pImage);
    }

    public final float alpha(int n) {
        return this.g.alpha(n);
    }

    public final float red(int n) {
        return this.g.red(n);
    }

    public final float green(int n) {
        return this.g.green(n);
    }

    public final float blue(int n) {
        return this.g.blue(n);
    }

    public final float hue(int n) {
        return this.g.hue(n);
    }

    public final float saturation(int n) {
        return this.g.saturation(n);
    }

    public final float brightness(int n) {
        return this.g.brightness(n);
    }

    public int lerpColor(int n, int n2, float f) {
        return this.g.lerpColor(n, n2, f);
    }

    public static int lerpColor(int n, int n2, float f, int n3) {
        return PGraphics.lerpColor(n, n2, f, n3);
    }

    public void beginRaw(PGraphics pGraphics) {
        if (this.recorder != null) {
            this.recorder.beginRaw(pGraphics);
        }
        this.g.beginRaw(pGraphics);
    }

    public void endRaw() {
        if (this.recorder != null) {
            this.recorder.endRaw();
        }
        this.g.endRaw();
    }

    public boolean displayable() {
        return this.g.displayable();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.blocker = new Object();
        this.focused = false;
        this.online = false;
        this.frameRate = 10.0f;
        this.frameRateLastMillis = 0L;
        this.frameRateLastDelayTime = 0L;
        this.frameRateTarget = 60.0f;
        this.mouseEventQueue = new MouseEvent[10];
        this.keyEventQueue = new KeyEvent[10];
        this.cursorType = 0;
        this.cursorVisible = true;
        this.perlin_octaves = 4;
        this.perlin_amp_falloff = 0.5f;
    }

    public PApplet() {
        this.this();
    }

    static {
        platformName = System.getProperty("os.name");
        if (platformName.toLowerCase().indexOf("mac") != -1) {
            if (System.getProperty("mrj.version") != null) {
                platform = platformName.equals("Mac OS X") + 2;
            }
        } else {
            String string = System.getProperty("os.name");
            platform = string.indexOf("Windows") != -1 ? 1 : (string.equals("Linux") ? 4 : 0);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class RegisteredMethods {
        int count;
        Object[] objects;
        Method[] methods;

        public void handle() {
            this.handle(new Object[0]);
        }

        public void handle(Object[] objectArray) {
            int n = 0;
            while (n < this.count) {
                try {
                    this.methods[n].invoke(this.objects[n], objectArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }

        public void add(Object object, Method method) {
            if (this.objects == null) {
                this.objects = new Object[5];
                this.methods = new Method[5];
            }
            if (this.count == this.objects.length) {
                Object[] objectArray = new Object[this.count << 1];
                System.arraycopy(this.objects, 0, objectArray, 0, this.count);
                this.objects = objectArray;
                Method[] methodArray = new Method[this.count << 1];
                System.arraycopy(this.methods, 0, methodArray, 0, this.count);
                this.methods = methodArray;
            }
            this.objects[this.count] = object;
            this.methods[this.count] = method;
            ++this.count;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Worker {
        private Object value;
        private WorkerVar workerVar;

        protected synchronized Object getValue() {
            return this.value;
        }

        private final synchronized void setValue(Object object) {
            this.value = object;
        }

        public Object construct() {
            try {
                int n = System.in.read();
                if (n == 115) {
                    PApplet.this.stop();
                    PApplet.this.finished = true;
                }
            }
            catch (IOException iOException) {
                PApplet.this.finished = true;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            return null;
        }

        public void interrupt() {
            Thread thread = this.workerVar.get();
            if (thread != null) {
                thread.interrupt();
            }
            this.workerVar.clear();
        }

        public Object get() {
            Thread thread;
            while ((thread = this.workerVar.get()) != null) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.getValue();
        }

        public void start() {
            Thread thread = this.workerVar.get();
            if (thread != null) {
                thread.start();
            }
        }

        public Worker() {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void run() {
                    try {
                        Worker.this.setValue(Worker.this.construct());
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        Worker.this.workerVar.clear();
                        throw throwable;
                    }
                    {
                        Object var2_3 = null;
                        Worker.this.workerVar.clear();
                        return;
                    }
                }
            };
            Thread thread = new Thread(runnable);
            this.workerVar = new WorkerVar(thread);
        }
    }

    private static class WorkerVar {
        private Thread thread;

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }

        WorkerVar(Thread thread) {
            this.thread = thread;
        }
    }
}

