/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PFont
implements PConstants {
    static final char[] EXTRA_CHARS = new char[]{'\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00ba', '\u00bb', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00ff', '\u0102', '\u0103', '\u0104', '\u0105', '\u0106', '\u0107', '\u010c', '\u010d', '\u010e', '\u010f', '\u0110', '\u0111', '\u0118', '\u0119', '\u011a', '\u011b', '\u0131', '\u0139', '\u013a', '\u013d', '\u013e', '\u0141', '\u0142', '\u0143', '\u0144', '\u0147', '\u0148', '\u0150', '\u0151', '\u0152', '\u0153', '\u0154', '\u0155', '\u0158', '\u0159', '\u015a', '\u015b', '\u015e', '\u015f', '\u0160', '\u0161', '\u0162', '\u0163', '\u0164', '\u0165', '\u016e', '\u016f', '\u0170', '\u0171', '\u0178', '\u0179', '\u017a', '\u017b', '\u017c', '\u017d', '\u017e', '\u0192', '\u02c6', '\u02c7', '\u02d8', '\u02d9', '\u02da', '\u02db', '\u02dc', '\u02dd', '\u03a9', '\u03c0', '\u2013', '\u2014', '\u2018', '\u2019', '\u201a', '\u201c', '\u201d', '\u201e', '\u2020', '\u2021', '\u2022', '\u2026', '\u2030', '\u2039', '\u203a', '\u2044', '\u20ac', '\u2122', '\u2202', '\u2206', '\u220f', '\u2211', '\u221a', '\u221e', '\u222b', '\u2248', '\u2260', '\u2264', '\u2265', '\u25ca', '\uf8ff', '\ufb01', '\ufb02'};
    public static char[] DEFAULT_CHARSET = new char[94 + EXTRA_CHARS.length];
    public int charCount;
    public PImage[] images;
    public Font font;
    public String name;
    public String psname;
    public int size;
    public boolean smooth;
    public int mbox2;
    protected float fwidth;
    protected float fheight;
    public int twidth;
    public int theight;
    public int[] value;
    public int[] height;
    public int[] width;
    public int[] setWidth;
    public int[] topExtent;
    public int[] leftExtent;
    public int ascent;
    public int descent;
    protected int[] ascii;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Font;

    protected Font findFont() {
        this.font = new Font(this.name, 0, this.size);
        if (!this.font.getPSName().equals(this.psname)) {
            this.font = new Font(this.psname, 0, this.size);
        }
        if (!this.font.getPSName().equals(this.psname)) {
            this.font = null;
        }
        return this.font;
    }

    public void save(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.charCount);
        if (this.name == null || this.psname == null) {
            this.name = "";
            this.psname = "";
        }
        dataOutputStream.writeInt(11);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeInt(this.mbox2);
        dataOutputStream.writeInt(this.ascent);
        dataOutputStream.writeInt(this.descent);
        int n = 0;
        while (n < this.charCount) {
            dataOutputStream.writeInt(this.value[n]);
            dataOutputStream.writeInt(this.height[n]);
            dataOutputStream.writeInt(this.width[n]);
            dataOutputStream.writeInt(this.setWidth[n]);
            dataOutputStream.writeInt(this.topExtent[n]);
            dataOutputStream.writeInt(this.leftExtent[n]);
            dataOutputStream.writeInt(0);
            ++n;
        }
        n = 0;
        while (n < this.charCount) {
            int n2 = 0;
            while (n2 < this.height[n]) {
                int n3 = 0;
                while (n3 < this.width[n]) {
                    dataOutputStream.write(this.images[n].pixels[n2 * this.mbox2 + n3] & 0xFF);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeUTF(this.psname);
        dataOutputStream.writeBoolean(this.smooth);
        dataOutputStream.flush();
    }

    public int index(char c) {
        if (this.charCount == 0) {
            return -1;
        }
        if (c < '\u0080') {
            return this.ascii[c];
        }
        return this.indexHunt(c, 0, this.charCount - 1);
    }

    protected int indexHunt(int n, int n2, int n3) {
        int n4 = (n2 + n3) / 2;
        if (n == this.value[n4]) {
            return n4;
        }
        if (n2 >= n3) {
            return -1;
        }
        if (n < this.value[n4]) {
            return this.indexHunt(n, n2, n4 - 1);
        }
        return this.indexHunt(n, n4 + 1, n3);
    }

    public float kern(char c, char c2) {
        return 0.0f;
    }

    public float ascent() {
        return (float)this.ascent / this.fheight;
    }

    public float descent() {
        return (float)this.descent / this.fheight;
    }

    public float width(char c) {
        if (c == ' ') {
            return this.width('i');
        }
        int n = this.index(c);
        if (n == -1) {
            return 0.0f;
        }
        return (float)this.setWidth[n] / this.fwidth;
    }

    public static String[] list() {
        if (PApplet.javaVersion < 1.3f) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Method method = toolkit.getClass().getMethod("getFontList", null);
                return (String[])method.invoke((Object)toolkit, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new String[0];
            }
        }
        try {
            Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
            Method method = clazz.getMethod("getLocalGraphicsEnvironment", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getMethod("getAllFonts", null);
            Font[] fontArray = (Font[])method2.invoke(object, null);
            String[] stringArray = new String[fontArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = fontArray[n].getName();
                ++n;
            }
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Error inside PFont.list()");
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PFont() {
    }

    public PFont(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.charCount = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        this.size = dataInputStream.readInt();
        this.mbox2 = dataInputStream.readInt();
        this.fwidth = this.size;
        this.fheight = this.size;
        this.twidth = this.theight = (this.mbox2 = (int)Math.pow(2, Math.ceil(Math.log(this.mbox2) / Math.log(2))));
        this.ascent = dataInputStream.readInt();
        this.descent = dataInputStream.readInt();
        this.value = new int[this.charCount];
        this.height = new int[this.charCount];
        this.width = new int[this.charCount];
        this.setWidth = new int[this.charCount];
        this.topExtent = new int[this.charCount];
        this.leftExtent = new int[this.charCount];
        this.ascii = new int[128];
        int n2 = 0;
        while (n2 < 128) {
            this.ascii[n2] = -1;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.charCount) {
            this.value[n2] = dataInputStream.readInt();
            this.height[n2] = dataInputStream.readInt();
            this.width[n2] = dataInputStream.readInt();
            this.setWidth[n2] = dataInputStream.readInt();
            this.topExtent[n2] = dataInputStream.readInt();
            this.leftExtent[n2] = dataInputStream.readInt();
            dataInputStream.readInt();
            if (this.value[n2] < 128) {
                this.ascii[this.value[n2]] = n2;
            }
            if (this.value[n2] == 100 && this.ascent == 0) {
                this.ascent = this.topExtent[n2];
            }
            if (this.value[n2] == 112 && this.descent == 0) {
                this.descent = -this.topExtent[n2] + this.height[n2];
            }
            ++n2;
        }
        if (this.ascent == 0 && this.descent == 0) {
            throw new RuntimeException("Please use \"Create Font\" to re-create this font.");
        }
        this.images = new PImage[this.charCount];
        n2 = 0;
        while (n2 < this.charCount) {
            this.images[n2] = new PImage(this.twidth, this.theight, 4);
            int n3 = this.height[n2] * this.width[n2];
            byte[] byArray = new byte[n3];
            dataInputStream.readFully(byArray);
            int n4 = this.width[n2];
            int n5 = this.height[n2];
            int n6 = 0;
            while (n6 < n5) {
                int n7 = 0;
                while (n7 < n4) {
                    int n8;
                    this.images[n2].pixels[n6 * this.twidth + n7] = n8 = byArray[n6 * n4 + n7] & 0xFF;
                    ++n7;
                }
                ++n6;
            }
            ++n2;
        }
        if (n >= 10) {
            this.name = dataInputStream.readUTF();
            this.psname = dataInputStream.readUTF();
        }
        if (n == 11) {
            this.smooth = dataInputStream.readBoolean();
        }
    }

    public PFont(Font font, boolean bl, char[] cArray) {
        if (PApplet.javaVersion < 1.3f) {
            throw new RuntimeException("Can only create fonts with Java 1.3 or higher");
        }
        this.font = font;
        this.smooth = bl;
        this.name = font.getName();
        this.psname = font.getPSName();
        try {
            char c;
            Class<?> clazz = Class.forName("java.util.Arrays");
            Method method = clazz.getMethod("sort", cArray.getClass());
            method.invoke(null, new Object[]{cArray});
            this.charCount = cArray == null ? 65536 : cArray.length;
            this.size = font.getSize();
            this.fwidth = this.fheight = (float)this.size;
            PImage[] pImageArray = new PImage[this.charCount];
            this.value = new int[this.charCount];
            this.height = new int[this.charCount];
            this.width = new int[this.charCount];
            this.setWidth = new int[this.charCount];
            this.topExtent = new int[this.charCount];
            this.leftExtent = new int[this.charCount];
            this.ascii = new int[128];
            int n = 0;
            while (n < 128) {
                this.ascii[n] = -1;
                ++n;
            }
            n = this.size * 3;
            Class<?> clazz2 = Class.forName("java.awt.image.BufferedImage");
            Constructor<?> constructor = clazz2.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Field field = clazz2.getField("TYPE_INT_RGB");
            int n2 = field.getInt(field);
            Object obj = constructor.newInstance(new Integer(n), new Integer(n), new Integer(n2));
            Class<?> clazz3 = Class.forName("java.awt.Graphics2D");
            Method method2 = clazz2.getMethod("getGraphics", new Class[0]);
            Graphics graphics = (Graphics)method2.invoke(obj, new Object[0]);
            Class<?> clazz4 = Class.forName("java.awt.RenderingHints");
            Class<?> clazz5 = Class.forName("java.awt.RenderingHints$Key");
            Field field2 = clazz4.getField("KEY_TEXT_ANTIALIASING");
            Object object = field2.get(clazz4);
            Field field3 = bl ? clazz4.getField("VALUE_TEXT_ANTIALIAS_ON") : clazz4.getField("VALUE_TEXT_ANTIALIAS_OFF");
            Object object2 = field3.get(clazz4);
            Class[] classArray = new Class[2];
            classArray[0] = clazz5;
            Class clazz6 = class$java$lang$Object;
            if (clazz6 == null) {
                clazz6 = class$java$lang$Object = PFont.class("[Ljava.lang.Object;", false);
            }
            classArray[1] = clazz6;
            Method method3 = clazz3.getMethod("setRenderingHint", classArray);
            method3.invoke((Object)graphics, object, object2);
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Method method4 = null;
            Method method5 = null;
            Method method6 = null;
            int[] nArray = new int[n * n];
            Class clazz7 = class$java$awt$Font;
            if (clazz7 == null) {
                clazz7 = class$java$awt$Font = PFont.class("[Ljava.awt.Font;", false);
            }
            method4 = clazz7.getMethod("canDisplay", Character.TYPE);
            method5 = clazz2.getMethod("getData", new Class[0]);
            Class<?> clazz8 = Class.forName("java.awt.image.Raster");
            method6 = clazz8.getMethod("getSamples", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, nArray.getClass());
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.charCount) {
                block32: {
                    int n6;
                    int n7;
                    Object object3;
                    block31: {
                        c = cArray == null ? (char)n5 : cArray[n5];
                        try {
                            object3 = new Character(c);
                            Boolean bl2 = (Boolean)method4.invoke((Object)font, object3);
                            if (bl2.booleanValue()) break block31;
                            break block32;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return;
                        }
                    }
                    graphics.setColor(Color.white);
                    graphics.fillRect(0, 0, n, n);
                    graphics.setColor(Color.black);
                    graphics.drawString(String.valueOf(c), this.size, this.size * 2);
                    object3 = method5.invoke(obj, new Object[0]);
                    method6.invoke(object3, new Integer(0), new Integer(0), new Integer(n), new Integer(n), new Integer(0), nArray);
                    int n8 = 1000;
                    int n9 = 0;
                    int n10 = 1000;
                    int n11 = 0;
                    boolean bl3 = false;
                    int n12 = 0;
                    while (n12 < n) {
                        n7 = 0;
                        while (n7 < n) {
                            n6 = nArray[n12 * n + n7] & 0xFF;
                            if (n6 != 255) {
                                if (n7 < n8) {
                                    n8 = n7;
                                }
                                if (n12 < n10) {
                                    n10 = n12;
                                }
                                if (n7 > n9) {
                                    n9 = n7;
                                }
                                if (n12 > n11) {
                                    n11 = n12;
                                }
                                bl3 = true;
                            }
                            ++n7;
                        }
                        ++n12;
                    }
                    if (!bl3) {
                        n10 = 0;
                        n8 = 0;
                        n11 = 0;
                        n9 = 0;
                    }
                    this.value[n4] = c;
                    this.height[n4] = n11 - n10 + 1;
                    this.width[n4] = n9 - n8 + 1;
                    this.setWidth[n4] = fontMetrics.charWidth(c);
                    if (c < '\u0080') {
                        this.ascii[c] = n4;
                    }
                    this.topExtent[n4] = this.size * 2 - n10;
                    this.leftExtent[n4] = n8 - this.size;
                    if (c == 'd') {
                        this.ascent = this.topExtent[n4];
                    }
                    if (c == 'p') {
                        this.descent = -this.topExtent[n4] + this.height[n4];
                    }
                    if (this.width[n4] > n3) {
                        n3 = this.width[n4];
                    }
                    if (this.height[n4] > n3) {
                        n3 = this.height[n4];
                    }
                    pImageArray[n4] = new PImage(this.width[n4], this.height[n4], 4);
                    n12 = n10;
                    while (n12 <= n11) {
                        n7 = n8;
                        while (n7 <= n9) {
                            n6 = 255 - (nArray[n12 * n + n7] & 0xFF);
                            int n13 = (n12 - n10) * this.width[n4] + (n7 - n8);
                            pImageArray[n4].pixels[n13] = n6;
                            ++n7;
                        }
                        ++n12;
                    }
                    ++n4;
                }
                ++n5;
            }
            this.charCount = n4;
            if (this.ascent == 0 && this.descent == 0) {
                n5 = 0;
                while (n5 < this.charCount) {
                    c = (char)this.value[n5];
                    if (!Character.isWhitespace(c) && c != '\u00a0' && c != '\u2007' && c != '\u202f') {
                        int n14;
                        if (this.topExtent[n5] > this.ascent) {
                            this.ascent = this.topExtent[n5];
                        }
                        if ((n14 = -this.topExtent[n5] + this.height[n5]) > this.descent) {
                            this.descent = n14;
                        }
                    }
                    ++n5;
                }
            }
            this.twidth = this.theight = (this.mbox2 = (int)Math.pow(2, Math.ceil(Math.log(n3) / Math.log(2))));
            this.images = new PImage[this.charCount];
            n5 = 0;
            while (n5 < this.charCount) {
                this.images[n5] = new PImage(this.mbox2, this.mbox2, 4);
                c = '\u0000';
                while (c < this.height[n5]) {
                    System.arraycopy(pImageArray[n5].pixels, c * this.width[n5], this.images[n5].pixels, c * this.mbox2, this.width[n5]);
                    ++c;
                }
                pImageArray[n5] = null;
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    static {
        int n = 0;
        int n2 = 33;
        while (n2 <= 126) {
            PFont.DEFAULT_CHARSET[n++] = (char)n2;
            ++n2;
        }
        n2 = 0;
        while (n2 < EXTRA_CHARS.length) {
            PFont.DEFAULT_CHARSET[n++] = EXTRA_CHARS[n2];
            ++n2;
        }
    }
}

